/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom.subclass;

import emulator.custom.subclass.SubTimerTask;

class TaskQueue {
    private SubTimerTask[] queue = new SubTimerTask[4];
    private int size = 0;
    boolean newTasksMayBeScheduled = true;

    TaskQueue() {
    }

    void add(SubTimerTask subTimerTask) {
        if (++this.size == this.queue.length) {
            SubTimerTask[] queue = new SubTimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, queue, 0, this.size);
            this.queue = queue;
        }
        this.queue[this.size] = subTimerTask;
        this.fixUp(this.size);
    }

    SubTimerTask getMin() {
        return this.queue[1];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long nextExecutionTime) {
        this.queue[1].nextExecutionTime = nextExecutionTime;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    private void fixUp(int i2) {
        while (i2 > 1) {
            int n = i2 >> 1;
            if (this.queue[n].nextExecutionTime <= this.queue[i2].nextExecutionTime) {
                return;
            }
            SubTimerTask subTimerTask = this.queue[n];
            this.queue[n] = this.queue[i2];
            this.queue[i2] = subTimerTask;
            i2 = n;
        }
    }

    private void fixDown(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.queue[n2].nextExecutionTime > this.queue[n2 + 1].nextExecutionTime) {
                ++n2;
            }
            if (this.queue[n].nextExecutionTime <= this.queue[n2].nextExecutionTime) {
                return;
            }
            SubTimerTask subTimerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = subTimerTask;
            n = n2;
        }
    }
}

