/*
 * Decompiled with CFR 0.152.
 */
package emulator.debug;

import emulator.debug.Memory;
import emulator.debug.ObjInstance;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public final class ClassInfo
implements Comparable<ClassInfo> {
    final String name;
    int instancesCount = 0;
    final int staticsSize;
    public final ArrayList<ObjInstance> objs = new ArrayList();
    public final IdentityHashMap<Object, ObjInstance> objsMap = new IdentityHashMap();
    public final Field[] cachedFields;

    public int size() {
        int total = this.staticsSize;
        for (int i2 = this.objs.size() - 1; i2 >= 0; --i2) {
            total += this.objs.get((int)i2).size;
        }
        return total;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.name.compareTo(o.name);
    }

    ClassInfo(Memory m2, Class cls) {
        this.cachedFields = Memory.fields(cls);
        this.staticsSize = m2.size(cls, this.cachedFields, null);
        this.name = cls.getName();
    }
}

