/*
 * Decompiled with CFR 0.152.
 */
package emulator.debug;

import com.nokia.mid.sound.Sound;
import com.samsung.util.AudioClip;
import emulator.Emulator;
import emulator.Settings;
import emulator.debug.ClassInfo;
import emulator.debug.ClassTypes;
import emulator.debug.IdentityWrapper;
import emulator.debug.MemoryViewImage;
import emulator.debug.MemoryViewImageType;
import emulator.debug.ObjInstance;
import emulator.debug.ReferencePath;
import emulator.graphics2D.IImage;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerImpl;
import org.apache.tools.zip.ZipFile;

public final class Memory {
    public HashMap<String, ClassInfo> classesTable = new HashMap();
    public HashSet<IdentityWrapper> instances;
    public ArrayList<Image> images = new ArrayList();
    public ArrayList<Image> releasedImages = new ArrayList();
    public Vector players = new Vector();
    public Vector m3gObjects = new Vector();
    private final Vector<String> checkClasses = new Vector();
    static Class _J;
    static Class _I;
    static Class _S;
    static Class _B;
    static Class _Z;
    static Class _F;
    static Class _D;
    static Class _C;
    public static final Object m3gLock;
    private static Memory inst;
    private static int bytecodeSize;

    public static Memory getInstance() {
        if (inst == null) {
            inst = new Memory();
        }
        return inst;
    }

    private Memory() {
        this.instances = new HashSet();
        this.checkClasses.add("javax.microedition.lcdui.ImageItem");
        this.checkClasses.add("javax.microedition.lcdui.CustomItem");
        this.checkClasses.add("javax.microedition.lcdui.List");
        this.checkClasses.add("javax.microedition.lcdui.ChoiceGroup");
        this.checkClasses.add("javax.microedition.lcdui.Display");
        this.checkClasses.add("javax.microedition.lcdui.Form");
        this.checkClasses.add("javax.microedition.lcdui.Graphics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateEverything() {
        Class cls;
        if (Settings.recordReleasedImg) {
            for (Image image : this.images) {
                if (this.releasedImages.contains(image)) continue;
                this.releasedImages.add(image);
            }
        }
        this.classesTable.clear();
        this.instances.clear();
        this.images.clear();
        this.m3gObjects.clear();
        try {
            this.players.clear();
            this.players.addAll(PlayerImpl.players);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        for (String s : Emulator.jarClasses) {
            Object o;
            cls = null;
            if (Emulator.getMIDlet().getClass().getName().equals(s)) {
                cls = Memory.cls(s);
                o = Emulator.getMIDlet();
            } else if (Emulator.getCurrentDisplay() != null && Emulator.getCurrentDisplay().getCurrent() != null && Emulator.getCurrentDisplay().getCurrent().getClass().getName().equals(s)) {
                cls = Memory.cls(s);
                o = Emulator.getCurrentDisplay().getCurrent();
            } else {
                try {
                    cls = Memory.cls(s);
                }
                catch (Throwable e3) {
                    e3.printStackTrace();
                }
                o = null;
            }
            if (cls == null) continue;
            this.collectObjects(cls, o, new ReferencePath(s, o != null), false);
        }
        for (String checkClass : this.checkClasses) {
            cls = null;
            try {
                cls = Memory.cls(checkClass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cls == null) continue;
            this.collectObjects(cls, null, new ReferencePath(checkClass, true), false);
        }
        if (this.m3gObjects.size() == 0) {
            return;
        }
        if (Settings.g3d == 1) {
            for (int i2 = 0; i2 < this.m3gObjects.size(); ++i2) {
                this.m3gReadTextures(this.m3gObjects.elementAt(i2));
            }
            return;
        }
        try {
            Object object = m3gLock;
            synchronized (object) {
                Thread.sleep(5L);
                for (int i3 = 0; i3 < this.m3gObjects.size(); ++i3) {
                    this.m3gReadTextures(this.m3gObjects.elementAt(i3));
                    Thread.yield();
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collectObjects(Class clazz, Object o, ReferencePath path, boolean vector2) {
        ClassInfo classInfo;
        if (clazz.isInterface()) {
            return;
        }
        String clazzName = clazz.getName();
        if (clazz.isArray()) {
            clazzName = ClassTypes.getReadableClassName(clazz);
        }
        if ((classInfo = this.classesTable.get(clazzName)) == null) {
            classInfo = new ClassInfo(this, clazz);
            this.classesTable.put(clazzName, classInfo);
        } else if (o == null) {
            return;
        }
        if (o != null) {
            IdentityWrapper ow = new IdentityWrapper(o);
            if (this.instances.contains(ow)) {
                ObjInstance foundInst = classInfo.objsMap.get(o);
                if (foundInst != null) {
                    foundInst.paths.add(path);
                }
                return;
            }
            ++classInfo.instancesCount;
            ObjInstance inst = new ObjInstance(this, classInfo, path, o);
            classInfo.objs.add(inst);
            classInfo.objsMap.put(o, inst);
            this.instances.add(ow);
            try {
                if (o instanceof Image) {
                    this.images.add((Image)o);
                    if (Settings.recordReleasedImg && this.releasedImages.contains(o)) {
                        this.releasedImages.remove(o);
                    }
                    return;
                }
                if (o instanceof Sound || o instanceof AudioClip || o instanceof Player) {
                    if (!this.players.contains(o)) {
                        this.players.add(o);
                    }
                    return;
                }
                if (o instanceof Node) {
                    this.m3gObjects.add(o);
                    return;
                }
                if (o instanceof Image2D) {
                    IImage img = MemoryViewImage.createFromM3GImage((Image2D)o);
                    if (img != null) {
                        MemoryViewImage mvi = new MemoryViewImage(img, MemoryViewImageType.M3G, o);
                        this.images.add(mvi);
                        int i2 = this.releasedImages.indexOf(mvi);
                        if (i2 >= 0) {
                            this.releasedImages.remove(i2);
                        }
                    }
                    return;
                }
                if (o.getClass().getName().equals("com.mascotcapsule.micro3d.v3.Texture") && Emulator.getPlatform().supportsMascotCapsule()) {
                    IImage img = MemoryViewImage.createFromMicro3DTexture(o);
                    if (img != null) {
                        MemoryViewImage mvi = new MemoryViewImage(img, MemoryViewImageType.Micro3D, o);
                        this.images.add(mvi);
                        int i3 = this.releasedImages.indexOf(mvi);
                        if (i3 >= 0) {
                            this.releasedImages.remove(i3);
                        }
                    }
                    return;
                }
                if (o instanceof Object3D) {
                    this.iterateFields(clazz, classInfo.cachedFields, o, path);
                    return;
                }
            }
            catch (NoClassDefFoundError e2) {
                e2.printStackTrace();
            }
            if (clazz.isArray()) {
                Class<?> componentType;
                Class<?> clazz2 = clazz;
                while ((componentType = clazz2.getComponentType()).getComponentType() != null) {
                    clazz2 = componentType;
                }
                if (!ClassTypes.isObject(componentType) && componentType != String.class) {
                    return;
                }
                for (int i4 = 0; i4 < Array.getLength(o); ++i4) {
                    Object value = Array.get(o, i4);
                    if (value == null) continue;
                    this.collectObjects(value.getClass(), value, path.append(value, i4), true);
                }
            } else if (o instanceof Vector) {
                Enumeration elements = ((Vector)o).elements();
                int index = 0;
                while (elements.hasMoreElements()) {
                    Object nextElement = elements.nextElement();
                    if (nextElement != null) {
                        this.collectObjects(nextElement.getClass(), nextElement, path.append(nextElement, index), true);
                    }
                    ++index;
                }
                return;
            }
            if (o instanceof Hashtable) {
                Hashtable h2 = (Hashtable)o;
                Enumeration keys = h2.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object val = h2.get(key);
                    if (val == null) continue;
                    this.collectObjects(val.getClass(), val, path.append(val, key.toString(), true), true);
                }
                return;
            }
            if (o instanceof String) {
                return;
            }
        }
        if (Emulator.jarClasses.contains(clazz.getName()) || vector2 || this.checkClasses.contains(clazz.getName()) || InputStream.class.isAssignableFrom(clazz)) {
            this.iterateFields(clazz, classInfo.cachedFields, o, path);
        }
    }

    private void iterateFields(Class clazz, Field[] fields, Object o, ReferencePath path) {
        for (Field f2 : fields) {
            String fieldName = f2.getName();
            Object value = ClassTypes.getFieldValue(o, f2);
            ReferencePath newPath = Modifier.isStatic(f2.getModifiers()) ? new ReferencePath(clazz.getName(), true).append(value, fieldName, false) : path.append(value, fieldName, false);
            if (f2.getType().isPrimitive() || value == null) continue;
            this.collectObjects(value.getClass(), value, newPath, false);
        }
    }

    private synchronized void m3gReadTextures(Object obj) {
        block21: {
            if (obj == null) {
                return;
            }
            if (obj instanceof Group) {
                Group g = (Group)obj;
                for (int i2 = 0; i2 < g.getChildCount(); ++i2) {
                    Node child = g.getChild(i2);
                    this.m3gReadTextures(child);
                    Thread.yield();
                }
            } else if (obj instanceof Mesh) {
                Mesh mesh = (Mesh)obj;
                for (int i3 = 0; i3 < mesh.getSubmeshCount(); ++i3) {
                    this.m3gReadTextures(mesh.getAppearance(i3));
                    Thread.yield();
                }
                if (obj instanceof SkinnedMesh) {
                    this.m3gReadTextures(((SkinnedMesh)mesh).getSkeleton());
                    Thread.yield();
                }
            } else {
                if (obj instanceof Appearance) {
                    Appearance ap = (Appearance)obj;
                    int i4 = 0;
                    while (true) {
                        Texture2D tex2d;
                        try {
                            tex2d = ap.getTexture(i4);
                            if (tex2d == null) {
                            }
                        }
                        catch (IndexOutOfBoundsException e2) {}
                        break block21;
                        this.m3gReadTextures(tex2d);
                        Thread.yield();
                        ++i4;
                    }
                }
                if (obj instanceof Sprite3D) {
                    this.m3gReadTextures(((Sprite3D)obj).getImage());
                } else if (obj instanceof Texture2D) {
                    this.m3gReadTextures(((Texture2D)obj).getImage());
                } else if (obj instanceof Image2D) {
                    Image2D img2d = (Image2D)obj;
                    IdentityWrapper iw = new IdentityWrapper(img2d);
                    if (this.instances.contains(iw)) {
                        return;
                    }
                    this.instances.add(iw);
                    IImage img = MemoryViewImage.createFromM3GImage(img2d);
                    if (img != null) {
                        MemoryViewImage mvi = new MemoryViewImage(img, MemoryViewImageType.M3G, img2d);
                        this.images.add(mvi);
                        int i5 = this.releasedImages.indexOf(mvi);
                        if (i5 >= 0) {
                            this.releasedImages.remove(i5);
                        }
                    }
                }
            }
        }
    }

    public static Field[] fields(Class clazz) {
        ArrayList<Field> vector2 = new ArrayList<Field>();
        Memory.addFieldsWithSupers(clazz, vector2);
        for (int i2 = vector2.size() - 1; i2 >= 0; --i2) {
            Field f2 = vector2.get(i2);
            f2.setAccessible(true);
            if (!Modifier.isFinal(f2.getModifiers()) || !f2.getType().isPrimitive()) continue;
            vector2.remove(i2);
        }
        Field[] array = new Field[vector2.size()];
        return vector2.toArray(array);
    }

    private static void addFieldsWithSupers(Class clazz, ArrayList<Field> vector2) {
        try {
            if (clazz.getSuperclass() != null) {
                Memory.addFieldsWithSupers(clazz.getSuperclass(), vector2);
            }
            Collections.addAll(vector2, clazz.getDeclaredFields());
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public static int getBytecodeSize() {
        if (bytecodeSize >= 0) {
            return bytecodeSize;
        }
        int n = 0;
        try {
            if (Emulator.midletJar != null) {
                ZipFile zipFile = new ZipFile(Emulator.midletJar);
                Enumeration<String> elements = Emulator.jarClasses.elements();
                while (elements.hasMoreElements()) {
                    try {
                        String s = elements.nextElement();
                        if (Memory.cls(s).isInterface()) continue;
                        n += (int)zipFile.getEntry(s.replace('.', '/') + ".class").getSize();
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                Enumeration<String> elements2 = Emulator.jarClasses.elements();
                while (elements2.hasMoreElements()) {
                    String s2 = elements2.nextElement();
                    if (Memory.cls(s2).isInterface()) continue;
                    n += (int)Emulator.getFileFromClassPath(s2.replace('.', '/') + ".class").length();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        bytecodeSize = n;
        return n;
    }

    public int objectsSize() {
        int n = 0;
        for (ClassInfo ci : this.classesTable.values()) {
            n += ci.size();
        }
        return n;
    }

    public final int instancesCount(String o) {
        try {
            return this.classesTable.get((Object)o).instancesCount;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public final int totalObjectsSize(String o) {
        try {
            return this.classesTable.get(o).size();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public final ArrayList<ObjInstance> objs(String o) {
        return this.classesTable.get((Object)o).objs;
    }

    public final int size(Class cls, Field[] fields, Object o) {
        int res = 0;
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (Modifier.isFinal(field.getModifiers()) && type.isPrimitive() || Modifier.isStatic(field.getModifiers()) && o != null || !Modifier.isStatic(field.getModifiers()) && o == null) continue;
            if (type == Long.TYPE || type == Double.TYPE) {
                res += 24;
                continue;
            }
            res += 16;
        }
        if (o == null) {
            return res;
        }
        if (cls.isArray()) {
            return res + this.arraySize(cls, fields, o);
        }
        res += 12;
        if (cls == String.class) {
            return res += 2 * ((String)o).length();
        }
        if (cls != Image.class) {
            try {
                if (cls == Image2D.class) {
                    Image2D image2D = (Image2D)o;
                    res += image2D.size();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return res;
        }
        Image image = (Image)o;
        return res += image.size();
    }

    private int arraySize(Class clazz, Field[] fields, Object o) {
        int n = 0;
        n += 16;
        if (o instanceof long[]) {
            n = 16 + 8 * ((long[])o).length;
        } else if (o instanceof int[]) {
            n = 16 + 4 * ((int[])o).length;
        } else if (o instanceof short[]) {
            n = 16 + 2 * ((short[])o).length;
        } else if (o instanceof byte[]) {
            n = 16 + ((byte[])o).length;
        } else if (o instanceof boolean[]) {
            n = 16 + 4 * ((boolean[])o).length;
        } else if (o instanceof double[]) {
            n = 16 + 8 * ((double[])o).length;
        } else if (o instanceof float[]) {
            n = 16 + 4 * ((float[])o).length;
        } else if (o instanceof char[]) {
            n = 16 + 2 * ((char[])o).length;
        } else {
            boolean isArrayOfObjs = ClassTypes.isObject(clazz.getComponentType());
            if (o instanceof Object[]) {
                Object[] oo = (Object[])o;
                for (int i2 = oo.length - 1; i2 >= 0; --i2) {
                    Object value = oo[i2];
                    if (value != null && !isArrayOfObjs) {
                        Class<?> cls = value.getClass();
                        n += this.size(cls, Memory.fields(cls), value);
                        continue;
                    }
                    if (value != null && value.getClass().isArray()) {
                        n += 16;
                        continue;
                    }
                    n += 4;
                }
            } else {
                for (int i3 = Array.getLength(o) - 1; i3 >= 0; --i3) {
                    Object value = Array.get(o, i3);
                    if (value != null && !isArrayOfObjs) {
                        Class<?> cls = value.getClass();
                        n += this.size(cls, Memory.fields(cls), value);
                        continue;
                    }
                    if (value != null && value.getClass().isArray()) {
                        n += 16;
                        continue;
                    }
                    n += 4;
                }
            }
        }
        return n;
    }

    public static Class cls(String s) {
        Class<?> forName;
        try {
            forName = Class.forName(s, false, Emulator.getCustomClassLoader());
        }
        catch (ClassNotFoundException ex2) {
            throw new NoClassDefFoundError(ex2.getMessage());
        }
        return forName;
    }

    static {
        m3gLock = new Object();
        bytecodeSize = -1;
    }
}

