/*
 * Decompiled with CFR 0.152.
 */
package emulator.debug;

import emulator.Emulator;
import emulator.Settings;
import emulator.debug.MemoryViewImageType;
import emulator.graphics2D.IImage;
import java.nio.IntBuffer;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Image2D;
import ru.woesss.j2me.micro3d.TextureImpl;

public final class MemoryViewImage
extends Image {
    public final MemoryViewImageType type;
    public final Object source;

    public MemoryViewImage(IImage image, MemoryViewImageType type, Object source) {
        super(image);
        this.type = type;
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryViewImage that = (MemoryViewImage)o;
        return this.source.equals(that.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public static IImage createFromM3GImage(Image2D img2d) {
        byte[] imgPal;
        byte[] imgPixels;
        boolean imgHasAlpha;
        int imgFormat = img2d.getFormat();
        if (imgFormat < 96 || imgFormat > 100) {
            return null;
        }
        int imgW = img2d.getWidth();
        int imgH = img2d.getHeight();
        int imgBPP = img2d.getBitsPerColor();
        boolean bl = imgHasAlpha = imgFormat == 96 || imgFormat == 98 || imgFormat == 100;
        if (img2d.isPalettized()) {
            imgPixels = new byte[imgW * imgH];
            img2d.getPixels(imgPixels);
            imgPal = new byte[imgBPP * 256];
            img2d.getPalette(imgPal);
        } else {
            imgPixels = new byte[imgW * imgH * imgBPP];
            img2d.getPixels(imgPixels);
            imgPal = null;
        }
        IImage image = Emulator.getEmulator().newImage(img2d.getWidth(), img2d.getHeight(), imgHasAlpha);
        int[] data = image.getData();
        for (int y = 0; y < imgH; ++y) {
            for (int x = 0; x < imgW; ++x) {
                int pxIndex;
                byte[] tmpPixels;
                int col = 0;
                if (imgPal != null) {
                    tmpPixels = imgPal;
                    pxIndex = (imgPixels[x + y * imgW] & 0xFF) * imgBPP;
                } else {
                    tmpPixels = imgPixels;
                    pxIndex = (x + y * imgW) * imgBPP;
                }
                col = imgHasAlpha ? (col |= (tmpPixels[pxIndex + imgBPP - 1] & 0xFF) << 24) : (col |= 0xFF000000);
                col = imgFormat == 97 || imgFormat == 98 ? (col |= 65793 * (tmpPixels[pxIndex] & 0xFF)) : (imgFormat == 99 || imgFormat == 100 ? (col |= (tmpPixels[pxIndex] & 0xFF) << 16 | (tmpPixels[pxIndex + 1] & 0xFF) << 8 | tmpPixels[pxIndex + 2] & 0xFF) : (col |= 0xFFFFFF));
                data[x + y * imgW] = col;
            }
        }
        image.setData(data);
        return image;
    }

    public static IImage createFromMicro3DTexture(Object tex) {
        Class<?> texCls = tex.getClass();
        try {
            if (Settings.micro3d == 1) {
                TextureImpl texImpl = (TextureImpl)texCls.getField("impl").get(tex);
                if (texImpl == null) {
                    return null;
                }
                IntBuffer texPixels = texImpl.image.getRaster().asIntBuffer();
                int w = texImpl.getWidth();
                int h2 = texImpl.getHeight();
                IImage img = Emulator.getEmulator().newImage(w, h2, true);
                int[] data = img.getData();
                for (int i2 = 0; i2 < w * h2; ++i2) {
                    int col = texPixels.get(i2);
                    data[i2] = 0xFF000000 | (col & 0xFF0000) >> 16 | col & 0xFF00 | (col & 0xFF) << 16;
                }
                return img;
            }
            IImage img = (IImage)texCls.getField("debugImage").get(tex);
            return img;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

