/*
 * Decompiled with CFR 0.152.
 */
package emulator.debug;

import java.util.ArrayList;
import java.util.Objects;

public class ReferencePath {
    public final String root;
    public final boolean isRootStatic;
    private final ArrayList<ReferencePathEntry> path = new ArrayList();

    public ReferencePath(String root, boolean isRootStatic) {
        this.root = root;
        this.isRootStatic = isRootStatic;
    }

    public ReferencePath append(Object object, String fieldName, boolean isIndex) {
        ReferencePath n = new ReferencePath(this.root, this.isRootStatic);
        n.path.addAll(this.path);
        n.path.add(new ReferencePathEntry(object, fieldName, isIndex));
        return n;
    }

    public ReferencePath append(Object object, int index) {
        ReferencePath n = new ReferencePath(this.root, this.isRootStatic);
        n.path.addAll(this.path);
        n.path.add(new ReferencePathEntry(object, String.valueOf(index), true));
        return n;
    }

    public ReferencePathEntry[] getPath() {
        return this.path.toArray(new ReferencePathEntry[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferencePath)) {
            return false;
        }
        ReferencePath that = (ReferencePath)o;
        return this.isRootStatic == that.isRootStatic && this.root.equals(that.root) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.isRootStatic);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showPkgName) {
        StringBuilder sb = new StringBuilder();
        if (!showPkgName && this.isRootStatic) {
            String[] split = this.root.split("\\.");
            sb.append(split[split.length - 1]);
        } else {
            sb.append(this.root);
        }
        for (ReferencePathEntry entry : this.path) {
            if (!entry.isIndex) {
                sb.append('.');
            }
            sb.append(entry);
        }
        return sb.toString();
    }

    public static final class ReferencePathEntry {
        public final Object object;
        public final String fieldName;
        public final boolean isIndex;

        public ReferencePathEntry(Object object, String fieldName, boolean isIndex) {
            this.object = object;
            this.fieldName = fieldName;
            this.isIndex = isIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReferencePathEntry)) {
                return false;
            }
            ReferencePathEntry that = (ReferencePathEntry)o;
            return this.isIndex == that.isIndex && Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.isIndex);
        }

        public String toString() {
            if (this.isIndex) {
                return '[' + this.fieldName + ']';
            }
            return this.fieldName;
        }
    }
}

