/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D;

import emulator.graphics2D.a;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public final class CopyUtils {
    private static final PaletteData palleteData = new PaletteData(65280, 0xFF0000, -16777216);
    private static int[] buffer;
    private static BufferedImage lastImg;
    private static ImageData imageData;

    private CopyUtils() {
    }

    public static BufferedImage toAwtForCapture(ImageData imageData) {
        PaletteData palette = imageData.palette;
        if (palette.isDirect) {
            DirectColorModel directColorModel = new DirectColorModel(imageData.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(directColorModel, directColorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] array = new int[3];
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                for (int j = 0; j < imageData.width; ++j) {
                    RGB rgb = palette.getRGB(imageData.getPixel(j, i2));
                    array[0] = rgb.red;
                    array[1] = rgb.green;
                    array[2] = rgb.blue;
                    raster.setPixels(j, i2, 1, 1, array);
                }
            }
            return bufferedImage;
        }
        RGB[] rgBs = palette.getRGBs();
        byte[] array2 = new byte[rgBs.length];
        byte[] array3 = new byte[rgBs.length];
        byte[] array4 = new byte[rgBs.length];
        for (int k2 = 0; k2 < rgBs.length; ++k2) {
            RGB rgb2 = rgBs[k2];
            array2[k2] = (byte)rgb2.red;
            array3[k2] = (byte)rgb2.green;
            array4[k2] = (byte)rgb2.blue;
        }
        IndexColorModel indexColorModel = imageData.transparentPixel != -1 ? new IndexColorModel(imageData.depth, rgBs.length, array2, array3, array4, imageData.transparentPixel) : new IndexColorModel(imageData.depth, rgBs.length, array2, array3, array4);
        BufferedImage bufferedImage2 = new BufferedImage(indexColorModel, indexColorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
        WritableRaster raster2 = bufferedImage2.getRaster();
        int[] array5 = new int[]{0};
        for (int l = 0; l < imageData.height; ++l) {
            for (int n = 0; n < imageData.width; ++n) {
                array5[0] = imageData.getPixel(n, l);
                raster2.setPixel(n, l, array5);
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage toAwt(ImageData imageData) {
        BufferedImage bufferedImage = new BufferedImage(imageData.width, imageData.height, 2);
        int[] data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = imageData.width * imageData.height;
        imageData.getPixels(0, 0, n, data, 0);
        if (imageData.alphaData != null) {
            for (int i2 = n - 1; i2 >= 0; --i2) {
                RGB rgb = imageData.palette.getRGB(data[i2]);
                data[i2] = (imageData.alphaData[i2] << 24) + ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
            }
        } else if (imageData.transparentPixel != -1 && !imageData.palette.isDirect) {
            RGB[] colors = imageData.palette.colors;
            for (int j = n - 1; j >= 0; --j) {
                int n3;
                int n2;
                int[] array;
                if (data[j] == imageData.transparentPixel) {
                    array = data;
                    n2 = j;
                    n3 = 0;
                } else {
                    RGB rgb2 = colors[data[j] % colors.length];
                    array = data;
                    n2 = j;
                    n3 = -16777216 + ((rgb2.red & 0xFF) << 16) + ((rgb2.green & 0xFF) << 8) + (rgb2.blue & 0xFF);
                }
                array[n2] = n3;
            }
        } else if (!imageData.palette.isDirect) {
            RGB[] colors2 = imageData.palette.colors;
            for (int k2 = n - 1; k2 >= 0; --k2) {
                RGB rgb3 = imageData.palette.getRGB(data[k2] % colors2.length);
                data[k2] = -16777216 + ((rgb3.red & 0xFF) << 16) + ((rgb3.green & 0xFF) << 8) + (rgb3.blue & 0xFF);
            }
        } else {
            for (int l = n - 1; l >= 0; --l) {
                RGB rgb4 = imageData.palette.getRGB(data[l]);
                data[l] = -16777216 + ((rgb4.red & 0xFF) << 16) + ((rgb4.green & 0xFF) << 8) + (rgb4.blue & 0xFF);
            }
        }
        data = null;
        System.gc();
        return bufferedImage;
    }

    public static ImageData toSwt(BufferedImage bufferedImage) {
        if (bufferedImage.getType() == 1 || bufferedImage.getType() == 2 || bufferedImage.getType() == 4) {
            return CopyUtils.toSwtAsIs(bufferedImage);
        }
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            return CopyUtils.toSwtDCM(bufferedImage);
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            return CopyUtils.toSwtICM(bufferedImage);
        }
        return null;
    }

    private static ImageData toSwtAsIs(BufferedImage bufferedImage) {
        if (buffer == null || bufferedImage != lastImg) {
            imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 32, palleteData);
            buffer = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            lastImg = bufferedImage;
        }
        ImageData data = imageData;
        int[] source = buffer;
        byte[] target = data.data;
        int n = target.length - 1;
        switch (bufferedImage.getType()) {
            case 4: {
                for (int i2 = source.length - 1; i2 >= 0; --i2) {
                    target[n--] = -1;
                    target[n--] = (byte)(source[i2] & 0xFF);
                    target[n--] = (byte)(source[i2] >> 8 & 0xFF);
                    target[n--] = (byte)(source[i2] >> 16 & 0xFF);
                }
                break;
            }
            case 1: {
                for (int i3 = source.length - 1; i3 >= 0; --i3) {
                    target[n--] = -1;
                    target[n--] = (byte)(source[i3] >> 16 & 0xFF);
                    target[n--] = (byte)(source[i3] >> 8 & 0xFF);
                    target[n--] = (byte)(source[i3] & 0xFF);
                }
                break;
            }
            case 2: {
                data.alphaData = new byte[source.length];
                for (int i4 = source.length - 1; i4 >= 0; --i4) {
                    byte alpha = (byte)(source[i4] >> 24 & 0xFF);
                    target[n--] = alpha;
                    data.alphaData[i4] = alpha;
                    target[n--] = (byte)(source[i4] >> 16 & 0xFF);
                    target[n--] = (byte)(source[i4] >> 8 & 0xFF);
                    target[n--] = (byte)(source[i4] & 0xFF);
                }
                break;
            }
        }
        return data;
    }

    private static ImageData toSwtDCM(BufferedImage bufferedImage) {
        DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
        PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
        WritableRaster raster = bufferedImage.getRaster();
        int imgW = imageData.width;
        int[] awtPixels = new int[4 * imgW];
        int[] swtPixels = new int[imgW];
        for (int i2 = 0; i2 < imageData.height; ++i2) {
            int j;
            raster.getPixels(0, i2, imgW, 1, awtPixels);
            for (j = 0; j < imgW; ++j) {
                RGB rgb = new RGB(awtPixels[j * 4 + 0], awtPixels[j * 4 + 1], awtPixels[j * 4 + 2]);
                swtPixels[j] = paletteData.getPixel(rgb);
            }
            imageData.setPixels(0, i2, imgW, swtPixels, 0);
            if (!directColorModel.hasAlpha()) continue;
            for (j = 0; j < imgW; ++j) {
                imageData.setAlpha(j, i2, awtPixels[j * 4 + 3]);
            }
        }
        return imageData;
    }

    private static ImageData toSwtICM(BufferedImage bufferedImage) {
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int mapSize = indexColorModel.getMapSize();
        byte[] array2 = new byte[mapSize];
        byte[] array3 = new byte[mapSize];
        byte[] array4 = new byte[mapSize];
        indexColorModel.getReds(array2);
        indexColorModel.getGreens(array3);
        indexColorModel.getBlues(array4);
        RGB[] array5 = new RGB[mapSize];
        for (int k2 = 0; k2 < array5.length; ++k2) {
            array5[k2] = new RGB(array2[k2] & 0xFF, array3[k2] & 0xFF, array4[k2] & 0xFF);
        }
        ImageData imageData2 = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), new PaletteData(array5));
        new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), new PaletteData(array5)).transparentPixel = indexColorModel.getTransparentPixel();
        WritableRaster raster2 = bufferedImage.getRaster();
        int[] array6 = new int[]{0};
        for (int l = 0; l < imageData2.height; ++l) {
            for (int n = 0; n < imageData2.width; ++n) {
                raster2.getPixel(n, l, array6);
                imageData2.setPixel(n, l, array6[0]);
            }
        }
        return imageData2;
    }

    public static void setClipboard(BufferedImage bufferedImage) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new a(bufferedImage), null);
    }
}

