/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D;

import emulator.Emulator;
import emulator.Settings;
import emulator.graphics2D.IImage;

public final class GraphicsUtils {
    private static IImage bufferImage;
    private static int[] bufferData;

    private static void createBuffer(int max, int max2) {
        if (bufferImage == null || max > bufferImage.getWidth() || max2 > bufferImage.getHeight()) {
            max = Math.max(max, Emulator.getEmulator().getScreen().getWidth());
            max2 = Math.max(max2, Emulator.getEmulator().getScreen().getHeight());
            bufferImage = Emulator.getEmulator().newImage(max, max2, true);
            if (Settings.g2d == 0) {
                bufferData = new int[max * max2];
            }
        }
    }

    public static void setImageData(IImage image, int[] array, boolean b2, int n, int n2, int n3, int n4) {
        int[] data = null;
        if (Settings.g2d == 0) {
            data = new int[image.getWidth() * image.getHeight()];
        } else if (Settings.g2d == 1) {
            data = image.getData();
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            System.arraycopy(array, n, data, n5, n3);
            if (!b2) {
                for (int j = 0; j < n3; ++j) {
                    int n6;
                    int n7 = n6 = n5 + j;
                    data[n7] = data[n7] | 0xFF000000;
                }
            }
            n5 += image.getWidth();
            n += n2;
        }
        if (!image.directAccess()) {
            image.setData(data);
        }
    }

    public static IImage setImageData(int[] rgbData, boolean processAlpha, int offset, int scanlength, int width, int height) {
        GraphicsUtils.createBuffer(width, height);
        int[] data = null;
        if (Settings.g2d == 0) {
            data = bufferData;
        } else if (Settings.g2d == 1) {
            data = bufferImage.getData();
        }
        int n5 = 0;
        for (int i2 = 0; i2 < height; ++i2) {
            System.arraycopy(rgbData, offset, data, n5, width);
            if (!processAlpha) {
                for (int j = 0; j < width; ++j) {
                    int n6;
                    int n = n6 = n5 + j;
                    data[n] = data[n] | 0xFF000000;
                }
            }
            n5 += bufferImage.getWidth();
            offset += scanlength;
        }
        if (!bufferImage.directAccess()) {
            bufferImage.setData(data);
        }
        return bufferImage;
    }

    public static IImage setImageData(short[] array, boolean b2, int n, int n2, int n3, int n4) {
        GraphicsUtils.createBuffer(n3, n4);
        int[] data = null;
        if (Settings.g2d == 0) {
            data = bufferData;
        } else if (Settings.g2d == 1) {
            data = bufferImage.getData();
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = n;
            int n7 = n5;
            for (int j = 0; j < n3; ++j) {
                int n8 = array[n6] & 0xF000;
                int n10 = b2 ? (n8 << 16) + (n8 << 12) : -16777216;
                int n9 = n10 | (array[n6] & 0xF00) << 12 | (array[n6] & 0xF0) << 8 | (array[n6] & 0xF) << 4;
                ++n6;
                data[n7++] = n9;
            }
            n += n2;
            n5 += bufferImage.getWidth();
        }
        if (!bufferImage.directAccess()) {
            bufferImage.setData(data);
        }
        return bufferImage;
    }

    public static void getImageData(IImage image, int[] array, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] data = image.getData();
        int n7 = n4 * image.getWidth() + n3;
        for (int i2 = 0; i2 < n6; ++i2) {
            System.arraycopy(data, n7, array, n, n5);
            n7 += image.getWidth();
            n += n2;
        }
    }

    public static void getImageData(IImage image, short[] array, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = n;
            for (int j = 0; j < n5; ++j) {
                int rgb = image.getRGB(n3 + j, n4 + i2);
                array[n7++] = (short)((rgb >> 24 & 0xF0) << 8 | (rgb >> 16 & 0xF0) << 4 | (rgb >> 8 & 0xF0) << 0 | (rgb & 0xF0) >> 4);
            }
            n += n2;
        }
    }
}

