/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.awt;

import emulator.graphics2D.IFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public final class FontAWT
implements IFont {
    private Font font;
    private FontMetrics metrics;
    private static Font nokiaFont;
    private static Font s60Font;

    public FontAWT(String s, int size, int style, boolean height) {
        if ("Series 60".equals(s)) {
            if (s60Font == null) {
                try {
                    s60Font = Font.createFont(0, this.getClass().getResourceAsStream("/res/s60snr.ttf"));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.font = s60Font.deriveFont(style, size);
        } else if ("Nokia".equals(s)) {
            if (nokiaFont == null) {
                try {
                    nokiaFont = Font.createFont(0, this.getClass().getResourceAsStream("/res/Nokia.ttf"));
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
            this.font = nokiaFont.deriveFont(style, size);
        } else {
            this.font = new Font(s, style, size);
        }
        this.init(size, height);
    }

    public FontAWT(InputStream fontData, int size) throws IOException {
        try {
            this.font = Font.createFont(0, fontData);
        }
        catch (FontFormatException e2) {
            throw new javax.microedition.lcdui.FontFormatException(e2.toString());
        }
        this.init(size, false);
    }

    private void init(int size, boolean height) {
        this.initMetrics();
        if (height && this.metrics.getHeight() != size) {
            float f2 = (float)this.metrics.charWidth('W') / (float)this.metrics.getHeight() * (float)size;
            this.font = this.font.deriveFont(f2);
            this.initMetrics();
        }
    }

    private void initMetrics() {
        this.metrics = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(this.font);
    }

    @Override
    public final int stringWidth(String s) {
        return this.metrics.stringWidth(s);
    }

    public final Font getAWTFont() {
        return this.font;
    }

    @Override
    public final int charWidth(char c2) {
        return this.metrics.charWidth(c2);
    }

    @Override
    public final int getHeight() {
        return this.metrics.getHeight();
    }

    @Override
    public final int getAscent() {
        return this.metrics.getAscent();
    }

    @Override
    public final int getDescent() {
        return this.metrics.getDescent();
    }

    @Override
    public final int getMaxAscent() {
        return this.metrics.getMaxAscent();
    }

    @Override
    public final int getMaxDescent() {
        return this.metrics.getMaxDescent();
    }

    @Override
    public int getLeading() {
        return this.metrics.getLeading();
    }

    @Override
    public int getPixelSize() {
        return this.font.getSize();
    }

    @Override
    public String getFamily() {
        return this.font.getFamily();
    }

    @Override
    public String getName() {
        return this.font.getName();
    }

    @Override
    public String getFontName() {
        return this.font.getFontName();
    }
}

