/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.awt;

import emulator.Settings;
import emulator.graphics2D.IFont;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.ITransform;
import emulator.graphics2D.awt.FontAWT;
import emulator.graphics2D.awt.ImageAWT;
import emulator.graphics2D.awt.TransformAWT;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public final class Graphics2DAWT
implements IGraphics2D {
    Graphics2D g;
    int width;
    int height;
    private int strokeStyle;
    private FontAWT font;

    public Graphics2DAWT(BufferedImage bufferedImage) {
        this.g = bufferedImage.createGraphics();
        this.g.setColor(new Color(0, 0, 0));
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        if (Settings.textAntiAliasing) {
            this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (Settings.awtAntiAliasing) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public final Graphics2D g() {
        return this.g;
    }

    @Override
    public final void setAlpha(int n) {
        this.g.setComposite(AlphaComposite.getInstance(3, (float)n / 255.0f));
    }

    @Override
    public final void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    @Override
    public final void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    @Override
    public final void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
    }

    @Override
    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    @Override
    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillPolygon(int[] array) {
        int n = array.length >> 1;
        int[] array2 = new int[n];
        int[] array3 = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            array2[i2] = array[i2 << 1];
            array3[i2] = array[(i2 << 1) + 1];
        }
        this.g.fillPolygon(array2, array3, n);
    }

    @Override
    public final void drawPolygon(int[] array) {
        int n = array.length >> 1;
        int[] array2 = new int[n];
        int[] array3 = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            array2[i2] = array[i2 << 1];
            array3[i2] = array[(i2 << 1) + 1];
        }
        this.g.drawPolygon(array2, array3, n);
    }

    @Override
    public final void drawPolyline(int[] array) {
        int n = array.length >> 1;
        int[] array2 = new int[n];
        int[] array3 = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            array2[i2] = array[i2 << 1];
            array3[i2] = array[(i2 << 1) + 1];
        }
        this.g.drawPolyline(array2, array3, n);
    }

    @Override
    public final void drawString(String s, int x, int y) {
        this.g.drawString(s, x, y);
    }

    @Override
    public final void drawImage(IImage image, int n, int n2) {
        this.g.drawImage((Image)((ImageAWT)image).getBufferedImage(), n, n2, null);
    }

    @Override
    public final void drawImage(IImage image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.g.drawImage(((ImageAWT)image).getBufferedImage(), n5, n6, n5 + n7, n6 + n8, n, n2, n + n3, n2 + n4, null);
    }

    @Override
    public final void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    @Override
    public final void setColor(int n, boolean b2) {
        this.g.setColor(new Color(n, b2));
    }

    @Override
    public final void setColor(int n, int n2, int n3) {
        this.g.setColor(new Color(n, n2, n3));
    }

    @Override
    public final void setFont(IFont font) {
        try {
            this.font = (FontAWT)font;
            this.g.setFont(((FontAWT)font).getAWTFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void setStrokeStyle(int anInt12) {
        block4: {
            BasicStroke stroke;
            Graphics2D graphics2D;
            block3: {
                block2: {
                    if (anInt12 != 0) break block2;
                    graphics2D = this.g;
                    stroke = new BasicStroke(1.0f);
                    break block3;
                }
                if (anInt12 != 1) break block4;
                BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
                graphics2D = this.g;
                stroke = basicStroke;
            }
            graphics2D.setStroke(stroke);
        }
        this.strokeStyle = anInt12;
    }

    @Override
    public final int getStrokeStyle() {
        return this.strokeStyle;
    }

    @Override
    public final int getClipHeight() {
        Rectangle r = this.g.getClipBounds();
        if (r == null) {
            return this.height;
        }
        return r.height;
    }

    @Override
    public final int getClipWidth() {
        Rectangle r = this.g.getClipBounds();
        if (r == null) {
            return this.width;
        }
        return r.width;
    }

    @Override
    public final int getClipX() {
        Rectangle r = this.g.getClipBounds();
        if (r == null) {
            return 0;
        }
        return r.x;
    }

    @Override
    public final int getClipY() {
        Rectangle r = this.g.getClipBounds();
        if (r == null) {
            return 0;
        }
        return r.y;
    }

    @Override
    public final int getColor() {
        return this.g.getColor().getRGB();
    }

    @Override
    public final int getColorRed() {
        return this.g.getColor().getRed();
    }

    @Override
    public final int getColorGreen() {
        return this.g.getColor().getGreen();
    }

    @Override
    public final int getColorBlue() {
        return this.g.getColor().getBlue();
    }

    @Override
    public final float[] RGBtoHSB(int n, int n2, int n3) {
        return Color.RGBtoHSB(n, n2, n3, null);
    }

    @Override
    public final ITransform getTransform() {
        return new TransformAWT(this.g.getTransform());
    }

    @Override
    public final void setTransform(ITransform transform) {
        this.g.setTransform(((TransformAWT)transform).method8());
    }

    @Override
    public final void transform(ITransform transform) {
        this.g.transform(((TransformAWT)transform).method8());
    }

    @Override
    public final void translate(int x, int y) {
        this.g.translate(x, y);
    }

    @Override
    public IFont getFont() {
        return this.font;
    }

    @Override
    public void reset() {
        this.g.setTransform(new AffineTransform());
        this.g.setClip(0, 0, this.width, this.height);
    }
}

