/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.awt;

import emulator.graphics2D.CopyUtils;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.Graphics2DAWT;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public final class ImageAWT
implements IImage {
    private BufferedImage img;
    private Graphics2DAWT graphics;
    private Graphics2D g2d;
    private int[] data;
    private boolean directAccess;

    public ImageAWT(byte[] array) throws IOException {
        block3: {
            try {
                this.img = CopyUtils.toAwt(new ImageData((InputStream)new ByteArrayInputStream(array)));
            }
            catch (SWTException e2) {
                if (!"Invalid image".equals(e2.getMessage()) && !"Unsupported or unrecognized format".equals(e2.getMessage())) {
                    throw e2;
                }
                this.img = ImageIO.read(new ByteArrayInputStream(array));
                if (this.img != null) break block3;
                throw new IOException();
            }
        }
    }

    public ImageAWT(BufferedImage bi) {
        this.img = bi;
    }

    public ImageAWT(int n, int n2, boolean b2, int n3) {
        this.img = new BufferedImage(n, n2, b2 ? 2 : 1);
        Graphics2D g = this.g2d = this.img.createGraphics();
        g.setColor(new Color(n3, b2));
        g.fillRect(0, 0, n, n2);
    }

    public final BufferedImage getBufferedImage() {
        return this.img;
    }

    @Override
    public final void copyToScreen(Object g, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GC gc = (GC)g;
        Image image = new Image(null, CopyUtils.toSwt(this.img));
        gc.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8);
        image.dispose();
    }

    @Override
    public boolean isTransparent() {
        return this.img.getType() == 2;
    }

    @Override
    public void fill(int color) {
        Arrays.fill(this.getInternalData(), color);
    }

    @Override
    public final void copyToScreen(Object g) {
        GC gc = (GC)g;
        Image image = new Image(null, CopyUtils.toSwt(this.img));
        gc.drawImage(image, 0, 0);
        image.dispose();
    }

    @Override
    public final IGraphics2D createGraphics() {
        this.graphics = new Graphics2DAWT(this.img);
        return this.graphics;
    }

    @Override
    public final IGraphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public final int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.img.getHeight();
    }

    @Override
    public final int[] getData() {
        try {
            int[] data = this.getInternalData();
            this.directAccess = true;
            if (!this.img.getColorModel().hasAlpha()) {
                int i2 = data.length - 1;
                while (i2 >= 0) {
                    int n = i2--;
                    data[n] = data[n] | 0xFF000000;
                }
                this.directAccess = false;
            }
            return data;
        }
        catch (ClassCastException e2) {
            e2.printStackTrace();
            byte[] data = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getData();
            int[] intdata = new int[data.length];
            for (int i3 = 0; i3 < data.length; ++i3) {
                intdata[i3] = ((data[i3++] & 0xFF) << 24) + ((data[i3++] & 0xFF) << 16) + ((data[i3++] & 0xFF) << 8) + (data[i3++] & 0xFF);
            }
            this.directAccess = false;
            return intdata;
        }
    }

    @Override
    public final boolean directAccess() {
        return this.directAccess;
    }

    @Override
    public final void setData(int[] array) {
        int[] data = this.getInternalData();
        if (array == data) {
            return;
        }
        if (array.length != data.length) {
            return;
        }
        System.arraycopy(array, 0, data, 0, array.length);
    }

    @Override
    public final void setAlpha(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            Graphics2D g = this.g2d;
            if (g == null) {
                g = this.img.createGraphics();
            }
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            g.fillRect(n, n2, n3, n4);
            return;
        }
        int[] data = this.data != null ? this.data : ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        int[] array = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            array[i2] = n5 << 24;
        }
        for (int j = n2; j < n2 + n4; ++j) {
            System.arraycopy(array, 0, data, n + j * this.getWidth(), array.length);
        }
    }

    @Override
    public final int getRGB(int x, int y) {
        return this.img.getRGB(x, y);
    }

    @Override
    public void setRGB(int x, int y, int color) {
        this.img.setRGB(x, y, color | 0xFF000000);
    }

    @Override
    public void setRGB(int x, int y, int w, int h2, int[] data, int off, int scan) {
        this.img.setRGB(x, y, w, h2, data, off, scan);
    }

    @Override
    public final void getRGB(int[] data, int off, int scan, int x, int y, int w, int h2) {
        this.img.getRGB(x, y, w, h2, data, off, scan);
    }

    @Override
    public final void saveToFile(String s) {
        try {
            ImageIO.write((RenderedImage)this.img, "png", new File(s));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void write(OutputStream out, String format) throws IOException {
        ImageIO.write((RenderedImage)this.img, format, out);
    }

    @Override
    public final void copyToClipBoard() {
        CopyUtils.setClipboard(this.img);
    }

    @Override
    public final void cloneImage(IImage target) {
        System.arraycopy(this.getInternalData(), 0, ((ImageAWT)target).getInternalData(), 0, this.data.length);
    }

    @Override
    public void cloneImage(IImage target, int x, int y, int w, int h2) {
        int[] from = this.getInternalData();
        int[] to = ((ImageAWT)target).getInternalData();
        int tw = this.getWidth();
        for (int cy = y; cy < y + h2; ++cy) {
            System.arraycopy(from, cy * tw + x, to, cy * tw + x, w);
        }
    }

    @Override
    public void copyImage(IGraphics2D destGraphics, int sx, int sy, int w, int h2, int tx, int ty) {
        ((Graphics2DAWT)destGraphics).g().drawImage(this.img, tx, ty, tx + w, ty + h2, sx, sy, sx + w, sy + h2, null);
    }

    private int[] getInternalData() {
        if (this.data == null) {
            this.data = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        }
        return this.data;
    }

    @Override
    public int size() {
        DataBuffer d = this.img.getRaster().getDataBuffer();
        int size = d.getSize();
        if (d instanceof DataBufferInt) {
            size *= 4;
        }
        return size;
    }

    @Override
    public Object getNative() {
        return this.getBufferedImage();
    }
}

