/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.swt;

import emulator.graphics2D.IFont;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public final class FontSWT
implements IFont {
    private Font font;
    private GC gc;

    public FontSWT(String s, int n, int n2) {
        this(s, n, n2, false);
    }

    public FontSWT(String s, int size, int n2, boolean height) {
        size = Math.max(1, (int)((float)size * 0.75f) - 1);
        this.font = new Font(null, s, size, n2);
        this.metrics();
        if (height && this.getHeight() != size) {
            float f2 = (float)this.charWidth('W') / (float)this.getHeight() * (float)size;
            this.font.dispose();
            this.gc.dispose();
            this.font = new Font(null, s, (int)f2, n2);
            this.metrics();
        }
    }

    private void metrics() {
        if (this.gc == null) {
            this.gc = new GC((Drawable)new Image(null, 1, 1));
        }
        this.gc.setFont(this.font);
    }

    public final void finalize() {
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
    }

    public final Font getSWTFont() {
        return this.font;
    }

    @Override
    public final int charWidth(char c2) {
        return this.gc.getCharWidth(c2);
    }

    @Override
    public final int stringWidth(String s) {
        return this.gc.stringExtent((String)s).x;
    }

    @Override
    public final int getHeight() {
        return this.gc.getFontMetrics().getHeight();
    }

    @Override
    public final int getAscent() {
        return this.gc.getFontMetrics().getAscent();
    }

    @Override
    public final int getDescent() {
        return this.gc.getFontMetrics().getDescent();
    }

    @Override
    public final int getLeading() {
        return this.gc.getFontMetrics().getLeading();
    }

    @Override
    public final int getMaxAscent() {
        return this.gc.getFontMetrics().getAscent();
    }

    @Override
    public final int getMaxDescent() {
        return this.gc.getFontMetrics().getDescent();
    }

    @Override
    public int getPixelSize() {
        return this.gc.getFontMetrics().getHeight();
    }

    @Override
    public String getFamily() {
        return "";
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getFontName() {
        return "";
    }
}

