/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.swt;

import emulator.graphics2D.IFont;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.ITransform;
import emulator.graphics2D.swt.FontSWT;
import emulator.graphics2D.swt.ImageSWT;
import emulator.graphics2D.swt.TransformSWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public final class Graphics2DSWT
implements IGraphics2D {
    GC gc;
    Color color;
    int width;
    int height;

    public Graphics2DSWT(Image image) {
        this.gc = new GC((Drawable)image);
        this.gc.setAntialias(0);
        Transform transform = new Transform(null);
        this.gc.getTransform(transform);
        transform.dispose();
        this.color = new Color(null, 0, 0, 0);
        this.width = image.getImageData().width;
        this.height = image.getImageData().height;
    }

    public final GC gc() {
        return this.gc;
    }

    public final void finalize() {
        if (!this.gc.isDisposed()) {
            this.gc.dispose();
        }
        if (!this.color.isDisposed()) {
            this.color.dispose();
        }
    }

    @Override
    public final void setAlpha(int alpha) {
        this.gc.setAlpha(alpha);
    }

    @Override
    public final void clipRect(int n, int n2, int n3, int n4) {
        Rectangle intersection = this.gc.getClipping().intersection(new Rectangle(n, n2, n3, n4));
        this.gc.setClipping(intersection.x - 1, intersection.y - 1, intersection.width + 1, intersection.height + 1);
    }

    @Override
    public final void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.gc.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void drawLine(int n, int n2, int n3, int n4) {
        this.gc.drawLine(n, n2, n3, n4);
    }

    @Override
    public final void drawRect(int n, int n2, int n3, int n4) {
        this.gc.drawRectangle(n, n2, n3, n4);
    }

    @Override
    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.gc.drawRoundRectangle(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.gc.fillArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillRect(int n, int n2, int n3, int n4) {
        this.gc.fillRectangle(n, n2, n3, n4);
    }

    @Override
    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.gc.fillRoundRectangle(n, n2, n3, n4, n5, n6);
    }

    @Override
    public final void fillPolygon(int[] array) {
        this.gc.fillPolygon(array);
    }

    @Override
    public final void drawPolygon(int[] array) {
        this.gc.drawPolygon(array);
    }

    @Override
    public final void drawPolyline(int[] array) {
        this.gc.drawPolyline(array);
    }

    @Override
    public final void setFont(IFont font) {
        this.gc.setFont(((FontSWT)font).getSWTFont());
    }

    @Override
    public final void drawString(String s, int n, int n2) {
        FontMetrics f2 = this.gc.getFontMetrics();
        this.gc.drawString(s, n, n2 - f2.getAscent() - 1, true);
    }

    @Override
    public final void drawImage(IImage image, int n, int n2) {
        ((ImageSWT)image).method12(this.gc, n, n2);
    }

    @Override
    public final void drawImage(IImage image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ((ImageSWT)image).copyToScreen(this.gc, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public final void setClip(int n, int n2, int n3, int n4) {
        this.gc.setClipping(n, n2, n3, n4);
    }

    @Override
    public final void setColor(int n, boolean b2) {
        int a2 = n >> 24 & 0xFF;
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.color.dispose();
        this.color = new Color(null, n2, n3, n4);
        this.gc.setAlpha(b2 ? a2 : (a2 > 0 ? a2 : 255));
        this.gc.setBackground(this.color);
        this.gc.setForeground(this.color);
    }

    @Override
    public final void setColor(int n, int n2, int n3) {
        this.color.dispose();
        this.color = new Color(null, n, n2, n3);
        this.gc.setBackground(this.color);
        this.gc.setForeground(this.color);
    }

    @Override
    public final int getClipHeight() {
        if (this.gc.isClipped()) {
            return this.gc.getClipping().height;
        }
        return this.height;
    }

    @Override
    public final int getClipWidth() {
        if (this.gc.isClipped()) {
            return this.gc.getClipping().width;
        }
        return this.width;
    }

    @Override
    public final int getClipX() {
        if (this.gc.isClipped()) {
            return this.gc.getClipping().x;
        }
        return 0;
    }

    @Override
    public final int getClipY() {
        if (this.gc.isClipped()) {
            return this.gc.getClipping().y;
        }
        return 0;
    }

    @Override
    public final int getColor() {
        return ((this.gc.getAlpha() & 0xFF) << 24) + ((this.color.getRed() & 0xFF) << 16) + ((this.color.getGreen() & 0xFF) << 8) + (this.color.getBlue() & 0xFF);
    }

    @Override
    public final int getColorRed() {
        return this.color.getRed();
    }

    @Override
    public final int getColorGreen() {
        return this.color.getGreen();
    }

    @Override
    public final int getColorBlue() {
        return this.color.getBlue();
    }

    @Override
    public final float[] RGBtoHSB(int n, int n2, int n3) {
        float n7;
        float n14;
        float n6;
        float[] array;
        block11: {
            float n8;
            block10: {
                float f2;
                float n13;
                float n12;
                int n5;
                int n4;
                block9: {
                    array = new float[3];
                    int n9 = n4 = n <= n2 ? n2 : n;
                    if (n3 > n4) {
                        n4 = n3;
                    }
                    int n10 = n5 = n >= n2 ? n2 : n;
                    if (n3 < n5) {
                        n5 = n3;
                    }
                    n6 = (float)n4 / 255.0f;
                    n14 = 0.0f;
                    n7 = n4 != 0 ? (float)((n4 - n5) / n4) : 0.0f;
                    if (n7 != 0.0f) break block9;
                    n8 = 0.0f;
                    break block10;
                }
                float n9 = (n4 - n) / (n4 - n5);
                float n10 = (n4 - n2) / (n4 - n5);
                float n11 = (n4 - n3) / (n4 - n5);
                if (n == n4) {
                    n12 = n11;
                    n13 = n10;
                } else if (n2 == n4) {
                    n12 = 2.0f + n9;
                    n13 = n11;
                } else {
                    n12 = 4.0f + n10;
                    n13 = n9;
                }
                n14 = (n12 - n13) / 6.0f;
                if (f2 >= 0.0f) break block11;
                n8 = n14 + 1.0f;
            }
            n14 = n8;
        }
        array[0] = n14;
        array[1] = n7;
        array[2] = n6;
        return array;
    }

    @Override
    public final ITransform getTransform() {
        Transform transform = new Transform(null);
        this.gc.getTransform(transform);
        TransformSWT b2 = new TransformSWT(transform);
        transform.dispose();
        return b2;
    }

    @Override
    public final void setTransform(ITransform transform) {
        Transform t = ((TransformSWT)transform).create();
        this.gc.setTransform(t);
        t.dispose();
    }

    @Override
    public final void transform(ITransform transform) {
        Transform transform2 = new Transform(null);
        this.gc.getTransform(transform2);
        TransformSWT b2 = new TransformSWT(transform2);
        transform2.dispose();
        b2.transform(transform);
        Transform t = b2.create();
        this.gc.setTransform(t);
        t.dispose();
    }

    @Override
    public final void translate(int n, int n2) {
        Transform transform = new Transform(null);
        this.gc.getTransform(transform);
        transform.translate((float)n, (float)n2);
        this.gc.setTransform(transform);
        transform.dispose();
    }

    @Override
    public final void setStrokeStyle(int n) {
        int lineStyle;
        GC gc;
        if (n == 0) {
            gc = this.gc;
            lineStyle = 1;
        } else {
            if (n != 1) {
                return;
            }
            gc = this.gc;
            lineStyle = 3;
        }
        gc.setLineStyle(lineStyle);
    }

    @Override
    public final int getStrokeStyle() {
        boolean b2 = this.gc.getLineStyle() != 1;
        return b2 ? 1 : 0;
    }

    @Override
    public IFont getFont() {
        return null;
    }

    @Override
    public void reset() {
        this.gc.setTransform(new Transform(null));
        this.gc.setClipping(0, 0, this.width, this.height);
    }
}

