/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.swt;

import emulator.graphics2D.CopyUtils;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.swt.Graphics2DSWT;
import emulator.graphics2D.swt.TransformSWT;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public final class ImageSWT
implements IImage {
    Image img;
    ImageData imgdata;
    Graphics2DSWT graphics;
    int[] rgb;
    int len;
    boolean transparent;
    boolean mutable;
    private static final PaletteData aPaletteData537 = new PaletteData(65280, 0xFF0000, -16777216);

    public ImageSWT(byte[] array) {
        this(new ByteArrayInputStream(array));
    }

    public ImageSWT(InputStream inputStream) {
        this.imgdata = new ImageData(inputStream);
        this.transparent = this.imgdata.getTransparencyType() != 0;
        this.mutable = false;
        this.len = this.imgdata.width * this.imgdata.height;
        this.rgb = new int[this.len];
        if (this.transparent && !this.imgdata.palette.isDirect && this.imgdata.transparentPixel != -1) {
            RGB rgb = this.imgdata.palette.colors[this.imgdata.transparentPixel];
            for (int i2 = this.imgdata.palette.colors.length - 1; i2 >= 0; --i2) {
                int red;
                RGB rgb2;
                if (i2 == this.imgdata.transparentPixel || !rgb.equals((Object)this.imgdata.palette.colors[i2])) continue;
                if (this.imgdata.palette.colors[i2].red == 255) {
                    rgb2 = this.imgdata.palette.colors[i2];
                    red = 254;
                } else {
                    rgb2 = this.imgdata.palette.colors[i2];
                    red = rgb2.red + 1;
                }
                rgb2.red = red;
            }
        }
        this.img = new Image(null, this.imgdata);
        this.mutable = true;
    }

    public ImageSWT(int n, int n2, boolean transparent, int n3) {
        this.img = new Image(null, n, n2);
        if (!transparent) {
            GC gc = new GC((Drawable)this.img);
            Color background = new Color(null, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
            gc.setBackground(background);
            gc.fillRectangle(0, 0, n, n2);
            gc.dispose();
            background.dispose();
        } else {
            GC gc = new GC((Drawable)this.img);
            gc.setAlpha(0);
            gc.fillRectangle(0, 0, n, n2);
            gc.dispose();
        }
        this.imgdata = this.img.getImageData();
        this.img.dispose();
        this.mutable = false;
        this.transparent = transparent;
        this.len = n * n2;
        this.rgb = new int[this.len];
    }

    public final void finalize() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        if (this.graphics != null) {
            this.graphics.finalize();
            this.graphics = null;
        }
        this.mutable = false;
    }

    @Override
    public final IGraphics2D createGraphics() {
        if (this.mutable) {
            if (this.graphics == null) {
                this.graphics = new Graphics2DSWT(this.img);
            } else {
                this.graphics.setTransform(new TransformSWT());
            }
        } else {
            this.img = new Image(null, this.imgdata.width, this.imgdata.height);
            GC gc = new GC((Drawable)this.img);
            Image image = new Image(null, this.imgdata);
            gc.drawImage(image, 0, 0);
            gc.dispose();
            image.dispose();
            if (this.graphics != null) {
                this.graphics.finalize();
                this.graphics = null;
            }
            this.graphics = new Graphics2DSWT(this.img);
            this.mutable = true;
        }
        return this.graphics;
    }

    @Override
    public final IGraphics2D getGraphics() {
        return this.graphics;
    }

    public final void method12(GC gc, int n, int n2) {
        if (this.mutable) {
            gc.drawImage(this.img, n, n2);
            return;
        }
        this.img = new Image(null, this.imgdata);
        gc.drawImage(this.img, n, n2);
        this.img.dispose();
    }

    @Override
    public final void copyToScreen(Object g, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GC gc = (GC)g;
        if (this.mutable) {
            gc.drawImage(this.img, n, n2, n3, n4, n5, n6, n7, n8);
            return;
        }
        this.img = new Image(null, this.imgdata);
        gc.drawImage(this.img, n, n2, n3, n4, n5, n6, n7, n8);
        this.img.dispose();
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void fill(int color) {
    }

    @Override
    public final void copyToScreen(Object g) {
        GC gc = (GC)g;
        if (this.mutable) {
            gc.drawImage(this.img, 0, 0);
            return;
        }
        this.img = new Image(null, this.imgdata);
        gc.drawImage(this.img, 0, 0);
        this.img.dispose();
    }

    @Override
    public final int getWidth() {
        return this.imgdata.width;
    }

    @Override
    public final int getHeight() {
        return this.imgdata.height;
    }

    @Override
    public final int[] getData() {
        if (this.mutable) {
            this.imgdata = this.img.getImageData();
        }
        this.imgdata.getPixels(0, 0, this.len, this.rgb, 0);
        if (this.imgdata.alphaData != null) {
            for (int i2 = this.len - 1; i2 >= 0; --i2) {
                RGB rgb = this.imgdata.palette.getRGB(this.rgb[i2]);
                this.rgb[i2] = (this.imgdata.alphaData[i2] << 24) + ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
            }
        } else if (this.imgdata.transparentPixel != -1 && !this.imgdata.palette.isDirect) {
            for (int j = this.len - 1; j >= 0; --j) {
                int n2;
                int n;
                int[] array;
                if (this.rgb[j] == this.imgdata.transparentPixel) {
                    array = this.rgb;
                    n = j;
                    n2 = 0;
                } else {
                    RGB rgb2 = this.imgdata.palette.getRGB(this.rgb[j]);
                    array = this.rgb;
                    n = j;
                    n2 = -16777216 + ((rgb2.red & 0xFF) << 16) + ((rgb2.green & 0xFF) << 8) + (rgb2.blue & 0xFF);
                }
                array[n] = n2;
            }
        } else if (this.imgdata.palette.isDirect && this.imgdata.depth == 32 && this.imgdata.palette.blueShift != 0) {
            for (int k2 = this.len - 1; k2 >= 0; --k2) {
                RGB rgb = this.imgdata.palette.getRGB(this.rgb[k2]);
                this.rgb[k2] = ((this.rgb[k2] & 0xFF) << 24) + ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
            }
        } else {
            for (int k3 = this.len - 1; k3 >= 0; --k3) {
                RGB rgb = this.imgdata.palette.getRGB(this.rgb[k3]);
                this.rgb[k3] = -16777216 + ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
            }
        }
        return this.rgb;
    }

    @Override
    public boolean directAccess() {
        return false;
    }

    @Override
    public final void setAlpha(int n, int n2, int n3, int n4, int n5) {
        if (n >= this.imgdata.width || n2 >= this.imgdata.height) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n + n3 > this.imgdata.width) {
            n3 = this.imgdata.width - n;
        }
        if (n2 + n4 > this.imgdata.height) {
            n4 = this.imgdata.height - n2;
        }
        byte[] array = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            array[i2] = (byte)n5;
        }
        if (this.imgdata.alphaData == null) {
            this.imgdata.alphaData = new byte[this.imgdata.width * this.imgdata.height];
        }
        for (int j = n2; j < n2 + n4; ++j) {
            System.arraycopy(array, 0, this.imgdata.alphaData, j * this.imgdata.width + n, n3);
        }
        if (this.mutable) {
            this.mutable = false;
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
            }
            if (this.graphics != null) {
                this.graphics.finalize();
                this.graphics = null;
            }
        }
    }

    @Override
    public final void setData(int[] array) {
        this.imgdata = new ImageData(this.imgdata.width, this.imgdata.height, 32, aPaletteData537);
        int n = this.len * 4 - 1;
        if (this.transparent) {
            if (this.imgdata.alphaData == null) {
                this.imgdata.alphaData = new byte[this.imgdata.width * this.imgdata.height];
            }
            for (int i2 = this.len - 1; i2 >= 0; --i2) {
                this.imgdata.alphaData[i2] = (byte)(array[i2] >> 24 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[i2] >> 24 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[i2] >> 16 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[i2] >> 8 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[i2] & 0xFF);
            }
        } else {
            for (int j = this.len - 1; j >= 0; --j) {
                this.imgdata.data[n--] = (byte)(array[j] >> 24 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[j] >> 16 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[j] >> 8 & 0xFF);
                this.imgdata.data[n--] = (byte)(array[j] & 0xFF);
            }
        }
        if (this.mutable) {
            this.mutable = false;
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
            }
            if (this.graphics != null) {
                this.graphics.finalize();
                this.graphics = null;
            }
        }
    }

    @Override
    public final int getRGB(int n, int n2) {
        if (this.mutable) {
            try {
                return this.method300(n, n2, this.img.getImageData());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this.method300(n, n2, this.imgdata);
            }
        }
        return this.method300(n, n2, this.imgdata);
    }

    @Override
    public void setRGB(int x, int y, int color) {
        this.imgdata.setPixel(x, y, color);
    }

    @Override
    public void setRGB(int x, int y, int w, int h2, int[] data, int off, int scan) {
    }

    @Override
    public void getRGB(int[] data, int off, int scan, int x, int y, int w, int h2) {
    }

    private int method300(int x, int y, ImageData imgdata) {
        RGB rgb = imgdata.palette.getRGB(imgdata.getPixel(x, y));
        return ((imgdata.getAlpha(x, y) & 0xFF) << 24) + ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
    }

    @Override
    public final void saveToFile(String s) {
        if (this.mutable) {
            try {
                this.imgdata = this.img.getImageData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            ImageIO.write((RenderedImage)CopyUtils.toAwtForCapture(this.imgdata), "png", new File(s));
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    @Override
    public void write(OutputStream out, String format) throws IOException {
        if (this.mutable) {
            this.imgdata = this.img.getImageData();
        }
        ImageIO.write((RenderedImage)CopyUtils.toAwtForCapture(this.imgdata), format, out);
    }

    @Override
    public final void copyToClipBoard() {
        if (this.mutable) {
            this.imgdata = this.img.getImageData();
        }
        CopyUtils.setClipboard(CopyUtils.toAwtForCapture(this.imgdata));
    }

    @Override
    public final void cloneImage(IImage target) {
        target.setData(this.getData());
    }

    @Override
    public void cloneImage(IImage target, int x, int y, int w, int h2) {
        target.setData(this.getData());
    }

    @Override
    public void copyImage(IGraphics2D destGraphics, int sx, int sy, int w, int h2, int tx, int ty) {
    }

    @Override
    public int size() {
        return this.len * 4;
    }

    @Override
    public Object getNative() {
        return this.img;
    }
}

