/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D;

public final class Vector4f {
    public static final Vector4f X_AXIS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f Y_AXIS = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f Z_AXIS = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f ORIGIN = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(Vector4f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        this.w = vec.w;
    }

    public Vector4f(float[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        this.w = vec[3];
    }

    public final void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final void set(Vector4f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        this.w = vec.w;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final void mul(float factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
        this.w *= factor;
    }

    public final void add(Vector4f vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        this.w += vec.w;
    }

    public final void sub(Vector4f vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        this.w -= vec.w;
    }

    public final void sub(Vector4f vec1, Vector4f vec2) {
        this.x = vec1.x - vec2.x;
        this.y = vec1.y - vec2.y;
        this.z = vec1.z - vec2.z;
        this.w = vec1.w - vec2.w;
    }

    public final float dot(Vector4f vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z + this.w * vec.w;
    }

    public final void cross(Vector4f vec1, Vector4f vec2) {
        this.x = vec1.y * vec2.z - vec1.z * vec2.y;
        this.y = vec1.z * vec2.x - vec1.x * vec2.z;
        this.z = vec1.x * vec2.y - vec1.y * vec2.x;
        this.w = 0.0f;
    }

    public final boolean normalize() {
        float length = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (length < 1.0E-5f) {
            return false;
        }
        float invLen = 1.0f / (float)Math.sqrt(length);
        this.x *= invLen;
        this.y *= invLen;
        this.z *= invLen;
        this.w *= invLen;
        return true;
    }

    public static void mul(float[] vec, float factor) {
        vec[0] = vec[0] * factor;
        vec[1] = vec[1] * factor;
        vec[2] = vec[2] * factor;
        vec[3] = vec[3] * factor;
    }

    public static void sub(float[] a2, float[] b2) {
        a2[0] = a2[0] - b2[0];
        a2[1] = a2[1] - b2[1];
        a2[2] = a2[2] - b2[2];
        a2[3] = a2[3] - b2[3];
    }

    public static void add(float[] a2, float[] b2) {
        a2[0] = a2[0] + b2[0];
        a2[1] = a2[1] + b2[1];
        a2[2] = a2[2] + b2[2];
        a2[3] = a2[3] + b2[3];
    }

    public static float length(float[] vec) {
        return (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2]);
    }
}

