/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.egl;

import emulator.graphics3D.egl.EGL11Impl;
import emulator.graphics3D.egl.EGLConfigImpl;
import emulator.graphics3D.egl.EGLContextImpl;
import emulator.graphics3D.egl.EGLDisplayImpl;
import emulator.graphics3D.egl.EGLSurfaceImpl;
import emulator.graphics3D.egl.GL10Impl;
import emulator.graphics3D.lwjgl.Emulator3D;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Image2D;
import org.lwjgl.opengl.GL11;

public class EGL10Impl
implements EGL10 {
    static EGL10Impl egl;
    public static Emulator3D g3d;

    public static EGL10Impl getEgl() {
        if (egl == null) {
            egl = new EGL11Impl();
            g3d = Emulator3D.getInstance();
        }
        return egl;
    }

    @Override
    public boolean eglChooseConfig(EGLDisplay eglDisplay, int[] attrib_list, EGLConfig[] configs, int config_size, int[] num_config) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (configs != null && configs.length < config_size) {
            throw new IllegalArgumentException("configs != null && configs.length < config_size");
        }
        if (!EGL10Impl.method778(attrib_list)) {
            throw new IllegalArgumentException("attrib_list not terminated with EGL.EGL_NONE");
        }
        if (num_config != null && num_config.length < 1) {
            throw new IllegalArgumentException("num_config != null && num_config.length < 1");
        }
        if (configs != null) {
            configs[0] = EGLConfigImpl.method779(1);
        }
        if (num_config != null) {
            num_config[0] = EGLConfigImpl.method780(configs);
        }
        return true;
    }

    @Override
    public boolean eglCopyBuffers(EGLDisplay eglDisplay, EGLSurface eglSurface, Object o) {
        return false;
    }

    @Override
    public EGLContext eglCreateContext(EGLDisplay eglDisplay, EGLConfig eglConfig, EGLContext share_context, int[] attrib_list) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (eglConfig == null) {
            throw new IllegalArgumentException("config == null");
        }
        if (share_context == null) {
            throw new IllegalArgumentException("share_context == null");
        }
        if (!EGL10Impl.method778(attrib_list)) {
            throw new IllegalArgumentException("attrib_list not terminated with EGL.EGL_NONE");
        }
        return EGLContextImpl.method765(1);
    }

    @Override
    public EGLSurface eglCreatePbufferSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, int[] array) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (eglConfig == null) {
            throw new IllegalArgumentException("config == null");
        }
        if (!EGL10Impl.method778(array)) {
            throw new IllegalArgumentException("attrib_list not terminated with EGL.EGL_NONE");
        }
        int n = 0;
        int n2 = 0;
        if (array != null) {
            for (int i2 = 0; i2 < array.length; i2 += 2) {
                if (array[i2] == 12375) {
                    n = array[i2 + 1];
                    continue;
                }
                if (array[i2] != 12374) continue;
                n2 = array[i2 + 1];
            }
        }
        EGLSurfaceImpl method781 = EGLSurfaceImpl.method781(3, n, n2);
        method781.method783(Image.createImage(n, n2).getGraphics());
        return method781;
    }

    @Override
    public EGLSurface eglCreatePixmapSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, Object o, int[] array) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (eglConfig == null) {
            throw new IllegalArgumentException("config == null");
        }
        if (!EGL10Impl.method778(array)) {
            throw new IllegalArgumentException("attrib_list not terminated with EGL.EGL_NONE");
        }
        if (o == null) {
            throw new IllegalArgumentException("pixmap == null");
        }
        if (!(o instanceof Graphics)) {
            throw new IllegalArgumentException("pixmap is not a Graphics instance");
        }
        Graphics graphics = (Graphics)o;
        EGLSurfaceImpl method781 = EGLSurfaceImpl.method781(2, graphics.getImage().getWidth(), graphics.getImage().getHeight());
        method781.method783(graphics);
        return method781;
    }

    @Override
    public EGLSurface eglCreateWindowSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, Object o, int[] array) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (eglConfig == null) {
            throw new IllegalArgumentException("config == null");
        }
        if (!EGL10Impl.method778(array)) {
            throw new IllegalArgumentException("attrib_list not terminated with EGL.EGL_NONE");
        }
        if (!(o instanceof Graphics)) {
            throw new IllegalArgumentException("win is not a Canvas, GameCanvas, EGLCanvas, or Graphics");
        }
        Graphics graphics = (Graphics)o;
        EGLSurfaceImpl method781 = EGLSurfaceImpl.method781(1, graphics.getImage().getWidth(), graphics.getImage().getHeight());
        method781.method783(graphics);
        return method781;
    }

    @Override
    public boolean eglDestroyContext(EGLDisplay eglDisplay, EGLContext eglContext) {
        return false;
    }

    @Override
    public boolean eglDestroySurface(EGLDisplay eglDisplay, EGLSurface eglSurface) {
        return false;
    }

    @Override
    public boolean eglGetConfigAttrib(EGLDisplay eglDisplay, EGLConfig eglConfig, int n, int[] array) {
        return false;
    }

    @Override
    public boolean eglGetConfigs(EGLDisplay eglDisplay, EGLConfig[] array, int n, int[] array2) {
        if (eglDisplay == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (array != null && array.length < n) {
            throw new IllegalArgumentException("configs != null && configs.length < config_size");
        }
        if (array2 != null && array2.length < 1) {
            throw new IllegalArgumentException("num_config != null && num_config.length < 1");
        }
        array2[0] = EGLConfigImpl.method780(array);
        return true;
    }

    @Override
    public EGLContext eglGetCurrentContext() {
        EGLContext value = (EGLContext)GL10Impl.threadToContext.get(Thread.currentThread());
        if (value == null) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return value;
    }

    @Override
    public EGLDisplay eglGetCurrentDisplay() {
        EGLContextImpl c2 = (EGLContextImpl)this.eglGetCurrentContext();
        if (c2 != EGL10.EGL_NO_CONTEXT) {
            return c2.getDisplay();
        }
        return EGL10.EGL_NO_DISPLAY;
    }

    @Override
    public EGLSurface eglGetCurrentSurface(int n) {
        if (n != 12378 && n != 12377) {
            throw new IllegalArgumentException("readdraw not one of EGL.EGL_READ or EGL.EGL_DRAW");
        }
        EGLContextImpl c2 = (EGLContextImpl)this.eglGetCurrentContext();
        if (c2 == EGL10.EGL_NO_CONTEXT) {
            return EGL10.EGL_NO_SURFACE;
        }
        if (n == 12378) {
            return c2.method766();
        }
        return c2.method762();
    }

    @Override
    public EGLDisplay eglGetDisplay(Object display) {
        if (display == EGL10.EGL_DEFAULT_DISPLAY) {
            return EGLDisplayImpl.method803(1);
        }
        throw new IllegalArgumentException("display != EGL.EGL_DEFAULT_DISPLAY");
    }

    @Override
    public int eglGetError() {
        return 0;
    }

    @Override
    public boolean eglInitialize(EGLDisplay display, int[] maj_min) {
        if (display == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (maj_min != null && maj_min.length < 2) {
            throw new IllegalArgumentException("major_minor != null && major_minor.length < 2");
        }
        EGLConfigImpl.method779(1);
        EGLConfigImpl.method779(2);
        EGLConfigImpl.method779(3);
        if (maj_min != null) {
            maj_min[0] = 1;
            maj_min[1] = 1;
        }
        return true;
    }

    @Override
    public boolean eglMakeCurrent(EGLDisplay display, EGLSurface draw, EGLSurface read, EGLContext context) {
        if (display == null) {
            throw new IllegalArgumentException("display == null");
        }
        if (draw == null) {
            throw new IllegalArgumentException("draw == null (perhaps you meant EGL.EGL_NO_SURFACE)");
        }
        if (read == null) {
            throw new IllegalArgumentException("read == null (perhaps you meant EGL.EGL_NO_SURFACE)");
        }
        if (context == null) {
            throw new IllegalArgumentException("context == null (perhaps you meant EGL.EGL_NO_CONTEXT)");
        }
        Thread currentThread = Thread.currentThread();
        if (context == EGL10.EGL_NO_CONTEXT) {
            Object value = GL10Impl.threadToContext.get(currentThread);
            if (value != null) {
                EGLContextImpl c2 = (EGLContextImpl)value;
                if (c2.method764()) {
                    this.eglDestroyContext(c2.getDisplay(), c2);
                }
                c2.setDisplay(null);
                c2.method763(null);
                c2.method767(null);
                GL10Impl.contextToThread.remove(c2);
                GL10Impl.displayThread.remove(c2);
                GL10Impl.drawSurfaceThread.remove(c2);
                GL10Impl.readSurfaceThread.remove(c2);
                GL10Impl.threadToContext.remove(currentThread);
                g3d.releaseTarget();
            }
        } else {
            EGLContextImpl c2 = (EGLContextImpl)context;
            c2.setDisplay((EGLDisplayImpl)display);
            c2.method763((EGLSurfaceImpl)draw);
            c2.method767((EGLSurfaceImpl)read);
            GL10Impl.contextToThread.put(c2, currentThread);
            GL10Impl.displayThread.put(c2, display);
            GL10Impl.drawSurfaceThread.put(c2, draw);
            GL10Impl.readSurfaceThread.put(c2, read);
            GL10Impl.threadToContext.put(currentThread, context);
            g3d.bindTarget(c2.method762().method784(), true);
        }
        return true;
    }

    @Override
    public boolean eglQueryContext(EGLDisplay eglDisplay, EGLContext eglContext, int n, int[] array) {
        return true;
    }

    @Override
    public String eglQueryString(EGLDisplay eglDisplay, int n) {
        return null;
    }

    @Override
    public boolean eglQuerySurface(EGLDisplay eglDisplay, EGLSurface eglSurface, int n, int[] array) {
        return true;
    }

    @Override
    public boolean eglSwapBuffers(EGLDisplay eglDisplay, EGLSurface eglSurface) {
        try {
            g3d.swapBuffers();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean eglTerminate(EGLDisplay eglDisplay) {
        return true;
    }

    @Override
    public boolean eglWaitGL() {
        try {
            g3d.swapBuffers();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean eglWaitNative(int n, Object o) {
        try {
            Graphics graphics = (Graphics)o;
            g3d.setViewport(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
            Background background = new Background();
            background.setColor(GL10Impl.anInt1359);
            background.setImage(new Image2D(99, new Image(graphics.getImage())));
            background.setCrop(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
            g3d.sync(() -> {
                g3d.clearBackgound(background);
                if (GL10Impl.aBoolean1355) {
                    GL11.glEnable(2896);
                } else {
                    GL11.glDisable(2896);
                }
                if (GL10Impl.aBoolean1358) {
                    GL11.glEnable(2912);
                } else {
                    GL11.glDisable(2912);
                }
                GL11.glMatrixMode(GL10Impl.anInt1354);
            });
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static boolean method778(int[] array) {
        if (array == null) {
            return true;
        }
        for (int i2 = 0; i2 < array.length; i2 += 2) {
            if (array[i2] != 12344) continue;
            return true;
        }
        return false;
    }
}

