/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.egl;

import emulator.graphics3D.egl.EGL10Impl;
import emulator.graphics3D.egl.GLConfiguration;
import emulator.graphics3D.egl.PaletteTextureDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Hashtable;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL10Ext;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.system.MemoryUtil;

public class GL10Impl
implements GL10,
GL10Ext {
    static int anInt1354;
    static boolean aBoolean1355;
    static boolean aBoolean1358;
    static int anInt1359;
    EGLContext eglContext = null;
    public static Hashtable threadToContext;
    public static Hashtable contextToThread;
    public static Hashtable displayThread;
    public static Hashtable readSurfaceThread;
    public static Hashtable drawSurfaceThread;
    protected Object temp;

    @Override
    public synchronized void glActiveTexture(int n) {
        EGL10Impl.g3d.async(() -> GL13.glActiveTexture(n));
    }

    @Override
    public synchronized void glAlphaFunc(int n, float n2) {
        EGL10Impl.g3d.async(() -> GL11.glAlphaFunc(n, n2));
    }

    @Override
    public synchronized void glAlphaFuncx(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glAlphaFunc(n, (float)n2 / 65536.0f));
    }

    @Override
    public synchronized void glBindTexture(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glBindTexture(n, n2));
    }

    @Override
    public synchronized void glBlendFunc(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glBlendFunc(n, n2));
    }

    @Override
    public synchronized void glClear(int n) {
        EGL10Impl.g3d.sync(() -> GL11.glClear(n));
    }

    @Override
    public synchronized void glClearColor(float n, float n2, float n3, float n4) {
        anInt1359 = ((int)(n4 * 255.0f) << 24) + ((int)(n * 255.0f) << 16) + ((int)(n2 * 255.0f) << 8) + (int)(n3 * 255.0f);
        EGL10Impl.g3d.async(() -> GL11.glClearColor(n, n2, n3, n4));
    }

    @Override
    public synchronized void glClearColorx(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.async(() -> this.glClearColor((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f));
    }

    @Override
    public synchronized void glClearDepthf(float n) {
        EGL10Impl.g3d.async(() -> GL11.glClearDepth(n));
    }

    @Override
    public synchronized void glClearDepthx(int n) {
        EGL10Impl.g3d.async(() -> GL11.glClearDepth((float)n / 65536.0f));
    }

    @Override
    public synchronized void glClearStencil(int n) {
        EGL10Impl.g3d.async(() -> GL11.glClearStencil(n));
    }

    @Override
    public synchronized void glClientActiveTexture(int n) {
        EGL10Impl.g3d.async(() -> GL13.glClientActiveTexture(n));
    }

    @Override
    public synchronized void glColor4f(float n, float n2, float n3, float n4) {
        EGL10Impl.g3d.async(() -> GL11.glColor4f(n, n2, n3, n4));
    }

    @Override
    public synchronized void glColor4x(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.async(() -> this.glColor4f((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f));
    }

    public synchronized void glColor4ub(byte b2, byte b22, byte b3, byte b4) {
        EGL10Impl.g3d.async(() -> GL11.glColor4ub(b2, b22, b3, b4));
    }

    @Override
    public synchronized void glColorMask(boolean b2, boolean b22, boolean b3, boolean b4) {
        EGL10Impl.g3d.async(() -> GL11.glColorMask(b2, b22, b3, b4));
    }

    @Override
    public synchronized void glColorPointer(int n, int n2, int n3, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL11.glColorPointer(n, n2, n3, MemoryUtil.memAddress(buffer)));
    }

    private boolean isPaletteFormat(int format) {
        switch (format) {
            case 35728: 
            case 35729: 
            case 35730: 
            case 35731: 
            case 35732: 
            case 35733: 
            case 35734: 
            case 35735: 
            case 35736: 
            case 35737: {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int n7, Buffer data) {
        if (this.isPaletteFormat(internalformat)) {
            ByteBuffer newData = PaletteTextureDecoder.decode(internalformat, (ByteBuffer)data, width, height);
            this.glTexImage2D(target, level, 6408, width, height, border, 6408, 5121, newData);
        } else {
            EGL10Impl.g3d.sync(() -> GL13.glCompressedTexImage2D(target, level, internalformat, width, height, border, n7, MemoryUtil.memAddress(data)));
        }
    }

    @Override
    public synchronized void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL13.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public synchronized void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        EGL10Impl.g3d.sync(() -> GL11.glCopyTexImage2D(n, n2, n3, n4, n5, n6, n7, n8));
    }

    @Override
    public synchronized void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        EGL10Impl.g3d.sync(() -> GL11.glCopyTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8));
    }

    @Override
    public synchronized void glCullFace(int n) {
        EGL10Impl.g3d.async(() -> GL11.glCullFace(n));
    }

    @Override
    public synchronized void glDeleteTextures(int n, int[] array, int n2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        intBuffer.put(array, n2, n);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glDeleteTextures(intBuffer));
    }

    @Override
    public synchronized void glDeleteTextures(int n, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glDeleteTextures(intBuffer));
    }

    @Override
    public synchronized void glDepthFunc(int n) {
        EGL10Impl.g3d.async(() -> GL11.glDepthFunc(n));
    }

    @Override
    public synchronized void glDepthMask(boolean b2) {
        EGL10Impl.g3d.sync(() -> GL11.glDepthMask(b2));
    }

    @Override
    public synchronized void glDepthRangef(float n, float n2) {
        EGL10Impl.g3d.async(() -> GL11.glDepthRange(n, n2));
    }

    @Override
    public synchronized void glDepthRangex(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glDepthRange((float)n / 65536.0f, (float)n2 / 65536.0f));
    }

    @Override
    public synchronized void glDisable(int n) {
        if (n == 2896) {
            aBoolean1355 = true;
        } else if (n == 2912) {
            aBoolean1358 = true;
        }
        EGL10Impl.g3d.async(() -> GL11.glDisable(n));
    }

    @Override
    public synchronized void glDisableClientState(int n) {
        EGL10Impl.g3d.async(() -> GL11.glDisableClientState(n));
    }

    @Override
    public synchronized void glDrawArrays(int n, int n2, int n3) {
        EGL10Impl.g3d.sync(() -> GL11.glDrawArrays(n, n2, n3));
    }

    @Override
    public synchronized void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL11.glDrawElements(n, n2, n3, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public synchronized void glEnable(int n) {
        if (n == 2896) {
            aBoolean1355 = true;
        } else if (n == 2912) {
            aBoolean1358 = true;
        }
        EGL10Impl.g3d.async(() -> GL11.glEnable(n));
    }

    @Override
    public synchronized void glEnableClientState(int n) {
        EGL10Impl.g3d.async(() -> GL11.glEnableClientState(n));
    }

    @Override
    public synchronized void glFinish() {
        EGL10Impl.g3d.sync(GL11::glFinish);
    }

    @Override
    public synchronized void glFlush() {
        EGL10Impl.g3d.sync(GL11::glFlush);
    }

    @Override
    public synchronized void glFogf(int n, float n2) {
        EGL10Impl.g3d.async(() -> GL11.glFogf(n, n2));
    }

    @Override
    public synchronized void glFogfv(int n, float[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        floatBuffer.put(array, n2, method768);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glFogfv(n, floatBuffer));
    }

    @Override
    public synchronized void glFogfv(int n, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glFogfv(n, floatBuffer));
    }

    @Override
    public synchronized void glFogx(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glFogi(n, n2));
    }

    @Override
    public synchronized void glFogxv(int n, int[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put((float)array[n2 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glFogfv(n, floatBuffer));
    }

    @Override
    public synchronized void glFogxv(int n, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n);
        int position = intBuffer.position();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put((float)intBuffer.get(position + i2) / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glFogfv(n, floatBuffer));
    }

    @Override
    public synchronized void glFrontFace(int n) {
        EGL10Impl.g3d.async(() -> GL11.glFrontFace(n));
    }

    @Override
    public synchronized void glFrustumf(float n, float n2, float n3, float n4, float n5, float n6) {
        EGL10Impl.g3d.async(() -> GL11.glFrustum(n, n2, n3, n4, n5, n6));
    }

    @Override
    public synchronized void glFrustumx(int n, int n2, int n3, int n4, int n5, int n6) {
        EGL10Impl.g3d.async(() -> this.glFrustumf((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f, (float)n5 / 65536.0f, (float)n6 / 65536.0f));
    }

    @Override
    public synchronized void glGenTextures(int n, int[] array, int n2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        EGL10Impl.g3d.sync(() -> GL11.glGenTextures(intBuffer));
        intBuffer.get(array, n2, n);
    }

    @Override
    public synchronized void glGenTextures(int n, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGenTextures(intBuffer));
    }

    public synchronized void glGetBooleanv(int n, boolean[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetBooleanv(n, byteBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n2 + i2] = byteBuffer.get(i2) == 1;
        }
    }

    public synchronized void glGetBooleanv(int n, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetBooleanv(n, byteBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            intBuffer.put(byteBuffer.get(i2));
        }
    }

    @Override
    public synchronized void glGetIntegerv(int n, int[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetIntegerv(n, intBuffer));
        intBuffer.get(array, n2, method768);
    }

    @Override
    public synchronized void glGetIntegerv(int n, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n);
        IntBuffer intBuffer2 = BufferUtils.createIntBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetIntegerv(n, intBuffer2));
        for (int i2 = 0; i2 < method768; ++i2) {
            intBuffer.put(intBuffer2.get(i2));
        }
    }

    @Override
    public synchronized int glGetError() {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glGetError();
        });
        return (Integer)this.temp;
    }

    @Override
    public synchronized String glGetString(int n) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glGetString(n);
        });
        return (String)this.temp;
    }

    @Override
    public synchronized void glHint(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glHint(n, n2));
    }

    @Override
    public synchronized void glLightModelf(int n, float n2) {
        EGL10Impl.g3d.async(() -> GL11.glLightModelf(n, n2));
    }

    @Override
    public synchronized void glLightModelfv(int n, float[] array, int n2) {
        int method772 = GLConfiguration.method772(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method772);
        floatBuffer.put(array, n2, method772);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightModelfv(n, floatBuffer));
    }

    @Override
    public synchronized void glLightModelfv(int n, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glLightModelfv(n, floatBuffer));
    }

    @Override
    public synchronized void glLightModelx(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glLightModelf(n, (float)n2 / 65536.0f));
    }

    @Override
    public synchronized void glLightModelxv(int n, int[] array, int n2) {
        int method772 = GLConfiguration.method772(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method772);
        for (int i2 = 0; i2 < method772; ++i2) {
            floatBuffer.put((float)array[n2 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightModelfv(n, floatBuffer));
    }

    @Override
    public synchronized void glLightModelxv(int n, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n);
        int position = intBuffer.position();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put((float)intBuffer.get(position + i2) / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightModelfv(n, floatBuffer));
    }

    @Override
    public synchronized void glLightf(int n, int n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glLightf(n, n2, n3));
    }

    @Override
    public synchronized void glLightfv(int n, int n2, float[] array, int n3) {
        int method770 = GLConfiguration.method770(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4);
        floatBuffer.put(array, n3, method770);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glLightfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glLightx(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glLightf(n, n2, (float)n3 / 65536.0f));
    }

    @Override
    public synchronized void glLightxv(int n, int n2, int[] array, int n3) {
        int method770 = GLConfiguration.method770(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method770);
        for (int i2 = 0; i2 < method770; ++i2) {
            floatBuffer.put((float)array[n3 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glLightxv(int n, int n2, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n2);
        int position = intBuffer.position();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put((float)intBuffer.get(position + i2) / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLightfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glLineWidth(float n) {
        EGL10Impl.g3d.async(() -> GL11.glLineWidth(n));
    }

    @Override
    public synchronized void glLineWidthx(int n) {
        EGL10Impl.g3d.async(() -> GL11.glLineWidth((float)n / 65536.0f));
    }

    @Override
    public synchronized void glLoadIdentity() {
        EGL10Impl.g3d.async(GL11::glLoadIdentity);
    }

    @Override
    public synchronized void glLoadMatrixf(float[] array, int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        floatBuffer.put(array, n, 16);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLoadMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glLoadMatrixf(FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glLoadMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glLoadMatrixx(int[] array, int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatBuffer.put((float)array[n + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLoadMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glLoadMatrixx(IntBuffer intBuffer) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glLoadMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glLogicOp(int n) {
        EGL10Impl.g3d.async(() -> GL11.glLogicOp(n));
    }

    @Override
    public synchronized void glMaterialf(int n, int n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glMaterialf(n, n2, n3));
    }

    @Override
    public synchronized void glMaterialfv(int n, int n2, float[] array, int n3) {
        int method773 = GLConfiguration.method773(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method773);
        floatBuffer.put(array, n3, method773);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMaterialfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glMaterialfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glMaterialx(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glMaterialf(n, n2, (float)n3 / 65536.0f));
    }

    @Override
    public synchronized void glMaterialxv(int n, int n2, int[] array, int n3) {
        int method773 = GLConfiguration.method773(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method773);
        for (int i2 = 0; i2 < method773; ++i2) {
            floatBuffer.put((float)array[n3 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMaterialfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glMaterialxv(int n, int n2, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n2);
        int position = intBuffer.position();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put((float)intBuffer.get(position + i2) / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMaterialfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glMatrixMode(int anInt1354) {
        EGL10Impl.g3d.async(() -> {
            GL10Impl.anInt1354 = anInt1354;
            GL11.glMatrixMode(GL10Impl.anInt1354);
        });
    }

    @Override
    public synchronized void glMultMatrixf(float[] array, int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        floatBuffer.put(array, n, 16);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMultMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glMultMatrixf(FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glMultMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glMultMatrixx(int[] array, int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatBuffer.put((float)array[i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMultMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glMultMatrixx(IntBuffer intBuffer) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glMultMatrixf(floatBuffer));
    }

    @Override
    public synchronized void glMultiTexCoord4f(int n, float n2, float n3, float n4, float n5) {
        EGL10Impl.g3d.async(() -> GL13.glMultiTexCoord4f(n, n2, n3, n4, n5));
    }

    @Override
    public synchronized void glMultiTexCoord4x(int n, int n2, int n3, int n4, int n5) {
        EGL10Impl.g3d.async(() -> this.glMultiTexCoord4f(n, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f, (float)n5 / 65536.0f));
    }

    @Override
    public synchronized void glNormal3f(float n, float n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glNormal3f(n, n2, n3));
    }

    @Override
    public synchronized void glNormal3x(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glNormal3f((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f));
    }

    @Override
    public synchronized void glNormalPointer(int n, int n2, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL11.glNormalPointer(n, n2, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public synchronized void glOrthof(float n, float n2, float n3, float n4, float n5, float n6) {
        EGL10Impl.g3d.async(() -> GL11.glOrtho(n, n2, n3, n4, n5, n6));
    }

    @Override
    public synchronized void glOrthox(int n, int n2, int n3, int n4, int n5, int n6) {
        EGL10Impl.g3d.async(() -> this.glOrthof((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f, (float)n5 / 65536.0f, (float)n6 / 65536.0f));
    }

    @Override
    public synchronized void glPixelStorei(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glPixelStorei(n, n2));
    }

    public synchronized void glPointParameterf(int n, float n2) {
        EGL10Impl.g3d.async(() -> GL14.glPointParameterf(n, n2));
    }

    public synchronized void glPointParameterfv(int n, float[] array, int n2) {
        int method774 = GLConfiguration.method774(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method774);
        floatBuffer.put(array, n2, method774);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL14.glPointParameterfv(n, floatBuffer));
    }

    public synchronized void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL14.glPointParameterfv(n, floatBuffer));
    }

    public synchronized void glPointParameterx(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL14.glPointParameteri(n, n2));
    }

    public synchronized void glPointParameterxv(int n, int[] array, int n2) {
        int method774 = GLConfiguration.method774(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method774);
        for (int i2 = 0; i2 < method774; ++i2) {
            floatBuffer.put((float)array[n2 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL14.glPointParameterfv(n, floatBuffer));
    }

    public synchronized void glPointParameterxv(int n, IntBuffer intBuffer) {
        int method774 = GLConfiguration.method774(n);
        int position = intBuffer.position();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method774);
        for (int i2 = 0; i2 < method774; ++i2) {
            floatBuffer.put((float)intBuffer.get(position + i2) / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL14.glPointParameterfv(n, floatBuffer));
    }

    @Override
    public synchronized void glPointSize(float n) {
        EGL10Impl.g3d.async(() -> GL11.glPointSize(n));
    }

    @Override
    public synchronized void glPointSizex(int n) {
        EGL10Impl.g3d.async(() -> GL11.glPointSize((float)n / 65536.0f));
    }

    @Override
    public synchronized void glPolygonOffset(float n, float n2) {
        EGL10Impl.g3d.async(() -> GL11.glPolygonOffset(n, n2));
    }

    @Override
    public synchronized void glPolygonOffsetx(int n, int n2) {
        EGL10Impl.g3d.async(() -> GL11.glPolygonOffset((float)n / 65536.0f, (float)n2 / 65536.0f));
    }

    @Override
    public synchronized void glPopMatrix() {
        EGL10Impl.g3d.async(GL11::glPopMatrix);
    }

    @Override
    public synchronized void glPushMatrix() {
        EGL10Impl.g3d.async(GL11::glPushMatrix);
    }

    @Override
    public synchronized void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glReadPixels(n, n2, n3, n4, n5, n6, (ByteBuffer)buffer));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glReadPixels(n, n2, n3, n4, n5, n6, (ShortBuffer)buffer));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glReadPixels(n, n2, n3, n4, n5, n6, (IntBuffer)buffer));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glReadPixels(n, n2, n3, n4, n5, n6, (FloatBuffer)buffer));
        }
    }

    @Override
    public synchronized void glRotatef(float n, float n2, float n3, float n4) {
        EGL10Impl.g3d.async(() -> GL11.glRotatef(n, n2, n3, n4));
    }

    @Override
    public synchronized void glRotatex(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.async(() -> GL11.glRotatef((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f));
    }

    @Override
    public synchronized void glSampleCoverage(float n, boolean b2) {
        EGL10Impl.g3d.async(() -> GL13.glSampleCoverage(n, b2));
    }

    @Override
    public synchronized void glSampleCoveragex(int n, boolean b2) {
        EGL10Impl.g3d.async(() -> GL13.glSampleCoverage((float)n / 65536.0f, b2));
    }

    @Override
    public synchronized void glScalef(float n, float n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glScalef(n, n2, n3));
    }

    @Override
    public synchronized void glScalex(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glScalef((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f));
    }

    @Override
    public synchronized void glScissor(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.async(() -> GL11.glScissor(n, n2, n3, n4));
    }

    @Override
    public synchronized void glShadeModel(int n) {
        EGL10Impl.g3d.async(() -> GL11.glShadeModel(n));
    }

    @Override
    public synchronized void glStencilFunc(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glStencilFunc(n, n2, n3));
    }

    @Override
    public synchronized void glStencilMask(int n) {
        EGL10Impl.g3d.async(() -> GL11.glStencilMask(n));
    }

    @Override
    public synchronized void glStencilOp(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glStencilOp(n, n2, n3));
    }

    @Override
    public synchronized void glTexCoordPointer(int n, int n2, int n3, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL11.glTexCoordPointer(n, n2, n3, MemoryUtil.memAddress(buffer)));
    }

    public synchronized void glTexEnvi(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glTexEnvi(n, n2, n3));
    }

    public synchronized void glTexEnviv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method775);
        intBuffer.put(array, n3, method775);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexEnviv(n, n2, intBuffer));
    }

    public synchronized void glTexEnviv(int n, int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glTexEnviv(n, n2, intBuffer));
    }

    @Override
    public synchronized void glTexEnvf(int n, int n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glTexEnvf(n, n2, n3));
    }

    @Override
    public synchronized void glTexEnvfv(int n, int n2, float[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        floatBuffer.put(array, n3, method775);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexEnvfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glTexEnvfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glTexEnvx(int n, int n2, int n3) {
        this.glTexEnvi(n, n2, n3);
    }

    @Override
    public synchronized void glTexEnvxv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        for (int i2 = 0; i2 < method775; ++i2) {
            floatBuffer.put((float)array[n3 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexEnvfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        for (int i2 = 0; i2 < method775; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexEnvfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, (ByteBuffer)buffer));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, (ShortBuffer)buffer));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, (IntBuffer)buffer));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, (FloatBuffer)buffer));
            return;
        }
        if (buffer instanceof DoubleBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, (DoubleBuffer)buffer));
            return;
        }
    }

    @Override
    public synchronized void glTexParameterf(int n, int n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glTexParameterf(n, n2, n3));
    }

    @Override
    public synchronized void glTexParameterx(int n, int n2, int n3) {
        this.glTexParameterf(n, n2, n3);
    }

    public synchronized void glTexParameterfv(int n, int n2, float[] array, int n3) {
        int method776 = GLConfiguration.method776(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method776);
        floatBuffer.put(array, n3, method776);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexParameterfv(n, n2, floatBuffer));
    }

    public synchronized void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glTexParameterfv(n, n2, floatBuffer));
    }

    public synchronized void glTexParameteri(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glTexParameteri(n, n2, n3));
    }

    public synchronized void glTexParameteriv(int n, int n2, int[] array, int n3) {
        int method776 = GLConfiguration.method776(n2);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method776);
        intBuffer.put(array, n3, method776);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexParameteriv(n, n2, intBuffer));
    }

    public synchronized void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glTexParameteriv(n, n2, intBuffer));
    }

    public synchronized void glTexParameterxv(int n, int n2, int[] array, int n3) {
        int method776 = GLConfiguration.method776(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method776);
        for (int i2 = 0; i2 < method776; ++i2) {
            floatBuffer.put((float)array[n3 + i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexParameterfv(n, n2, floatBuffer));
    }

    public synchronized void glTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        int method776 = GLConfiguration.method776(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method776);
        for (int i2 = 0; i2 < method776; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexParameterfv(n, n2, floatBuffer));
    }

    @Override
    public synchronized void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, (ByteBuffer)buffer));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, (ShortBuffer)buffer));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL11.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, (IntBuffer)buffer));
        }
    }

    @Override
    public synchronized void glTranslatef(float n, float n2, float n3) {
        EGL10Impl.g3d.async(() -> GL11.glTranslatef(n, n2, n3));
    }

    @Override
    public synchronized void glTranslatex(int n, int n2, int n3) {
        EGL10Impl.g3d.async(() -> GL11.glTranslatef((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f));
    }

    @Override
    public synchronized void glVertexPointer(int n, int n2, int n3, Buffer buffer) {
        EGL10Impl.g3d.sync(() -> GL11.glVertexPointer(n, n2, n3, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public synchronized void glViewport(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.async(() -> GL11.glViewport(n, n2, n3, n4));
    }

    @Override
    public synchronized int glQueryMatrixxOES(int[] array, int n, int[] array2, int n2) {
        System.out.println("GL10Ext.glQueryMatrixxOES is not implemented.");
        return 0;
    }

    public GL10Impl(EGLContext anEGLContext1356) {
        this.eglContext = anEGLContext1356;
    }

    static {
        EGLContext.getEGL();
        threadToContext = new Hashtable();
        contextToThread = new Hashtable();
        displayThread = new Hashtable();
        readSurfaceThread = new Hashtable();
        drawSurfaceThread = new Hashtable();
    }
}

