/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.egl;

import emulator.graphics3D.egl.EGL10Impl;
import emulator.graphics3D.egl.GL10Impl;
import emulator.graphics3D.egl.GLConfiguration;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL11Ext;
import javax.microedition.khronos.opengles.GL11ExtensionPack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public final class GL11Impl
extends GL10Impl
implements javax.microedition.khronos.opengles.GL11,
GL11Ext,
GL11ExtensionPack {
    private static final int OES_MATRIX_PALETTE = 34880;
    private static final int OES_MATRIX_INDEX_ARRAY = 34884;
    private static final int OES_WEIGHT_ARRAY = 34477;
    private boolean oesMatrixPaletteEnabled = false;
    private boolean oesMatrixIndexArrayEnabled = false;
    private boolean oesWeightArrayEnabled = false;
    private Buffer oesMatrixIndexBuffer = null;
    private int oesMatrixIndexSize;
    private int oesMatrixIndexType;
    private int oesMatrixIndexStride;
    private int oesMatrixIndexOffset;
    private boolean oesMatrixIndexIsOffset = false;
    private Buffer oesWeightBuffer;
    private int oesWeightSize;
    private int oesWeightType;
    private int oesWeightStride;
    private int oesWeightOffset;
    private boolean oesWeightIsOffset;
    private final float[][] paletteMatrices = new float[32][16];
    private int currentPaletteMatrix = 0;
    protected int vertexSize;
    protected int vertexType;
    protected int vertexStride;
    protected int vertexOffset;
    protected boolean vertexIsOffset;
    protected FloatBuffer vertexBuffer;
    protected boolean normalArrayEnabled;
    protected int normalType;
    protected int normalStride;
    protected Buffer normalBuffer;
    protected boolean normalIsOffset;
    protected int normalOffset;

    @Override
    public final synchronized boolean glIsBuffer(int n) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL15.glIsBuffer(n);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized boolean glIsEnabled(int n) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glIsEnabled(n);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized boolean glIsTexture(int n) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glIsTexture(n);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glGenBuffers(int n, int[] array, int n2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        EGL10Impl.g3d.sync(() -> GL15.glGenBuffers(intBuffer));
        intBuffer.get(array, n2, n);
    }

    @Override
    public final synchronized void glGenBuffers(int n, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glGenBuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteBuffers(int n, int[] array, int n2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        intBuffer.put(array, n2, n);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL15.glDeleteBuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteBuffers(int n, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glDeleteBuffers(intBuffer));
    }

    @Override
    public final synchronized void glBindBuffer(int n, int n2) {
        EGL10Impl.g3d.sync(() -> GL15.glBindBuffer(n, n2));
    }

    @Override
    public final synchronized void glBufferData(int n, int n2, Buffer buffer, int n3) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n, (ByteBuffer)buffer, n3));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n, (ShortBuffer)buffer, n3));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n, (IntBuffer)buffer, n3));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n, (FloatBuffer)buffer, n3));
        }
    }

    @Override
    public final synchronized void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n, (long)n2, (ByteBuffer)buffer));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n, (long)n2, (ShortBuffer)buffer));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n, (long)n2, (IntBuffer)buffer));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n, (long)n2, (FloatBuffer)buffer));
        }
    }

    @Override
    public final synchronized void glGetBufferParameteriv(int n, int n2, int[] array, int n3) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        intBuffer.put(array, n3, GLConfiguration.method769());
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL15.glGetBufferParameteriv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glGetBufferParameteriv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glColorPointer(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.sync(() -> GL11.glColorPointer(n, n2, n3, n4));
    }

    @Override
    public final synchronized void glNormalPointer(int type, int stride, Buffer pointer) {
        this.normalType = type;
        this.normalStride = stride;
        this.normalBuffer = pointer;
        this.normalIsOffset = false;
        EGL10Impl.g3d.async(() -> GL11.glNormalPointer(type, stride, MemoryUtil.memAddress(pointer)));
    }

    @Override
    public final synchronized void glNormalPointer(int type, int stride, int offset) {
        this.normalType = type;
        this.normalStride = stride;
        this.normalOffset = offset;
        this.normalIsOffset = true;
        this.normalBuffer = null;
        EGL10Impl.g3d.async(() -> GL11.glNormalPointer(type, stride, offset));
    }

    @Override
    public final synchronized void glTexCoordPointer(int n, int n2, int n3, int n4) {
        EGL10Impl.g3d.sync(() -> GL11.glTexCoordPointer(n, n2, n3, n4));
    }

    @Override
    public synchronized void glVertexPointer(int size, int type, int stride, Buffer pointer) {
        this.vertexSize = size;
        this.vertexType = type;
        this.vertexStride = stride;
        this.vertexIsOffset = false;
        this.vertexBuffer = pointer instanceof FloatBuffer ? (FloatBuffer)pointer : null;
        EGL10Impl.g3d.async(() -> GL11.glVertexPointer(size, type, stride, MemoryUtil.memAddress(pointer)));
    }

    @Override
    public synchronized void glVertexPointer(int size, int type, int stride, int pointerOffset) {
        this.vertexSize = size;
        this.vertexType = type;
        this.vertexStride = stride;
        this.vertexOffset = pointerOffset;
        this.vertexIsOffset = true;
        this.vertexBuffer = null;
        EGL10Impl.g3d.async(() -> GL11.glVertexPointer(size, type, stride, pointerOffset));
    }

    @Override
    public final synchronized void glClipPlanef(int n, float[] array, int n2) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put(array[n2]);
        doubleBuffer.put(array[n2 + 1]);
        doubleBuffer.put(array[n2 + 2]);
        doubleBuffer.put(array[n2 + 3]);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanef(int n, FloatBuffer floatBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanex(int n, int[] array, int n2) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put((float)array[n2] / 65536.0f);
        doubleBuffer.put((float)array[n2 + 1] / 65536.0f);
        doubleBuffer.put((float)array[n2 + 2] / 65536.0f);
        doubleBuffer.put((float)array[n2 + 3] / 65536.0f);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanex(int n, IntBuffer intBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n, doubleBuffer));
    }

    @Override
    public final synchronized void glGetClipPlanef(int n, float[] array, int n2) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n, doubleBuffer));
        array[n2] = (float)doubleBuffer.get(0);
        array[n2 + 1] = (float)doubleBuffer.get(1);
        array[n2 + 2] = (float)doubleBuffer.get(2);
        array[n2 + 3] = (float)doubleBuffer.get(3);
    }

    @Override
    public final synchronized void glGetClipPlanef(int n, FloatBuffer floatBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n, doubleBuffer));
        floatBuffer.put((float)doubleBuffer.get(0));
        floatBuffer.put((float)doubleBuffer.get(1));
        floatBuffer.put((float)doubleBuffer.get(2));
        floatBuffer.put((float)doubleBuffer.get(3));
    }

    @Override
    public final synchronized void glGetClipPlanex(int n, int[] array, int n2) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n, doubleBuffer));
        array[n2] = (int)(doubleBuffer.get(0) * 65536.0);
        array[n2 + 1] = (int)(doubleBuffer.get(1) * 65536.0);
        array[n2 + 2] = (int)(doubleBuffer.get(2) * 65536.0);
        array[n2 + 3] = (int)(doubleBuffer.get(3) * 65536.0);
    }

    @Override
    public final synchronized void glGetClipPlanex(int n, IntBuffer intBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n, doubleBuffer));
        intBuffer.put((int)(doubleBuffer.get(0) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(1) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(2) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(3) * 65536.0));
    }

    @Override
    public final synchronized void glGetFixedv(int n, int[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n2 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetFixedv(int n, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetFloatv(int n, float[] array, int n2) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n2 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int method768 = GLConfiguration.method768(n);
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n, floatBuffer2));
        for (int i2 = 0; i2 < method768; ++i2) {
            floatBuffer.put(floatBuffer2.get(i2));
        }
    }

    @Override
    public final synchronized void glGetLightfv(int n, int n2, float[] array, int n3) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n3 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetLightfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetLightxv(int n, int n2, int[] array, int n3) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n3 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetLightxv(int n, int n2, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetMaterialfv(int n, int n2, float[] array, int n3) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n3 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetMaterialxv(int n, int n2, int[] array, int n3) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            array[n3 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetMaterialxv(int n, int n2, IntBuffer intBuffer) {
        int method768 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method768);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method768; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetPointerv(int n, Buffer[] array) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final synchronized void glGetTexEnvfv(int n, int n2, float[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n, n2, floatBuffer));
        floatBuffer.get(array, n3, method775);
    }

    @Override
    public final synchronized void glGetTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexEnviv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnviv(n, n2, intBuffer));
        intBuffer.get(array, n3, method775);
    }

    @Override
    public final synchronized void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnviv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glGetTexEnvxv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method775; ++i2) {
            array[n3 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method775; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetTexParameterfv(int n, int n2, float[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n, n2, floatBuffer));
        floatBuffer.get(array, n3, method775);
    }

    @Override
    public final synchronized void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexParameteriv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameteriv(n, n2, intBuffer));
        intBuffer.get(array, n3, method775);
    }

    @Override
    public final synchronized void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameteriv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glGetTexParameterxv(int n, int n2, int[] array, int n3) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method775; ++i2) {
            array[n3 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        int method775 = GLConfiguration.method775(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method775);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method775; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glDrawTexsOES(short n, short n2, short n3, short n4, short n5) {
        this.glDrawTexfOES(n, n2, n3, n4, n5);
    }

    @Override
    public final synchronized void glDrawTexiOES(int n, int n2, int n3, int n4, int n5) {
        this.glDrawTexfOES(n, n2, n3, n4, n5);
    }

    @Override
    public final synchronized void glDrawTexfOES(float n, float n2, float n3, float n4, float n5) {
        if (!GLConfiguration.OES_draw_texture) {
            throw new UnsupportedOperationException("OES_draw_texture extension not available");
        }
    }

    @Override
    public final synchronized void glDrawTexxOES(int n, int n2, int n3, int n4, int n5) {
        this.glDrawTexfOES((float)n / 65536.0f, (float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f, (float)n5 / 65536.0f);
    }

    @Override
    public final synchronized void glDrawTexsvOES(short[] array, int n) {
        this.glDrawTexfOES(array[n], array[n + 1], array[n + 2], array[n + 3], array[n + 4]);
    }

    @Override
    public final synchronized void glDrawTexsvOES(ShortBuffer shortBuffer) {
        short[] a2 = new short[5];
        shortBuffer.get(a2);
        this.glDrawTexsvOES(a2, 0);
    }

    @Override
    public final synchronized void glDrawTexivOES(int[] array, int n) {
        this.glDrawTexfOES(array[n], array[n + 1], array[n + 2], array[n + 3], array[n + 4]);
    }

    @Override
    public final synchronized void glDrawTexivOES(IntBuffer intBuffer) {
        int[] a2 = new int[5];
        intBuffer.get(a2);
        this.glDrawTexivOES(a2, 0);
    }

    @Override
    public final synchronized void glDrawTexxvOES(int[] array, int n) {
        this.glDrawTexfOES((float)array[n] / 65536.0f, (float)array[n + 1] / 65536.0f, (float)array[n + 2] / 65536.0f, (float)array[n + 3] / 65536.0f, (float)array[n + 4] / 65536.0f);
    }

    @Override
    public final synchronized void glDrawTexxvOES(IntBuffer intBuffer) {
        int[] a2 = new int[5];
        intBuffer.get(a2);
        this.glDrawTexxvOES(a2, 0);
    }

    @Override
    public final synchronized void glDrawTexfvOES(float[] array, int n) {
        this.glDrawTexfOES(array[n], array[n + 1], array[n + 2], array[n + 3], array[n + 4]);
    }

    @Override
    public final synchronized void glDrawTexfvOES(FloatBuffer floatBuffer) {
        float[] a2 = new float[5];
        floatBuffer.get(a2);
        this.glDrawTexfvOES(a2, 0);
    }

    @Override
    public final synchronized void glCurrentPaletteMatrixOES(int n) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        if (n >= 0 && n < this.paletteMatrices.length) {
            this.currentPaletteMatrix = n;
        }
    }

    @Override
    public final synchronized void glLoadPaletteFromModelViewMatrixOES() {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(2982, fb));
        fb.position(0);
        fb.get(this.paletteMatrices[this.currentPaletteMatrix]);
    }

    @Override
    public final synchronized void glMatrixIndexPointerOES(int n, int n2, int n3, Buffer buffer) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        this.oesMatrixIndexBuffer = buffer;
        this.oesMatrixIndexSize = n;
        this.oesMatrixIndexType = n2;
        this.oesMatrixIndexStride = n3;
        this.oesMatrixIndexIsOffset = false;
    }

    @Override
    public final synchronized void glMatrixIndexPointerOES(int n, int n2, int n3, int n4) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        this.oesMatrixIndexBuffer = null;
        this.oesMatrixIndexSize = n;
        this.oesMatrixIndexType = n2;
        this.oesMatrixIndexStride = n3;
        this.oesMatrixIndexOffset = n4;
        this.oesMatrixIndexIsOffset = true;
    }

    @Override
    public final synchronized void glWeightPointerOES(int n, int n2, int n3, Buffer buffer) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        this.oesWeightBuffer = buffer;
        this.oesWeightSize = n;
        this.oesWeightType = n2;
        this.oesWeightStride = n3;
        this.oesWeightIsOffset = false;
    }

    @Override
    public final synchronized void glWeightPointerOES(int n, int n2, int n3, int n4) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        this.oesWeightBuffer = null;
        this.oesWeightSize = n;
        this.oesWeightType = n2;
        this.oesWeightStride = n3;
        this.oesWeightOffset = n4;
        this.oesWeightIsOffset = true;
    }

    private static void checkTextureCubeMapExt() {
        if (!GLConfiguration.OES_texture_cube_map) {
            throw new UnsupportedOperationException("OES_texture_cube_map extension not available");
        }
    }

    @Override
    public final synchronized void glTexGenf(int n, int n2, float n3) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenf(n, n2, n3));
    }

    @Override
    public final synchronized void glTexGeni(int n, int n2, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glTexGeni(n, n2, n3));
    }

    @Override
    public final synchronized void glTexGenx(int n, int n2, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenf(n, n2, (float)n3 / 65536.0f));
    }

    @Override
    public final synchronized void glTexGenfv(int n, int n2, float[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        floatBuffer.put(array, n3, method771);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glTexGeniv(int n, int n2, int[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method771);
        intBuffer.put(array, n3, method771);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGeniv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glTexGeniv(int n, int n2, IntBuffer intBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glTexGeniv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glTexGenxv(int n, int n2, int[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        for (int i2 = 0; i2 < method771; ++i2) {
            floatBuffer.put((float)array[i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glTexGenxv(int n, int n2, IntBuffer intBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        for (int i2 = 0; i2 < method771; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexGenfv(int n, int n2, float[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n, n2, floatBuffer));
        floatBuffer.get(array, n3, method771);
    }

    @Override
    public final synchronized void glGetTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n, n2, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexGeniv(int n, int n2, int[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(method771);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGeniv(n, n2, intBuffer));
        intBuffer.get(array, n3, method771);
    }

    @Override
    public final synchronized void glGetTexGeniv(int n, int n2, IntBuffer intBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGeniv(n, n2, intBuffer));
    }

    @Override
    public final synchronized void glGetTexGenxv(int n, int n2, int[] array, int n3) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method771; ++i2) {
            array[i2 + n3] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexGenxv(int n, int n2, IntBuffer intBuffer) {
        GL11Impl.checkTextureCubeMapExt();
        int method771 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(method771);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n, n2, floatBuffer));
        for (int i2 = 0; i2 < method771; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glBlendEquation(int n) {
        if (!GLConfiguration.OES_blend_subtract) {
            throw new UnsupportedOperationException("OES_blend_subtract extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL14.glBlendEquation(n));
    }

    @Override
    public final synchronized void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        if (!GLConfiguration.OES_blend_func_separate) {
            throw new UnsupportedOperationException("OES_blend_func_separate extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL14.glBlendFuncSeparate(n, n2, n3, n4));
    }

    @Override
    public final synchronized void glBlendEquationSeparate(int n, int n2) {
        if (!GLConfiguration.OES_blend_equations_separate) {
            throw new UnsupportedOperationException("OES_blend_equations_separate extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL20.glBlendEquationSeparate(n, n2));
    }

    private void checkFramebufferExt() {
        if (!GLConfiguration.OES_framebuffer_object) {
            throw new UnsupportedOperationException("OES_framebuffer_object extension not available");
        }
    }

    @Override
    public final synchronized boolean glIsRenderbufferOES(int n) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glIsRenderbuffer(n);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glBindRenderbufferOES(int n, int n2) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glBindRenderbuffer(n, n2));
    }

    @Override
    public final synchronized void glDeleteRenderbuffersOES(int n, int[] array, int n2) {
        this.checkFramebufferExt();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        intBuffer.put(array, n2, n);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL30.glDeleteRenderbuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteRenderbuffersOES(int n, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        int l = intBuffer.limit();
        intBuffer.limit(n + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glDeleteRenderbuffers(intBuffer));
        intBuffer.limit(l);
    }

    @Override
    public final synchronized void glGenRenderbuffersOES(int n, int[] array, int n2) {
        this.checkFramebufferExt();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        EGL10Impl.g3d.sync(() -> GL30.glGenRenderbuffers(intBuffer));
        intBuffer.get(array, n2, n);
    }

    @Override
    public final synchronized void glGenRenderbuffersOES(int n, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        int l = intBuffer.limit();
        intBuffer.limit(n + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glGenRenderbuffers(intBuffer));
        intBuffer.limit(l);
    }

    @Override
    public final synchronized void glRenderbufferStorageOES(int n, int n2, int n3, int n4) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glRenderbufferStorage(n, n2, n3, n4));
    }

    @Override
    public final synchronized void glGetRenderbufferParameterivOES(int n, int n2, int[] array, int n3) {
        this.checkFramebufferExt();
        int length = 1;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(length);
        EGL10Impl.g3d.sync(() -> GL30.glGetRenderbufferParameteriv(n, n2, intBuffer));
        intBuffer.get(array, n, length);
    }

    @Override
    public final synchronized void glGetRenderbufferParameterivOES(int n, int n2, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glGetRenderbufferParameteriv(n, n2, intBuffer));
    }

    @Override
    public final synchronized boolean glIsFramebufferOES(int n) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glIsFramebuffer(n);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glBindFramebufferOES(int n, int n2) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glBindFramebuffer(n, n2));
    }

    @Override
    public final synchronized void glDeleteFramebuffersOES(int n, int[] array, int n2) {
        this.checkFramebufferExt();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        intBuffer.put(array, n2, n);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL30.glDeleteFramebuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteFramebuffersOES(int n, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        int l = intBuffer.limit();
        intBuffer.limit(n + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glDeleteFramebuffers(intBuffer));
        intBuffer.limit(l);
    }

    @Override
    public final synchronized void glGenFramebuffersOES(int n, int[] array, int n2) {
        this.checkFramebufferExt();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
        EGL10Impl.g3d.sync(() -> GL30.glGenFramebuffers(intBuffer));
        intBuffer.get(array, n2, n);
    }

    @Override
    public final synchronized void glGenFramebuffersOES(int n, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        int l = intBuffer.limit();
        intBuffer.limit(n + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glGenFramebuffers(intBuffer));
        intBuffer.limit(l);
    }

    @Override
    public final synchronized int glCheckFramebufferStatusOES(int n) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glCheckFramebufferStatus(n);
        });
        return (Integer)this.temp;
    }

    @Override
    public final synchronized void glFramebufferTexture2DOES(int n, int n2, int n3, int n4, int n5) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glFramebufferTexture2D(n, n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glFramebufferRenderbufferOES(int n, int n2, int n3, int n4) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glFramebufferRenderbuffer(n, n2, n3, n4));
    }

    @Override
    public final synchronized void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, int[] array, int n4) {
        this.checkFramebufferExt();
        int length = 1;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(length);
        EGL10Impl.g3d.sync(() -> GL30.glGetFramebufferAttachmentParameteriv(n, n2, n3, intBuffer));
        intBuffer.get(array, n, length);
    }

    @Override
    public final synchronized void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, IntBuffer intBuffer) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glGetFramebufferAttachmentParameteriv(n, n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glGenerateMipmapOES(int n) {
        this.checkFramebufferExt();
        EGL10Impl.g3d.sync(() -> GL30.glGenerateMipmap(n));
    }

    @Override
    public final synchronized void glPointSizePointerOES(int n, int n2, Buffer buffer) {
        System.out.println("OES is not implemented.");
    }

    @Override
    public final synchronized void glPointSizePointerOES(int n, int n2, int n3) {
        System.out.println("OES is not implemented.");
    }

    private static void readIndices(Buffer buf, int vertexIndex, int indexSize, int strideBytes, int type, int[] out) {
        block4: {
            block3: {
                if (buf == null) {
                    return;
                }
                if (type != 5121) break block3;
                ByteBuffer bb = (ByteBuffer)buf;
                int stride = strideBytes == 0 ? indexSize : strideBytes;
                int pos = vertexIndex * stride;
                for (int i2 = 0; i2 < indexSize; ++i2) {
                    out[i2] = bb.get(pos + i2) & 0xFF;
                }
                break block4;
            }
            if (type != 5123) break block4;
            ShortBuffer sb = (ShortBuffer)buf;
            int strideElems = strideBytes == 0 ? indexSize : strideBytes / 2;
            int pos = vertexIndex * strideElems;
            for (int i3 = 0; i3 < indexSize; ++i3) {
                out[i3] = sb.get(pos + i3) & 0xFFFF;
            }
        }
    }

    private static void readWeights(Buffer buf, int vertexIndex, int weightSize, int strideBytes, int type, float[] out) {
        if (buf == null) {
            return;
        }
        if (type == 5126) {
            FloatBuffer fb = (FloatBuffer)buf;
            int strideElems = strideBytes == 0 ? weightSize : strideBytes / 4;
            int pos = vertexIndex * strideElems;
            for (int i2 = 0; i2 < weightSize; ++i2) {
                out[i2] = fb.get(pos + i2);
            }
        }
    }

    private static void mulMat4Vec4(float[] m2, float[] v, float[] out) {
        for (int row = 0; row < 4; ++row) {
            out[row] = m2[row] * v[0] + m2[4 + row] * v[1] + m2[8 + row] * v[2] + m2[12 + row] * v[3];
        }
    }

    private static void mulMat3Vec3(float[] m2, float[] v, float[] out) {
        out[0] = m2[0] * v[0] + m2[4] * v[1] + m2[8] * v[2];
        out[1] = m2[1] * v[0] + m2[5] * v[1] + m2[9] * v[2];
        out[2] = m2[2] * v[0] + m2[6] * v[1] + m2[10] * v[2];
    }

    private static void normalizeVec3(float[] v) {
        float len = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        if (len != 0.0f) {
            v[0] = v[0] / len;
            v[1] = v[1] / len;
            v[2] = v[2] / len;
        }
    }

    private boolean trySoftwareSkinAndDrawArrays(int mode, int first, int count) {
        if (!(this.oesMatrixPaletteEnabled && this.oesMatrixIndexArrayEnabled && this.oesWeightArrayEnabled)) {
            return false;
        }
        if (this.vertexBuffer == null) {
            return false;
        }
        if (this.oesMatrixIndexIsOffset || this.oesWeightIsOffset || this.vertexIsOffset || this.normalArrayEnabled && this.normalIsOffset) {
            return false;
        }
        if (this.vertexType != 5126 || this.oesWeightType != 5126 || this.normalArrayEnabled && this.normalType != 5126) {
            return false;
        }
        if (this.oesMatrixIndexType != 5121 && this.oesMatrixIndexType != 5123) {
            return false;
        }
        int vSize = this.vertexSize;
        FloatBuffer srcV = this.vertexBuffer;
        FloatBuffer skinnedVerts = BufferUtils.createFloatBuffer(count * vSize);
        FloatBuffer srcN = this.normalArrayEnabled ? (FloatBuffer)this.normalBuffer : null;
        FloatBuffer skinnedNormals = this.normalArrayEnabled ? BufferUtils.createFloatBuffer(count * 3) : null;
        float[] origN = this.normalArrayEnabled ? new float[3] : null;
        float[] tmpN = this.normalArrayEnabled ? new float[3] : null;
        float[] accumN = this.normalArrayEnabled ? new float[3] : null;
        int[] indices = new int[this.oesMatrixIndexSize];
        float[] weights = new float[this.oesWeightSize];
        float[] origV = new float[4];
        float[] tmpV = new float[4];
        float[] accumV = new float[4];
        for (int vi = 0; vi < count; ++vi) {
            int a2;
            int vertIndex = first + vi;
            accumV[0] = 0.0f;
            accumV[1] = 0.0f;
            accumV[2] = 0.0f;
            accumV[3] = 0.0f;
            origV[0] = 0.0f;
            origV[1] = 0.0f;
            origV[2] = 0.0f;
            origV[3] = 1.0f;
            int floatsPerVertex = this.vertexStride == 0 ? vSize : this.vertexStride / 4;
            int vPos = vertIndex * floatsPerVertex;
            for (a2 = 0; a2 < vSize; ++a2) {
                origV[a2] = srcV.get(vPos + a2);
            }
            if (this.normalArrayEnabled) {
                accumN[0] = 0.0f;
                accumN[1] = 0.0f;
                accumN[2] = 0.0f;
                int floatsPerNormal = this.normalStride == 0 ? 3 : this.normalStride / 4;
                int nPos = vertIndex * floatsPerNormal;
                for (int a3 = 0; a3 < 3; ++a3) {
                    origN[a3] = srcN.get(nPos + a3);
                }
            }
            GL11Impl.readIndices(this.oesMatrixIndexBuffer, vertIndex, this.oesMatrixIndexSize, this.oesMatrixIndexStride, this.oesMatrixIndexType, indices);
            GL11Impl.readWeights(this.oesWeightBuffer, vertIndex, this.oesWeightSize, this.oesWeightStride, this.oesWeightType, weights);
            for (int k2 = 0; k2 < this.oesWeightSize; ++k2) {
                int mi = indices[k2];
                if (mi < 0 || mi >= this.paletteMatrices.length) continue;
                float[] matrix = this.paletteMatrices[mi];
                float w = weights[k2];
                GL11Impl.mulMat4Vec4(matrix, origV, tmpV);
                accumV[0] = accumV[0] + tmpV[0] * w;
                accumV[1] = accumV[1] + tmpV[1] * w;
                accumV[2] = accumV[2] + tmpV[2] * w;
                accumV[3] = accumV[3] + tmpV[3] * w;
                if (!this.normalArrayEnabled) continue;
                GL11Impl.mulMat3Vec3(matrix, origN, tmpN);
                accumN[0] = accumN[0] + tmpN[0] * w;
                accumN[1] = accumN[1] + tmpN[1] * w;
                accumN[2] = accumN[2] + tmpN[2] * w;
            }
            for (a2 = 0; a2 < vSize; ++a2) {
                skinnedVerts.put(accumV[a2]);
            }
            if (!this.normalArrayEnabled) continue;
            GL11Impl.normalizeVec3(accumN);
            skinnedNormals.put(accumN);
        }
        skinnedVerts.position(0);
        if (skinnedNormals != null) {
            skinnedNormals.position(0);
        }
        EGL10Impl.g3d.sync(() -> {
            GL11.glMatrixMode(5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glVertexPointer(this.vertexSize, 5126, 0, skinnedVerts);
            if (this.normalArrayEnabled) {
                GL11.glNormalPointer(5126, 0, skinnedNormals);
            }
            GL11.glDrawArrays(mode, 0, count);
            GL11.glMatrixMode(5888);
            GL11.glPopMatrix();
            if (this.vertexIsOffset) {
                GL11.glVertexPointer(this.vertexSize, this.vertexType, this.vertexStride, this.vertexOffset);
            } else if (this.vertexBuffer != null) {
                GL11.glVertexPointer(this.vertexSize, this.vertexType, this.vertexStride, this.vertexBuffer);
            }
            if (this.normalArrayEnabled) {
                GL11.glNormalPointer(this.normalType, this.normalStride, MemoryUtil.memAddress(this.normalBuffer));
            }
        });
        return true;
    }

    private boolean trySoftwareSkinAndDrawElements(int mode, int count, int type, Buffer indicesBuffer) {
        if (!(this.oesMatrixPaletteEnabled && this.oesMatrixIndexArrayEnabled && this.oesWeightArrayEnabled)) {
            return false;
        }
        if (this.vertexBuffer == null) {
            return false;
        }
        if (this.oesMatrixIndexIsOffset || this.oesWeightIsOffset || this.vertexIsOffset || this.normalArrayEnabled && this.normalIsOffset) {
            return false;
        }
        if (this.vertexType != 5126 || this.oesWeightType != 5126 || this.normalArrayEnabled && this.normalType != 5126) {
            return false;
        }
        if (this.oesMatrixIndexType != 5121 && this.oesMatrixIndexType != 5123) {
            return false;
        }
        if (type != 5121 && type != 5123) {
            return false;
        }
        int vSize = this.vertexSize;
        FloatBuffer srcV = this.vertexBuffer;
        FloatBuffer skinnedVerts = BufferUtils.createFloatBuffer(count * vSize);
        FloatBuffer srcN = this.normalArrayEnabled ? (FloatBuffer)this.normalBuffer : null;
        FloatBuffer skinnedNormals = this.normalArrayEnabled ? BufferUtils.createFloatBuffer(count * 3) : null;
        float[] origN = this.normalArrayEnabled ? new float[3] : null;
        float[] tmpN = this.normalArrayEnabled ? new float[3] : null;
        float[] accumN = this.normalArrayEnabled ? new float[3] : null;
        int[] indices = new int[this.oesMatrixIndexSize];
        float[] weights = new float[this.oesWeightSize];
        float[] origV = new float[4];
        float[] tmpV = new float[4];
        float[] accumV = new float[4];
        indicesBuffer.position(0);
        for (int ei = 0; ei < count; ++ei) {
            int a2;
            int vertexIndex = type == 5123 ? ((ShortBuffer)indicesBuffer).get(ei) & 0xFFFF : ((ByteBuffer)indicesBuffer).get(ei) & 0xFF;
            accumV[0] = 0.0f;
            accumV[1] = 0.0f;
            accumV[2] = 0.0f;
            accumV[3] = 0.0f;
            origV[0] = 0.0f;
            origV[1] = 0.0f;
            origV[2] = 0.0f;
            origV[3] = 1.0f;
            int floatsPerVertex = this.vertexStride == 0 ? vSize : this.vertexStride / 4;
            int vPos = vertexIndex * floatsPerVertex;
            for (a2 = 0; a2 < vSize; ++a2) {
                origV[a2] = srcV.get(vPos + a2);
            }
            if (this.normalArrayEnabled) {
                accumN[0] = 0.0f;
                accumN[1] = 0.0f;
                accumN[2] = 0.0f;
                int floatsPerNormal = this.normalStride == 0 ? 3 : this.normalStride / 4;
                int nPos = vertexIndex * floatsPerNormal;
                for (int a3 = 0; a3 < 3; ++a3) {
                    origN[a3] = srcN.get(nPos + a3);
                }
            }
            GL11Impl.readIndices(this.oesMatrixIndexBuffer, vertexIndex, this.oesMatrixIndexSize, this.oesMatrixIndexStride, this.oesMatrixIndexType, indices);
            GL11Impl.readWeights(this.oesWeightBuffer, vertexIndex, this.oesWeightSize, this.oesWeightStride, this.oesWeightType, weights);
            for (int k2 = 0; k2 < this.oesWeightSize; ++k2) {
                int mi = indices[k2];
                if (mi < 0 || mi >= this.paletteMatrices.length) continue;
                float[] matrix = this.paletteMatrices[mi];
                float w = weights[k2];
                GL11Impl.mulMat4Vec4(matrix, origV, tmpV);
                accumV[0] = accumV[0] + tmpV[0] * w;
                accumV[1] = accumV[1] + tmpV[1] * w;
                accumV[2] = accumV[2] + tmpV[2] * w;
                accumV[3] = accumV[3] + tmpV[3] * w;
                if (!this.normalArrayEnabled) continue;
                GL11Impl.mulMat3Vec3(matrix, origN, tmpN);
                accumN[0] = accumN[0] + tmpN[0] * w;
                accumN[1] = accumN[1] + tmpN[1] * w;
                accumN[2] = accumN[2] + tmpN[2] * w;
            }
            for (a2 = 0; a2 < vSize; ++a2) {
                skinnedVerts.put(accumV[a2]);
            }
            if (!this.normalArrayEnabled) continue;
            GL11Impl.normalizeVec3(accumN);
            skinnedNormals.put(accumN);
        }
        skinnedVerts.position(0);
        if (skinnedNormals != null) {
            skinnedNormals.position(0);
        }
        EGL10Impl.g3d.sync(() -> {
            GL11.glMatrixMode(5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glVertexPointer(this.vertexSize, 5126, 0, skinnedVerts);
            if (this.normalArrayEnabled) {
                GL11.glNormalPointer(5126, 0, skinnedNormals);
            }
            GL11.glDrawArrays(mode, 0, count);
            GL11.glMatrixMode(5888);
            GL11.glPopMatrix();
            if (this.vertexIsOffset) {
                GL11.glVertexPointer(this.vertexSize, this.vertexType, this.vertexStride, this.vertexOffset);
            } else if (this.vertexBuffer != null) {
                GL11.glVertexPointer(this.vertexSize, this.vertexType, this.vertexStride, this.vertexBuffer);
            }
            if (this.normalArrayEnabled) {
                GL11.glNormalPointer(this.normalType, this.normalStride, MemoryUtil.memAddress(this.normalBuffer));
            }
        });
        return true;
    }

    @Override
    public synchronized void glDrawArrays(int mode, int first, int count) {
        if (!this.trySoftwareSkinAndDrawArrays(mode, first, count)) {
            EGL10Impl.g3d.async(() -> GL11.glDrawArrays(mode, first, count));
        }
    }

    @Override
    public synchronized void glDrawElements(int mode, int count, int type, Buffer indices) {
        if (!this.trySoftwareSkinAndDrawElements(mode, count, type, indices)) {
            EGL10Impl.g3d.async(() -> GL11.glDrawElements(mode, count, type, MemoryUtil.memAddress(indices)));
        }
    }

    @Override
    public synchronized void glDrawElements(int mode, int count, int type, int indicesOffset) {
        EGL10Impl.g3d.async(() -> GL11.glDrawElements(mode, count, type, indicesOffset));
    }

    @Override
    public synchronized void glDisable(int n) {
        if (n == 34880) {
            this.oesMatrixPaletteEnabled = false;
            return;
        }
        if (n == 2896) {
            GL10Impl.aBoolean1355 = true;
        } else if (n == 2912) {
            GL10Impl.aBoolean1358 = true;
        }
        EGL10Impl.g3d.async(() -> GL11.glDisable(n));
    }

    @Override
    public synchronized void glDisableClientState(int n) {
        if (n == 34884) {
            this.oesMatrixIndexArrayEnabled = false;
            return;
        }
        if (n == 34477) {
            this.oesWeightArrayEnabled = false;
            return;
        }
        if (n == 32885) {
            this.normalArrayEnabled = false;
        }
        EGL10Impl.g3d.async(() -> GL11.glDisableClientState(n));
    }

    @Override
    public synchronized void glEnable(int n) {
        if (n == 34880) {
            this.oesMatrixPaletteEnabled = true;
            return;
        }
        if (n == 2896) {
            GL10Impl.aBoolean1355 = true;
        } else if (n == 2912) {
            GL10Impl.aBoolean1358 = true;
        }
        EGL10Impl.g3d.async(() -> GL11.glEnable(n));
    }

    @Override
    public synchronized void glEnableClientState(int n) {
        if (n == 34884) {
            this.oesMatrixIndexArrayEnabled = true;
            return;
        }
        if (n == 34477) {
            this.oesWeightArrayEnabled = true;
            return;
        }
        if (n == 32885) {
            this.normalArrayEnabled = true;
        }
        EGL10Impl.g3d.async(() -> GL11.glEnableClientState(n));
    }

    public GL11Impl(EGLContext eglContext) {
        super(eglContext);
    }
}

