/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.egl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class PaletteTextureDecoder {
    PaletteTextureDecoder() {
    }

    public static ByteBuffer decode(int format, ByteBuffer data, int width, int height) {
        int index;
        int i2;
        int bytesPerColor;
        int paletteSize;
        switch (format) {
            case 35728: {
                paletteSize = 16;
                bytesPerColor = 3;
                break;
            }
            case 35729: {
                paletteSize = 16;
                bytesPerColor = 4;
                break;
            }
            case 35730: 
            case 35731: 
            case 35732: {
                paletteSize = 16;
                bytesPerColor = 2;
                break;
            }
            case 35733: {
                paletteSize = 256;
                bytesPerColor = 3;
                break;
            }
            case 35734: {
                paletteSize = 256;
                bytesPerColor = 4;
                break;
            }
            case 35735: 
            case 35736: 
            case 35737: {
                paletteSize = 256;
                bytesPerColor = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported palette format: 0x" + Integer.toHexString(format));
            }
        }
        int paletteBytes = paletteSize * bytesPerColor;
        int[] palette = new int[paletteSize];
        ByteBuffer paletteBuffer = data.duplicate().order(data.order());
        paletteBuffer.limit(paletteBuffer.position() + paletteBytes);
        for (int i3 = 0; i3 < paletteSize; ++i3) {
            int b2;
            int g;
            int r;
            int color = 0;
            if (bytesPerColor == 2) {
                int a2;
                int b3;
                int g2;
                int r2;
                short colorShort = paletteBuffer.getShort();
                if (format == 35730 || format == 35735) {
                    r2 = colorShort >> 11 & 0x1F;
                    g2 = colorShort >> 5 & 0x3F;
                    b3 = colorShort & 0x1F;
                    r2 = r2 << 3 | r2 >> 2;
                    g2 = g2 << 2 | g2 >> 4;
                    b3 = b3 << 3 | b3 >> 2;
                    color = 0xFF000000 | r2 << 16 | g2 << 8 | b3;
                } else if (format == 35731 || format == 35736) {
                    r2 = colorShort >> 12 & 0xF;
                    g2 = colorShort >> 8 & 0xF;
                    b3 = colorShort >> 4 & 0xF;
                    a2 = colorShort & 0xF;
                    r2 = r2 << 4 | r2;
                    g2 = g2 << 4 | g2;
                    b3 = b3 << 4 | b3;
                    a2 = a2 << 4 | a2;
                    color = a2 << 24 | r2 << 16 | g2 << 8 | b3;
                } else if (format == 35732 || format == 35737) {
                    r2 = colorShort >> 11 & 0x1F;
                    g2 = colorShort >> 6 & 0x1F;
                    b3 = colorShort >> 1 & 0x1F;
                    a2 = (colorShort & 1) * 255;
                    r2 = r2 << 3 | r2 >> 2;
                    g2 = g2 << 3 | g2 >> 2;
                    b3 = b3 << 3 | b3 >> 2;
                    color = a2 << 24 | r2 << 16 | g2 << 8 | b3;
                }
            } else if (bytesPerColor == 3) {
                r = paletteBuffer.get() & 0xFF;
                g = paletteBuffer.get() & 0xFF;
                b2 = paletteBuffer.get() & 0xFF;
                color = 0xFF000000 | r << 16 | g << 8 | b2;
            } else if (bytesPerColor == 4) {
                r = paletteBuffer.get() & 0xFF;
                g = paletteBuffer.get() & 0xFF;
                b2 = paletteBuffer.get() & 0xFF;
                int a3 = paletteBuffer.get() & 0xFF;
                color = a3 << 24 | r << 16 | g << 8 | b2;
            }
            palette[i3] = color;
        }
        data.position(data.position() + paletteBytes);
        int indexCount = width * height;
        int bitsPerIndex = paletteSize == 16 ? 4 : 8;
        int indexBytes = (indexCount * bitsPerIndex + 7) / 8;
        if (data.remaining() < indexBytes) {
            throw new IllegalArgumentException("Data buffer too small");
        }
        ByteBuffer rgbaBuffer = ByteBuffer.allocateDirect(indexCount * 4).order(ByteOrder.nativeOrder());
        ByteBuffer indexBuffer = data.slice().order(data.order());
        indexBuffer.limit(indexBytes);
        if (bitsPerIndex == 4) {
            for (i2 = 0; i2 < indexCount; ++i2) {
                byte b4;
                if (i2 % 2 == 0) {
                    b4 = indexBuffer.get();
                    index = b4 >> 4 & 0xF;
                } else {
                    b4 = indexBuffer.get(indexBuffer.position() - 1);
                    index = b4 & 0xF;
                }
                int color = palette[index];
                rgbaBuffer.put((byte)(color >> 16 & 0xFF));
                rgbaBuffer.put((byte)(color >> 8 & 0xFF));
                rgbaBuffer.put((byte)(color & 0xFF));
                rgbaBuffer.put((byte)(color >> 24 & 0xFF));
            }
        } else {
            for (i2 = 0; i2 < indexCount; ++i2) {
                index = indexBuffer.get() & 0xFF;
                int color = palette[index];
                rgbaBuffer.put((byte)(color >> 16 & 0xFF));
                rgbaBuffer.put((byte)(color >> 8 & 0xFF));
                rgbaBuffer.put((byte)(color & 0xFF));
                rgbaBuffer.put((byte)(color >> 24 & 0xFF));
            }
        }
        data.position(data.position() + indexBytes);
        rgbaBuffer.flip();
        return rgbaBuffer;
    }
}

