/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.lwjgl;

import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.debug.Profiler3D;
import emulator.graphics2D.awt.Graphics2DAWT;
import emulator.graphics2D.swt.Graphics2DSWT;
import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.IGraphics3D;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.Vector4f;
import emulator.graphics3D.egl.GLConfiguration;
import emulator.graphics3D.lwjgl.GLCanvasUtil;
import emulator.graphics3D.lwjgl.LWJGLUtil;
import emulator.graphics3D.m3g.CameraCache;
import emulator.graphics3D.m3g.LightsCache;
import emulator.graphics3D.m3g.MeshMorph;
import emulator.graphics3D.m3g.RenderObject;
import emulator.graphics3D.m3g.RenderPipe;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.SWTFrontend;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.ARBColorBufferFloat;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLCapabilities;

public final class Emulator3D
implements IGraphics3D {
    private static Emulator3D instance;
    private final LWJGLUtil memoryBuffers;
    private final RenderPipe renderPipe;
    private Object target;
    private boolean depthBufferEnabled;
    private int hints;
    private static int targetWidth;
    private static int targetHeight;
    private static ByteBuffer buffer;
    private static BufferedImage awtBufferImage;
    private static ImageData swtBufferImage;
    public static final PaletteData swtPalleteData;
    private static final Hashtable properties;
    private float depthRangeNear;
    private float depthRangeFar;
    private int viewportX;
    private int viewportY;
    private int viewportWidth;
    private int viewportHeight;
    private static final Vector<Integer> usedGLTextures;
    private static final Vector<Integer> unusedGLTextures;
    public static final int MaxViewportWidth = 2048;
    public static final int MaxViewportHeight = 2048;
    public static final int MaxViewportDimension = 2048;
    public static final int NumTextureUnits = 10;
    public static final int MaxTextureDimension = 2048;
    public static final int MaxSpriteCropDimension = 1024;
    public static final int MaxLights = 8;
    public static final int MaxTransformsPerVertex = 4;
    private boolean exiting;
    private final Map<Integer, Image2D> texturesTable = new WeakHashMap<Integer, Image2D>();
    private boolean flipImage;
    private static Canvas glCanvas;
    private static GLCapabilities capabilities;
    private static long window;
    private boolean initialized;
    private boolean egl;
    private static boolean threadBound;
    private ExecutorService executorService;
    private Thread executorThread;

    private Emulator3D() {
        instance = this;
        properties.put("supportAntialiasing", Boolean.TRUE);
        properties.put("supportTrueColor", Boolean.TRUE);
        properties.put("supportDithering", Boolean.TRUE);
        properties.put("supportMipmapping", Boolean.TRUE);
        properties.put("supportPerspectiveCorrection", Boolean.TRUE);
        properties.put("supportLocalCameraLighting", Boolean.TRUE);
        properties.put("maxLights", new Integer(8));
        properties.put("maxViewportWidth", new Integer(2048));
        properties.put("maxViewportHeight", new Integer(2048));
        properties.put("maxViewportDimension", new Integer(Math.min(2048, 2048)));
        properties.put("maxTextureDimension", new Integer(2048));
        properties.put("maxSpriteCropDimension", new Integer(1024));
        properties.put("maxTransformsPerVertex", new Integer(4));
        properties.put("numTextureUnits", new Integer(10));
        properties.put("coreID", "@KEmulator LWJ-OpenGL-M3G @liang.wu");
        properties.put("version", "nnmod " + Emulator.version + (Emulator.revision.length() > 0 ? " (git: " + Emulator.revision + ")" : ""));
        this.memoryBuffers = new LWJGLUtil();
        this.renderPipe = new RenderPipe();
    }

    public static Emulator3D getInstance() {
        if (instance == null) {
            instance = new Emulator3D();
        }
        return instance;
    }

    public void start() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "KEmulator-M3G");
            t.setPriority(5);
            this.executorThread = t;
            return this.executorThread;
        });
    }

    @Override
    public void bindTarget(Object target) {
        this.bindTarget(target, false);
    }

    @Override
    public final synchronized void bindTarget(Object target, boolean forceWindow) {
        int h2;
        int w;
        if (this.exiting) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException("exiting");
        }
        this.egl = forceWindow;
        ++Profiler3D.bindTargetCallCount;
        if (target instanceof Graphics) {
            this.target = target;
            w = ((Graphics)this.target).getImage().getWidth();
            h2 = ((Graphics)this.target).getImage().getHeight();
        } else {
            if (!(target instanceof Image2D)) {
                throw new IllegalArgumentException();
            }
            this.target = target;
            w = ((Image2D)this.target).getWidth();
            h2 = ((Image2D)this.target).getHeight();
        }
        this.start();
        if (!threadBound || !Settings.m3gThread) {
            threadBound = true;
            this.sync(() -> {
                try {
                    this.bindM3GThread(w, h2, this.egl);
                }
                catch (Exception e2) {
                    throw new M3GException(e2);
                }
            });
        }
        try {
            if (targetWidth != w || targetHeight != h2) {
                if (glCanvas != null) {
                    glCanvas.getDisplay().asyncExec(() -> {
                        glCanvas.setSize(w, h2);
                        glCanvas.setVisible(false);
                    });
                } else {
                    this.async(() -> GLFW.glfwSetWindowSize(window, w, h2));
                }
                if (Settings.g2d == 1) {
                    awtBufferImage = new BufferedImage(w, h2, 4);
                } else {
                    swtBufferImage = new ImageData(w, h2, 32, swtPalleteData);
                }
                buffer = BufferUtils.createByteBuffer(w * h2 * 4);
                targetWidth = w;
                targetHeight = h2;
            }
            this.async(() -> {
                GL11.glEnable(3089);
                GL11.glEnable(2977);
                GL11.glPixelStorei(3317, 1);
                if (Settings.m3gFlushImmediately) {
                    this.swapBuffers();
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.target = null;
            throw new IllegalArgumentException();
        }
    }

    private void getCapabilities() {
        if (capabilities == null) {
            capabilities = GL.createCapabilities();
            GLConfiguration.OES_blend_subtract = Emulator3D.capabilities.OpenGL14;
            GLConfiguration.OES_blend_func_separate = Emulator3D.capabilities.OpenGL14;
            GLConfiguration.OES_blend_equations_separate = Emulator3D.capabilities.OpenGL20;
            GLConfiguration.OES_framebuffer_object = Emulator3D.capabilities.OpenGL30;
            return;
        }
        try {
            capabilities = GL.getCapabilities();
        }
        catch (Exception e2) {
            capabilities = GL.createCapabilities();
        }
    }

    @Override
    public synchronized void releaseTarget() {
        ++Profiler3D.releaseTargetCallCount;
        if (!this.egl) {
            this.sync(() -> {
                GL11.glFinish();
                if (!Settings.m3gFlushImmediately) {
                    this.swapBuffers();
                }
                while (!unusedGLTextures.isEmpty()) {
                    this.releaseTexture(unusedGLTextures.get(0));
                }
                if (this.exiting) {
                    while (!usedGLTextures.isEmpty()) {
                        this.releaseTexture(usedGLTextures.get(0));
                    }
                    return;
                }
            });
        }
        if (!Settings.m3gThread) {
            this.releaseContext();
        }
        this.target = null;
    }

    public static boolean useGL11() {
        return !Emulator3D.capabilities.OpenGL12;
    }

    private void releaseContext() {
        if (window != 0L) {
            GLFW.glfwMakeContextCurrent(0L);
            return;
        }
        try {
            GLCanvasUtil.releaseContext(glCanvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void swapBuffers() {
        this.swapBuffers(this.flipImage, 0, 0, targetWidth, targetHeight);
    }

    public final void swapBuffers(boolean flip, int x, int y, int width, int height) {
        this.sync(() -> {
            ++Profiler3D.LWJGL_buffersSwapCount;
            if (this.target != null) {
                if (this.target instanceof Image2D) {
                    Image2D var9 = (Image2D)this.target;
                    buffer.rewind();
                    GL11.glReadPixels(x, y, width, height, 6408, 5121, buffer);
                    byte[] var11 = new byte[width * height * 4];
                    int w = width << 2;
                    int off = var11.length - w;
                    for (int i2 = height; i2 > 0; --i2) {
                        buffer.get(var11, off, w);
                        off -= w;
                    }
                    if (var9.getFormat() == 100) {
                        var9.set(x, y, var9.getWidth(), var9.getHeight(), var11);
                    } else {
                        byte[] data = new byte[var9.getWidth() * var9.getHeight() * 3];
                        int var6 = var11.length - 1;
                        int var7 = data.length - 1;
                        while (var7 >= 0) {
                            int n = var7--;
                            int n2 = --var6;
                            data[n] = var11[n2];
                            int n3 = var7--;
                            int n4 = --var6;
                            data[n3] = var11[n4];
                            int n5 = var7--;
                            int n6 = --var6;
                            --var6;
                            data[n5] = var11[n6];
                        }
                        var9.set(x, y, var9.getWidth(), var9.getHeight(), data);
                    }
                } else if (Settings.g2d == 0) {
                    buffer.rewind();
                    GL11.glReadPixels(x, y, width, height, 6408, 5121, buffer);
                    for (int yy = 0; yy < height; ++yy) {
                        int yWrite = Emulator3D.swtBufferImage.height - 1 - yy;
                        int writePos = yWrite * Emulator3D.swtBufferImage.width * 4;
                        int readPos = yy * width * 4;
                        buffer.position(readPos);
                        buffer.get(Emulator3D.swtBufferImage.data, writePos, width * 4);
                    }
                    Image var12 = new Image(null, swtBufferImage);
                    ((Graphics2DSWT)((Graphics)this.target).getImpl()).gc().drawImage(var12, 0, 0, width, height, x, y, width, height);
                    var12.dispose();
                } else {
                    buffer.rewind();
                    GL11.glReadPixels(x, y, width, height, 6408, 5121, buffer);
                    int[] data = ((DataBufferInt)awtBufferImage.getRaster().getDataBuffer()).getData();
                    IntBuffer ib = buffer.asIntBuffer();
                    for (int yy = 0; yy < height; ++yy) {
                        int yWrite = yy;
                        if (!flip) {
                            yWrite = awtBufferImage.getHeight() - 1 - yWrite;
                        }
                        int writePos = yWrite * awtBufferImage.getWidth();
                        int readPos = yy * width;
                        ib.position(readPos);
                        ib.get(data, writePos, width);
                    }
                    ((Graphics2DAWT)((Graphics)this.target).getImpl()).g().drawImage(awtBufferImage, x, y, x + width, y + height, 0, 0, width, height, null);
                }
            }
        });
    }

    @Override
    public final void enableDepthBuffer(boolean enabled) {
        this.depthBufferEnabled = enabled;
    }

    @Override
    public final boolean isDepthBufferEnabled() {
        return this.depthBufferEnabled;
    }

    @Override
    public final void setHints(int hints) {
        this.hints = hints;
        if (this.target != null) {
            this.async(this::setHintsInternal);
        }
    }

    private void setHintsInternal() {
        boolean aa;
        boolean bl = aa = (this.hints & 2) != 0;
        if (Settings.m3gAA == 1) {
            aa = false;
        } else if (Settings.m3gAA == 2) {
            aa = true;
        }
        if (aa) {
            GL11.glEnable(2832);
            GL11.glEnable(2848);
            GL11.glEnable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glEnable(32925);
            }
        } else {
            GL11.glDisable(2832);
            GL11.glDisable(2848);
            GL11.glDisable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glDisable(32925);
            }
        }
        if ((this.hints & 4) != 0) {
            GL11.glEnable(3024);
        } else {
            GL11.glDisable(3024);
        }
    }

    @Override
    public final int getHints() {
        return this.hints;
    }

    @Override
    public final Hashtable getProperties() {
        return properties;
    }

    @Override
    public final void setDepthRange(float near, float far) {
        this.depthRangeNear = near;
        this.depthRangeFar = far;
    }

    private void setupDepth() {
        this.async(() -> GL11.glDepthRange(this.depthRangeNear, this.depthRangeFar));
    }

    @Override
    public final void setViewport(int x, int y, int w, int h2) {
        this.viewportX = x;
        this.viewportY = y;
        this.viewportWidth = w;
        this.viewportHeight = h2;
    }

    private void setupViewport() {
        this.async(() -> {
            GL11.glViewport(this.viewportX, targetHeight - this.viewportY - this.viewportHeight, this.viewportWidth, this.viewportHeight);
            GL11.glScissor(this.viewportX, targetHeight - this.viewportY - this.viewportHeight, this.viewportWidth, this.viewportHeight);
        });
    }

    @Override
    public final void clearBackgound(Object bgObj) {
        this.sync(() -> {
            Background bg = (Background)bgObj;
            this.setupViewport();
            this.setupDepth();
            GL11.glClearDepth(1.0);
            GL11.glDepthMask(true);
            GL11.glColorMask(true, true, true, true);
            int bgColor = bg != null && !Settings.xrayView ? bg.getColor() : 0;
            GL11.glClearColor(G3DUtils.getFloatColor(bgColor, 16), G3DUtils.getFloatColor(bgColor, 8), G3DUtils.getFloatColor(bgColor, 0), G3DUtils.getFloatColor(bgColor, 24));
            if (bg != null && !Settings.xrayView) {
                int colorClear = bg.isColorClearEnabled() ? 16384 : 0;
                int depthClear = this.depthBufferEnabled && bg.isDepthClearEnabled() ? 256 : 0;
                GL11.glClear(colorClear | depthClear);
                this.drawBackgroundImage(bg);
            } else {
                GL11.glClear(0x4000 | (this.depthBufferEnabled ? 256 : 0));
            }
            if (Settings.m3gFlushImmediately) {
                this.swapBuffers();
            }
        });
    }

    private void drawBackgroundImage(Background bg) {
        if (bg == null || bg.getImage() == null || bg.getCropWidth() <= 0 || bg.getCropHeight() <= 0) {
            return;
        }
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDepthFunc(519);
        GL11.glDepthMask(false);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int imgGlFormat = bg.getImage().getFormat() == 99 ? 6407 : 6408;
        int imgW = bg.getImage().getWidth();
        int imgH = bg.getImage().getHeight();
        float viewportW = this.viewportWidth;
        float viewportH = this.viewportHeight;
        float imgScaleX = viewportW / (float)bg.getCropWidth();
        float imgScaleY = viewportH / (float)bg.getCropHeight();
        float drawX = -viewportW * (float)bg.getCropX() / (float)bg.getCropWidth() - viewportW / 2.0f;
        float drawY = viewportH * (float)bg.getCropY() / (float)bg.getCropHeight() + viewportH / 2.0f;
        float offsetX = imgScaleX * (float)imgW;
        float offsetY = imgScaleY * (float)imgH;
        int repeatsX = 1;
        if (bg.getImageModeX() == 33) {
            float f2;
            drawX %= offsetX;
            if (f2 > 0.0f) {
                drawX -= offsetX;
            }
            repeatsX = (int)(2.5f + viewportW / offsetX);
            drawX -= (float)repeatsX / 2.0f * offsetX;
        }
        int repeatsY = 1;
        if (bg.getImageModeY() == 33) {
            drawY %= offsetY;
            repeatsY = (int)(2.5f + viewportH / offsetY);
            drawY += (float)repeatsY / 2.0f * offsetY;
        }
        GL11.glPixelStorei(3314, imgW);
        GL11.glPixelStorei(3315, 0);
        GL11.glPixelStorei(3316, 0);
        GL11.glPixelZoom(imgScaleX, -imgScaleY);
        ByteBuffer imgBuffer = this.memoryBuffers.getImageBuffer(bg.getImage().getImageData());
        for (int y = 0; y < repeatsY; ++y) {
            for (int x = 0; x < repeatsX; ++x) {
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, drawX + (float)x * offsetX, drawY - (float)y * offsetY, imgBuffer);
                GL11.glDrawPixels(imgW, imgH, imgGlFormat, 5121, imgBuffer);
            }
        }
        GL11.glPixelStorei(3314, 0);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
    }

    private void setupCamera() {
        if (CameraCache.camera != null) {
            Transform tmpMat = new Transform();
            CameraCache.camera.getProjection(tmpMat);
            tmpMat.transpose();
            GL11.glMatrixMode(5889);
            GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
            tmpMat.set(CameraCache.invCam);
            tmpMat.transpose();
            GL11.glMatrixMode(5888);
            GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
        }
    }

    private void setupLights(Vector lights, Vector lightMats, int scope) {
        for (int i2 = 0; i2 < 8; ++i2) {
            GL11.glDisable(16384 + i2);
        }
        if (!Emulator3D.useGL11() && Emulator3D.capabilities.GL_ARB_color_buffer_float) {
            ARBColorBufferFloat.glClampColorARB(35098, Settings.m3gDisableLightClamp ? 0 : 1);
        }
        int usedLights = 0;
        Transform tmpMat = new Transform();
        for (int i3 = 0; i3 < lights.size() && usedLights < 8; ++i3) {
            Light light = (Light)lights.get(i3);
            if (light == null || (light.getScope() & scope) == 0 || !this.renderPipe.isVisible(light)) continue;
            Transform lightMat = (Transform)lightMats.get(i3);
            if (lightMat != null) {
                tmpMat.set(lightMat);
            } else {
                tmpMat.setIdentity();
            }
            tmpMat.transpose();
            GL11.glPushMatrix();
            GL11.glMatrixMode(5888);
            GL11.glMultMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
            int lightId = 16384 + usedLights;
            ++usedLights;
            float[] lightColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            GL11.glLightfv(lightId, 4608, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightfv(lightId, 4609, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightfv(lightId, 4610, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightf(lightId, 4615, 1.0f);
            GL11.glLightf(lightId, 4616, 0.0f);
            GL11.glLightf(lightId, 4617, 0.0f);
            GL11.glLightf(lightId, 4614, 180.0f);
            GL11.glLightf(lightId, 4613, 0.0f);
            float[] tmpLightPos = light.getMode() == 129 ? LightsCache.POSITIVE_Z_AXIS : LightsCache.LOCAL_ORIGIN;
            GL11.glLightfv(lightId, 4611, this.memoryBuffers.getFloatBuffer(tmpLightPos));
            G3DUtils.fillFloatColor(lightColor, light.getColor());
            float lightIntensity = light.getIntensity();
            lightColor[0] = lightColor[0] * lightIntensity;
            lightColor[1] = lightColor[1] * lightIntensity;
            lightColor[2] = lightColor[2] * lightIntensity;
            lightColor[3] = 1.0f;
            int lightMode = light.getMode();
            if (lightMode == 128) {
                GL11.glLightfv(lightId, 4608, this.memoryBuffers.getFloatBuffer(lightColor));
            } else {
                GL11.glLightfv(lightId, 4609, this.memoryBuffers.getFloatBuffer(lightColor));
                GL11.glLightfv(lightId, 4610, this.memoryBuffers.getFloatBuffer(lightColor));
            }
            if (lightMode == 131) {
                GL11.glLightfv(lightId, 4612, this.memoryBuffers.getFloatBuffer(LightsCache.NEGATIVE_Z_AXIS));
                GL11.glLightf(lightId, 4614, light.getSpotAngle());
                GL11.glLightf(lightId, 4613, light.getSpotExponent());
            }
            if (lightMode == 131 || lightMode == 130) {
                GL11.glLightf(lightId, 4615, light.getConstantAttenuation());
                GL11.glLightf(lightId, 4616, light.getLinearAttenuation());
                GL11.glLightf(lightId, 4617, light.getQuadraticAttenuation());
            }
            GL11.glEnable(lightId);
            GL11.glPopMatrix();
        }
    }

    @Override
    public final void render(VertexBuffer vb, IndexBuffer ib, Appearance ap, Transform trans, int scope) {
        this.sync(() -> this.renderVertex(vb, ib, ap, trans, scope, 1.0f));
    }

    private void renderVertex(VertexBuffer vb, IndexBuffer ib, Appearance ap, Transform trans, int scope, float alphaFactor) {
        if ((CameraCache.camera.getScope() & scope) != 0) {
            this.setupViewport();
            this.setupDepth();
            this.setupCamera();
            this.setupLights(LightsCache.m_lights, LightsCache.m_lightsTransform, scope);
            if (trans != null) {
                Transform tmpMat = new Transform();
                tmpMat.set(trans);
                tmpMat.transpose();
                GL11.glMultMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
            }
            this.setupAppearance(ap, false);
            this.draw(vb, ib, ap, alphaFactor);
        }
    }

    private void setupAppearance(Appearance ap, boolean spriteMode) {
        if (!spriteMode) {
            Emulator3D.setupPolygonMode(ap.getPolygonMode());
        }
        this.setupCompositingMode(ap.getCompositingMode());
        if (!spriteMode) {
            this.setupMaterial(ap.getMaterial());
        }
        this.setupFog(ap.getFog());
    }

    private static void setupPolygonMode(PolygonMode pm) {
        if (pm == null) {
            pm = new PolygonMode();
        }
        GL11.glPolygonMode(1032, Settings.xrayView ? 6913 : 6914);
        int var1 = pm.getCulling();
        if (var1 == 162) {
            GL11.glDisable(2884);
        } else {
            GL11.glEnable(2884);
            GL11.glCullFace(var1 == 161 ? 1028 : 1029);
        }
        GL11.glShadeModel(pm.getShading() == 164 ? 7424 : 7425);
        GL11.glFrontFace(pm.getWinding() == 169 ? 2304 : 2305);
        GL11.glLightModelf(2898, pm.isTwoSidedLightingEnabled() ? 1.0f : 0.0f);
        GL11.glLightModelf(2897, pm.isLocalCameraLightingEnabled() ? 1.0f : 0.0f);
        boolean persCorrect = pm.isPerspectiveCorrectionEnabled();
        if (Settings.m3gForcePerspectiveCorrection) {
            persCorrect = true;
        }
        GL11.glHint(3152, persCorrect ? 4354 : 4353);
    }

    private void setupCompositingMode(CompositingMode cm) {
        if (cm == null) {
            cm = new CompositingMode();
        }
        if (this.depthBufferEnabled) {
            GL11.glEnable(2929);
        } else {
            GL11.glDisable(2929);
        }
        GL11.glDepthMask(cm.isDepthWriteEnabled());
        GL11.glDepthFunc(cm.isDepthTestEnabled() ? 515 : 519);
        GL11.glColorMask(cm.isColorWriteEnabled(), cm.isColorWriteEnabled(), cm.isColorWriteEnabled(), cm.isAlphaWriteEnabled());
        GL11.glAlphaFunc(518, cm.getAlphaThreshold());
        if (cm.getAlphaThreshold() == 0.0f) {
            GL11.glDisable(3008);
        } else {
            GL11.glEnable(3008);
        }
        if (cm.getBlending() == 68) {
            GL11.glDisable(3042);
        } else {
            GL11.glEnable(3042);
        }
        switch (cm.getBlending()) {
            case 64: {
                GL11.glBlendFunc(770, 771);
                break;
            }
            case 65: {
                GL11.glBlendFunc(770, 1);
                break;
            }
            case 66: {
                GL11.glBlendFunc(774, 0);
                break;
            }
            case 67: {
                GL11.glBlendFunc(774, 768);
                break;
            }
            case 68: {
                GL11.glBlendFunc(1, 0);
                break;
            }
        }
        GL11.glPolygonOffset(cm.getDepthOffsetFactor(), cm.getDepthOffsetUnits());
        if (cm.getDepthOffsetFactor() == 0.0f && cm.getDepthOffsetUnits() == 0.0f) {
            GL11.glDisable(Settings.xrayView ? 10754 : 32823);
        } else {
            GL11.glEnable(Settings.xrayView ? 10754 : 32823);
        }
    }

    private void setupMaterial(Material mat) {
        if (mat != null) {
            GL11.glEnable(2896);
            float[] tmpCol = new float[4];
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(1024));
            GL11.glMaterialfv(1032, 4608, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(2048));
            GL11.glMaterialfv(1032, 4609, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(4096));
            GL11.glMaterialfv(1032, 5632, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(8192));
            GL11.glMaterialfv(1032, 4610, this.memoryBuffers.getFloatBuffer(tmpCol));
            GL11.glMaterialf(1032, 5633, mat.getShininess());
            if (mat.isVertexColorTrackingEnabled()) {
                GL11.glEnable(2903);
                GL11.glColorMaterial(1032, 5634);
            } else {
                GL11.glDisable(2903);
            }
        } else {
            GL11.glDisable(2896);
            GL11.glDisable(2903);
        }
    }

    private void setupFog(Fog fog) {
        if (fog != null && !Settings.xrayView) {
            GL11.glEnable(2912);
            GL11.glFogi(2917, fog.getMode() == 81 ? 9729 : 2048);
            float[] fogColor = new float[4];
            G3DUtils.fillFloatColor(fogColor, fog.getColor());
            fogColor[3] = 1.0f;
            GL11.glFogfv(2918, this.memoryBuffers.getFloatBuffer(fogColor));
            GL11.glFogf(2915, fog.getNearDistance());
            GL11.glFogf(2916, fog.getFarDistance());
            GL11.glFogf(2914, fog.getDensity());
        } else {
            GL11.glDisable(2912);
        }
    }

    private void draw(VertexBuffer vb, IndexBuffer indices, Appearance ap, float alphaFactor) {
        int err;
        if (this.exiting) {
            return;
        }
        ++Profiler3D.LWJGL_drawCallCount;
        VertexArray colors = vb.getColors();
        if (colors == null) {
            int col = vb.getDefaultColor();
            GL11.glColor4ub((byte)(col >> 16 & 0xFF), (byte)(col >> 8 & 0xFF), (byte)(col & 0xFF), (byte)((float)(col >> 24 & 0xFF) * alphaFactor));
            GL11.glDisableClientState(32886);
        } else {
            GL11.glEnableClientState(32886);
            if (colors.getComponentType() == 1) {
                byte[] colorsBArr = colors.getByteValues();
                GL11.glColorPointer(alphaFactor == 1.0f ? colors.getComponentCount() : 4, 5121, 0, this.memoryBuffers.getColorBuffer(colorsBArr, alphaFactor, colors.getVertexCount()));
            }
        }
        VertexArray normals = vb.getNormals();
        if (normals != null && ap.getMaterial() != null) {
            GL11.glEnableClientState(32885);
            if (normals.getComponentType() == 1) {
                GL11.glNormalPointer(5120, 0, this.memoryBuffers.getNormalBuffer(normals.getByteValues()));
            } else {
                GL11.glNormalPointer(5122, 0, this.memoryBuffers.getNormalBuffer(normals.getShortValues()));
            }
        } else {
            GL11.glDisableClientState(32885);
        }
        float[] scaleBias = new float[4];
        VertexArray positions = vb.getPositions(scaleBias);
        GL11.glEnableClientState(32884);
        if (positions.getComponentType() == 1) {
            byte[] posesBArr = positions.getByteValues();
            GL11.glVertexPointer(positions.getComponentCount(), 5122, 0, this.memoryBuffers.getVertexBuffer(posesBArr));
        } else {
            short[] posesSArr = positions.getShortValues();
            GL11.glVertexPointer(positions.getComponentCount(), 5122, 0, this.memoryBuffers.getVertexBuffer(posesSArr));
        }
        GL11.glMatrixMode(5888);
        GL11.glTranslatef(scaleBias[1], scaleBias[2], scaleBias[3]);
        GL11.glScalef(scaleBias[0], scaleBias[0], scaleBias[0]);
        TriangleStripArray triangleStripArray = (TriangleStripArray)indices;
        int stripCount = triangleStripArray.getStripCount();
        if (ap != null && !Settings.xrayView) {
            int i2;
            for (i2 = 0; i2 < 10; ++i2) {
                int id;
                Texture2D texture2D = ap.getTexture(i2);
                scaleBias[3] = 0.0f;
                VertexArray texCoords = vb.getTexCoords(i2, scaleBias);
                if (texture2D == null || texCoords == null) continue;
                Image2D image2D = texture2D.getImage();
                if (!Emulator3D.useGL11()) {
                    GL13.glActiveTexture(33984 + i2);
                    GL13.glClientActiveTexture(33984 + i2);
                }
                if ((id = image2D.getId()) == 0) {
                    id = GL11.glGenTextures();
                    image2D.setId(id);
                    image2D.setLoaded(false);
                    if (!usedGLTextures.contains(id)) {
                        usedGLTextures.add(id);
                    }
                    this.texturesTable.put(id, image2D);
                }
                GL11.glEnable(3553);
                GL11.glBindTexture(3553, id);
                int blendMode = 0;
                switch (texture2D.getBlending()) {
                    case 224: {
                        blendMode = 260;
                        break;
                    }
                    case 225: {
                        blendMode = 3042;
                        break;
                    }
                    case 226: {
                        blendMode = 8449;
                        break;
                    }
                    case 227: {
                        blendMode = 8448;
                        break;
                    }
                    case 228: {
                        blendMode = 7681;
                        break;
                    }
                }
                GL11.glTexEnvi(8960, 8704, blendMode);
                float[] blendColor = new float[4];
                G3DUtils.fillFloatColor(blendColor, texture2D.getBlendColor());
                blendColor[3] = 1.0f;
                GL11.glTexEnvfv(8960, 8705, this.memoryBuffers.getFloatBuffer(blendColor));
                if (!image2D.isLoaded()) {
                    image2D.setLoaded(true);
                    ++Profiler3D.LWJGL_glTexImage2DCount;
                    int texFormat = 6407;
                    switch (image2D.getFormat()) {
                        case 96: {
                            texFormat = 6406;
                            break;
                        }
                        case 97: {
                            texFormat = 6409;
                            break;
                        }
                        case 98: {
                            texFormat = 6410;
                            break;
                        }
                        case 99: {
                            texFormat = 6407;
                            break;
                        }
                        case 100: {
                            texFormat = 6408;
                        }
                    }
                    if (!Emulator3D.useGL11() && Emulator3D.capabilities.OpenGL14) {
                        GL11.glTexParameteri(3553, 33169, 1);
                    }
                    GL11.glTexImage2D(3553, 0, texFormat, image2D.getWidth(), image2D.getHeight(), 0, texFormat, 5121, this.memoryBuffers.getImageBuffer(image2D.getImageData()));
                }
                GL11.glTexParameterf(3553, 10242, texture2D.getWrappingS() == 240 && !Emulator3D.useGL11() ? 33071.0f : 10497.0f);
                GL11.glTexParameterf(3553, 10243, texture2D.getWrappingT() == 240 && !Emulator3D.useGL11() ? 33071.0f : 10497.0f);
                int levelFilter = texture2D.getLevelFilter();
                int imageFilter = texture2D.getImageFilter();
                if (Emulator3D.useGL11() || Settings.m3gMipmapping == 1) {
                    levelFilter = 208;
                    if (!Emulator3D.useGL11()) {
                        GL11.glTexParameteri(3553, 34046, 1);
                    }
                } else if (Settings.m3gMipmapping == 2) {
                    levelFilter = 210;
                    GL11.glTexParameteri(3553, 34046, 1);
                } else if (Settings.m3gMipmapping == 3) {
                    levelFilter = 209;
                    GL11.glTexParameteri(3553, 34046, 1);
                } else if (Settings.m3gMipmapping >= 4) {
                    levelFilter = 209;
                    GL11.glTexParameteri(3553, 34046, 2 << Settings.m3gMipmapping - 4);
                }
                if (Settings.m3gTexFilter == 1) {
                    imageFilter = 210;
                } else if (Settings.m3gTexFilter == 2) {
                    imageFilter = 209;
                }
                int magFilter = 0;
                int minFilter = 0;
                if (imageFilter == 210) {
                    magFilter = 9728;
                    minFilter = 9728;
                    if (levelFilter == 210) {
                        minFilter = 9984;
                    } else if (levelFilter == 209) {
                        minFilter = 9986;
                    }
                } else if (imageFilter == 209) {
                    magFilter = 9729;
                    minFilter = 9729;
                    if (levelFilter == 210) {
                        minFilter = 9985;
                    } else if (levelFilter == 209) {
                        minFilter = 9987;
                    }
                }
                GL11.glTexParameteri(3553, 10241, minFilter);
                GL11.glTexParameteri(3553, 10240, magFilter);
                GL11.glEnableClientState(32888);
                ShortBuffer texCoordBuffer = texCoords.getComponentType() == 1 ? this.memoryBuffers.getTexCoordBuffer(texCoords.getByteValues(), i2) : this.memoryBuffers.getTexCoordBuffer(texCoords.getShortValues(), i2);
                GL11.glTexCoordPointer(texCoords.getComponentCount(), 5122, 0, texCoordBuffer);
                Transform tmpMat = new Transform();
                texture2D.getCompositeTransform(tmpMat);
                tmpMat.transpose();
                GL11.glMatrixMode(5890);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
                GL11.glTranslatef(scaleBias[1], scaleBias[2], scaleBias[3]);
                GL11.glScalef(scaleBias[0], scaleBias[0], scaleBias[0]);
            }
            Profiler3D.LWJGL_trianglesCount += triangleStripArray.profilerCount();
            GL11.glDrawElements(5, triangleStripArray.getBuffer());
            for (i2 = 0; i2 < 10; ++i2) {
                Image2D image2D;
                Texture2D tex = ap.getTexture(i2);
                if (tex == null || (image2D = tex.getImage()).getId() == 0) continue;
                if (!Emulator3D.useGL11()) {
                    GL13.glActiveTexture(33984 + i2);
                    GL13.glClientActiveTexture(33984 + i2);
                }
                GL11.glBindTexture(3553, 0);
            }
        } else {
            int l = triangleStripArray.getStripCount();
            for (int i3 = 0; i3 < l; ++i3) {
                GL11.glDrawElements(5, this.memoryBuffers.getElementsBuffer(triangleStripArray.getIndexStrip(i3)));
            }
        }
        if ((err = GL11.glGetError()) != 0) {
            Emulator.getEmulator().getLogStream().println("GL Error: " + err);
        }
    }

    @Override
    public synchronized void render(World world) {
        this.sync(() -> {
            Transform camTrans = new Transform();
            world.getActiveCamera().getTransformTo(world, camTrans);
            CameraCache.setCamera(world.getActiveCamera(), camTrans);
            this.clearBackgound(world.getBackground());
            LightsCache.addLightsFromWorld(world);
            this.renderPipe.pushRenderNode(world, null);
            this.renderPushedNodes();
        });
    }

    @Override
    public synchronized void render(Node node, Transform transform) {
        this.sync(() -> {
            this.renderPipe.pushRenderNode(node, transform);
            this.renderPushedNodes();
        });
    }

    private void renderPushedNodes() {
        this.renderPipe.sortNodes();
        for (int i2 = 0; i2 < this.renderPipe.getSize(); ++i2) {
            RenderObject ro = this.renderPipe.getRenderObj(i2);
            if (ro.node instanceof Mesh) {
                Mesh mesh = (Mesh)ro.node;
                IndexBuffer indices = mesh.getIndexBuffer(ro.submeshIndex);
                Appearance ap = mesh.getAppearance(ro.submeshIndex);
                if (indices == null || ap == null) continue;
                VertexBuffer vb = MeshMorph.getInstance().getMorphedVertexBuffer(mesh);
                this.renderVertex(vb, indices, ap, ro.trans, mesh.getScope(), ro.alphaFactor);
                continue;
            }
            this.renderSprite((Sprite3D)ro.node, ro.trans, ro.alphaFactor);
        }
        this.renderPipe.clear();
        MeshMorph.getInstance().clearCache();
        if (Settings.m3gFlushImmediately) {
            this.swapBuffers();
        }
    }

    private void renderSprite(Sprite3D sprite, Transform var2, float alphaFactor) {
        block19: {
            int var28;
            ByteBuffer var27;
            int[] var21;
            block26: {
                int var29;
                float var20;
                float var19;
                float var18;
                float var17;
                float var16;
                float var15;
                Transform var10;
                Transform var6;
                block25: {
                    float var10000;
                    block24: {
                        int[] var12;
                        block23: {
                            boolean var14;
                            block22: {
                                block21: {
                                    block20: {
                                        ++Profiler3D.LWJGL_renderSpriteCount;
                                        float[] var3 = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                                        float[] var4 = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
                                        float[] var5 = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
                                        var6 = new Transform(CameraCache.invCam);
                                        var6.postMultiply(var2);
                                        Transform3D impl = (Transform3D)var6.getImpl();
                                        impl.transform(var3);
                                        impl.transform(var4);
                                        impl.transform(var5);
                                        float[] var7 = new float[]{var3[0], var3[1], var3[2], var3[3]};
                                        Vector4f.mul(var3, 1.0f / var3[3]);
                                        Vector4f.mul(var4, 1.0f / var4[3]);
                                        Vector4f.mul(var5, 1.0f / var5[3]);
                                        Vector4f.sub(var4, var3);
                                        Vector4f.sub(var5, var3);
                                        float[] var8 = new float[]{Vector4f.length(var4), 0.0f, 0.0f, 0.0f};
                                        float[] var9 = new float[]{0.0f, Vector4f.length(var5), 0.0f, 0.0f};
                                        Vector4f.add(var8, var7);
                                        Vector4f.add(var9, var7);
                                        var10 = new Transform();
                                        CameraCache.camera.getProjection(var10);
                                        impl = (Transform3D)var10.getImpl();
                                        impl.transform(var7);
                                        impl.transform(var8);
                                        impl.transform(var9);
                                        if (!(var7[3] > 0.0f) || !(-var7[3] < var7[2]) || !(var7[2] <= var7[3])) break block19;
                                        Vector4f.mul(var7, 1.0f / var7[3]);
                                        Vector4f.mul(var8, 1.0f / var8[3]);
                                        Vector4f.mul(var9, 1.0f / var9[3]);
                                        Vector4f.sub(var8, var7);
                                        Vector4f.sub(var9, var7);
                                        boolean var11 = sprite.isScaled();
                                        var12 = new int[]{sprite.getCropX(), sprite.getCropY(), sprite.getCropWidth(), sprite.getCropHeight()};
                                        boolean var13 = var12[2] < 0;
                                        var14 = var12[3] < 0;
                                        var12[2] = Math.abs(var12[2]);
                                        var12[3] = Math.abs(var12[3]);
                                        var15 = 1.0f;
                                        var16 = 1.0f;
                                        var17 = (var13 ? var12[2] : -var12[2]) / 2;
                                        var18 = (var14 ? -var12[3] : var12[3]) / 2;
                                        if (!var11) {
                                            if (var13) {
                                                var15 = -1.0f;
                                            }
                                            if (var14) {
                                                var16 = -1.0f;
                                            }
                                            var19 = var12[2];
                                            var20 = var12[3];
                                        } else {
                                            var15 = Vector4f.length(var8) * (float)this.viewportWidth * 0.5f;
                                            var16 = Vector4f.length(var9) * (float)this.viewportHeight * 0.5f;
                                            var19 = var15;
                                            var20 = var16;
                                            var17 = -var15 / 2.0f;
                                            var18 = var16 / 2.0f;
                                            if (var13) {
                                                var17 += var15;
                                            }
                                            if (var14) {
                                                var18 -= var16;
                                            }
                                            var15 /= var13 ? -((float)var12[2]) : (float)var12[2];
                                            var16 /= var14 ? -((float)var12[3]) : (float)var12[3];
                                        }
                                        var21 = new int[4];
                                        if (!G3DUtils.intersectRectangle(var12[0], var12[1], var12[2], var12[3], 0, 0, sprite.getImage().getWidth(), sprite.getImage().getHeight(), var21)) break block19;
                                        if (var13) break block20;
                                        var10000 = var17 - var15 * (float)(var12[0] - var21[0]);
                                        break block21;
                                    }
                                    if (var12[0] <= 0) break block22;
                                    var10000 = var17 + var15 * (float)(var12[0] - var21[0]);
                                }
                                var17 = var10000;
                            }
                            if (var14) break block23;
                            var10000 = var18 + var16 * (float)(var12[1] - var21[1]);
                            break block24;
                        }
                        if (var12[1] <= 0) break block25;
                        var10000 = var18 - var16 * (float)(var12[1] - var21[1]);
                    }
                    var18 = var10000;
                }
                Transform var22 = new Transform();
                var22.postScale((float)this.viewportWidth / ((float)this.viewportWidth + var19), (float)this.viewportHeight / ((float)this.viewportHeight + var20), 1.0f);
                var22.postMultiply(var10);
                var10.set(var22);
                int var23 = (int)((float)this.viewportX - var19 / 2.0f);
                int var24 = (int)((float)this.viewportY - var20 / 2.0f);
                int var25 = (int)((float)this.viewportWidth + var19);
                int var26 = (int)((float)this.viewportHeight + var20);
                var10.transpose();
                var6.transpose();
                GL11.glViewport(var23, targetHeight - var24 - var26, var25, var26);
                GL11.glMatrixMode(5889);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)var10.getImpl()).m_matrix));
                GL11.glMatrixMode(5888);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)var6.getImpl()).m_matrix));
                GL11.glDisable(2896);
                var27 = this.memoryBuffers.getImageBuffer(sprite.getImage().getImageData());
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glPixelStorei(3314, sprite.getImage().getWidth());
                GL11.glPixelStorei(3315, var21[1]);
                GL11.glPixelStorei(3316, var21[0]);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, var17, var18, var27);
                GL11.glPixelZoom(var15, -var16);
                var28 = 6407;
                switch (sprite.getImage().getFormat()) {
                    case 96: {
                        var29 = 6406;
                        break;
                    }
                    case 97: {
                        var29 = 6409;
                        break;
                    }
                    case 98: {
                        var29 = 6410;
                        break;
                    }
                    case 99: {
                        var29 = 6407;
                        break;
                    }
                    case 100: {
                        var29 = 6408;
                        break;
                    }
                    default: {
                        break block26;
                    }
                }
                var28 = var29;
            }
            this.setupAppearance(sprite.getAppearance(), true);
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)(255.0f * alphaFactor));
            GL11.glDisableClientState(32886);
            GL11.glDrawPixels(var21[2], var21[3], var28, 5121, var27);
            GL11.glPixelStorei(3314, 0);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
        }
    }

    public final void v3bind(Graphics var1) {
    }

    public final void v3release(Graphics var1) {
    }

    public final void v3flush() {
    }

    public void finalizeTexture(Image2D image2D) {
        if (usedGLTextures.contains(image2D.getId())) {
            usedGLTextures.removeElement(image2D.getId());
        }
        if (!unusedGLTextures.contains(image2D.getId())) {
            unusedGLTextures.add(image2D.getId());
        }
        image2D.setId(0);
    }

    public void releaseTextures() {
        while (!usedGLTextures.isEmpty()) {
            this.releaseTexture(usedGLTextures.get(0));
        }
        while (!unusedGLTextures.isEmpty()) {
            this.releaseTexture(unusedGLTextures.get(0));
        }
    }

    public static void exit() {
        if (instance == null) {
            return;
        }
        instance.dispose();
    }

    private void disposeGlCanvas() {
        if (glCanvas == null) {
            return;
        }
        glCanvas.getDisplay().syncExec(() -> {
            glCanvas.dispose();
            glCanvas = null;
        });
    }

    private void dispose() {
        this.exiting = true;
        if (this.initialized && Settings.m3gThread) {
            this.sync(() -> {
                this.releaseTextures();
                this.releaseContext();
            });
        }
        this.disposeGlCanvas();
        if (window != 0L) {
            GLFW.glfwDestroyWindow(window);
        }
    }

    public void invalidateTexture(Image2D image2D) {
        image2D.setLoaded(false);
    }

    private void releaseTexture(int id) {
        Image2D img;
        GL11.glDeleteTextures(id);
        usedGLTextures.removeElement(id);
        unusedGLTextures.removeElement(id);
        if (this.texturesTable.containsKey(id) && (img = this.texturesTable.get(id)) != null) {
            img.setId(0);
        }
        this.texturesTable.remove(id);
    }

    public void setFlipImage(boolean b2) {
        this.flipImage = b2;
    }

    private void bindM3GThread(int w, int h2, boolean forceWindow) throws Exception {
        if (!this.initialized) {
            block18: {
                int mode;
                if (glCanvas != null) {
                    this.disposeGlCanvas();
                }
                if (window != 0L) {
                    GLFW.glfwDestroyWindow(window);
                    window = 0L;
                }
                if (this.exiting) {
                    return;
                }
                int n = mode = Settings.m3gContextMode == 0 && (Utils.win || Utils.termux) ? 2 : Settings.m3gContextMode;
                if (!forceWindow && Settings.m3gContextMode != 3 && Emulator.getEmulator() instanceof SWTFrontend) {
                    try {
                        SWTFrontend.syncExec(() -> {
                            try {
                                Composite parent = ((EmulatorScreen)Emulator.getEmulator().getScreen()).getCanvas();
                                glCanvas = GLCanvasUtil.initGLCanvas(parent, 0, mode);
                                glCanvas.setSize(1, 1);
                                glCanvas.setVisible(true);
                            }
                            catch (Throwable e2) {
                                e2.printStackTrace();
                                glCanvas = null;
                            }
                        });
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        glCanvas = null;
                    }
                }
                if (glCanvas != null) {
                    try {
                        GLCanvasUtil.makeCurrent(glCanvas);
                        this.getCapabilities();
                        glCanvas.getDisplay().syncExec(() -> glCanvas.addControlListener(new ControlListener(){

                            public void controlMoved(ControlEvent controlEvent) {
                            }

                            public void controlResized(ControlEvent controlEvent) {
                                if (targetWidth == 0 || targetHeight == 0 || glCanvas == null) {
                                    return;
                                }
                                glCanvas.setSize(targetWidth, targetHeight);
                                glCanvas.setVisible(false);
                            }
                        }));
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        if (glCanvas == null) break block18;
                        this.disposeGlCanvas();
                        glCanvas = null;
                    }
                }
            }
            if (glCanvas == null) {
                if (window == 0L) {
                    Emulator.getEmulator().getLogStream().println("Creating invisible glfw window");
                    if (!GLFW.glfwInit()) {
                        throw new Exception("glfwInit");
                    }
                    GLFWErrorCallback.createPrint(System.err).set();
                    GLFW.glfwDefaultWindowHints();
                    GLFW.glfwWindowHint(131076, 0);
                    GLFW.glfwWindowHint(131075, 1);
                    window = GLFW.glfwCreateWindow(w, h2, "M3G", 0L, 0L);
                    if (window == 0L) {
                        throw new Exception("Window creation failed (GLFW Error: " + GLFW.glfwGetError(null) + ")");
                    }
                }
                GLFW.glfwMakeContextCurrent(window);
                int error = GLFW.glfwGetError(null);
                if (error != 0) {
                    Emulator.getEmulator().getLogStream().println("GLFW Error: " + error);
                }
                this.getCapabilities();
            }
            Emulator.getEmulator().getLogStream().println("GL Renderer: " + GL11.glGetString(7937) + " (" + GL11.glGetString(7936) + ")");
            this.initialized = true;
        } else {
            if (window != 0L) {
                GLFW.glfwMakeContextCurrent(window);
            } else {
                GLCanvasUtil.makeCurrent(glCanvas);
            }
            this.getCapabilities();
        }
    }

    public void sync(Runnable r) throws M3GException {
        if (Thread.currentThread() == this.executorThread || !Settings.m3gThread) {
            try {
                r.run();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new M3GException(e3);
            }
            return;
        }
        try {
            this.executorService.submit(r).get();
        }
        catch (InterruptedException e4) {
            throw new RuntimeException(e4);
        }
        catch (ExecutionException e5) {
            Throwable cause = e5.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new M3GException(cause);
        }
    }

    public void async(Runnable r) {
        if (Thread.currentThread() == this.executorThread || !Settings.m3gThread) {
            r.run();
            return;
        }
        this.executorService.execute(r);
    }

    static {
        swtPalleteData = new PaletteData(-16777216, 0xFF0000, 65280);
        properties = new Hashtable();
        usedGLTextures = new Vector();
        unusedGLTextures = new Vector();
    }

    public static class M3GException
    extends RuntimeException {
        public M3GException(Throwable cause) {
            super(cause);
        }
    }
}

