/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.lwjgl;

import emulator.Emulator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.opengl.swt.GLCanvas;

public class GLCanvasUtil {
    private static Object platformCanvas;
    private static Method makeCurrentMethod;
    private static Method isCurrentMethod;
    private static Method swapBuffersMethod;

    public static Canvas initGLCanvas(Composite parent, int style, int type) throws Exception {
        int samples;
        Object gld;
        Object c2 = null;
        if (type != 2) {
            try {
                Emulator.getEmulator().getLogStream().println("Initializing GLCanvas from swt");
                gld = new GLData();
                gld.depthSize = Math.min(24, Emulator.getEmulator().getScreenDepth());
                samples = 4;
                while (true) {
                    try {
                        gld.samples = samples;
                        c2 = new org.eclipse.swt.opengl.GLCanvas(parent, style, gld);
                    }
                    catch (Exception e2) {
                        if ((samples >>= 1) != 0) continue;
                        gld.samples = samples;
                        c2 = new org.eclipse.swt.opengl.GLCanvas(parent, style, gld);
                    }
                    break;
                }
            }
            catch (Exception e3) {
                if (type == 1) {
                    throw e3;
                }
                e3.printStackTrace();
            }
        }
        if (c2 == null) {
            Emulator.getEmulator().getLogStream().println("Initializing GLCanvas from lwjglx");
            gld = new org.lwjgl.opengl.swt.GLData();
            gld.depthSize = Math.min(24, Emulator.getEmulator().getScreenDepth());
            gld.doubleBuffer = true;
            samples = 4;
            while (true) {
                try {
                    gld.samples = samples;
                    c2 = new GLCanvas(parent, style, (org.lwjgl.opengl.swt.GLData)gld);
                }
                catch (Exception e4) {
                    if ((samples >>= 1) != 0) continue;
                    gld.samples = samples;
                    c2 = new GLCanvas(parent, style, (org.lwjgl.opengl.swt.GLData)gld);
                }
                break;
            }
            GLCanvasUtil.releaseContext((Canvas)c2);
        }
        return c2;
    }

    public static void makeCurrent(Canvas canvas) throws Exception {
        if (canvas instanceof org.eclipse.swt.opengl.GLCanvas) {
            ((org.eclipse.swt.opengl.GLCanvas)canvas).setCurrent();
        } else if (canvas instanceof GLCanvas) {
            if (platformCanvas == null) {
                Field p = GLCanvas.class.getDeclaredField("platformCanvas");
                p.setAccessible(true);
                platformCanvas = p.get(null);
            }
            if (makeCurrentMethod == null) {
                makeCurrentMethod = Class.forName("org.lwjgl.opengl.swt.PlatformGLCanvas").getDeclaredMethod("makeCurrent", GLCanvas.class, Long.TYPE);
                makeCurrentMethod.setAccessible(true);
            }
            makeCurrentMethod.invoke(platformCanvas, canvas, GLCanvasUtil.getContext(canvas));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isCurrent(Canvas canvas) {
        if (canvas instanceof org.eclipse.swt.opengl.GLCanvas) {
            return ((org.eclipse.swt.opengl.GLCanvas)canvas).isCurrent();
        }
        try {
            if (isCurrentMethod == null) {
                isCurrentMethod = Class.forName("org.lwjgl.opengl.swt.PlatformGLCanvas").getDeclaredMethod("isCurrent", Long.TYPE);
                isCurrentMethod.setAccessible(true);
            }
            return (Boolean)makeCurrentMethod.invoke(platformCanvas, GLCanvasUtil.getContext(canvas));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    private static long getContext(Canvas canvas) {
        try {
            Field ctx = canvas instanceof org.eclipse.swt.opengl.GLCanvas ? org.eclipse.swt.opengl.GLCanvas.class.getDeclaredField("context") : GLCanvas.class.getDeclaredField("context");
            ctx.setAccessible(true);
            long context = ctx.getType().equals(Long.TYPE) ? ctx.getLong(canvas) : (long)ctx.getInt(canvas);
            return context;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static void swapBuffers(Canvas canvas) {
        if (canvas instanceof org.eclipse.swt.opengl.GLCanvas) {
            ((org.eclipse.swt.opengl.GLCanvas)canvas).swapBuffers();
            return;
        }
        try {
            if (swapBuffersMethod == null) {
                swapBuffersMethod = Class.forName("org.lwjgl.opengl.swt.PlatformGLCanvas").getDeclaredMethod("swapBuffers", GLCanvas.class);
                swapBuffersMethod.setAccessible(true);
            }
            if (platformCanvas == null) {
                Field p = GLCanvas.class.getDeclaredField("platformCanvas");
                p.setAccessible(true);
                platformCanvas = p.get(null);
            }
            swapBuffersMethod.invoke(platformCanvas, canvas);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public static void releaseContext(Canvas canvas) throws Exception {
        if (canvas instanceof org.eclipse.swt.opengl.GLCanvas) {
            long context;
            Field ctx = org.eclipse.swt.opengl.GLCanvas.class.getDeclaredField("context");
            ctx.setAccessible(true);
            if (ctx.getType().equals(Long.TYPE)) {
                context = ctx.getLong(canvas);
                ctx.set(canvas, 0L);
            } else {
                context = ctx.getInt(canvas);
                ctx.set(canvas, 0);
            }
            ((org.eclipse.swt.opengl.GLCanvas)canvas).setCurrent();
            if (ctx.getType().equals(Long.TYPE)) {
                ctx.set(canvas, context);
            } else {
                ctx.set(canvas, (int)context);
            }
        } else if (canvas instanceof GLCanvas) {
            if (platformCanvas == null) {
                Field p = GLCanvas.class.getDeclaredField("platformCanvas");
                p.setAccessible(true);
                platformCanvas = p.get(null);
            }
            if (makeCurrentMethod == null) {
                makeCurrentMethod = Class.forName("org.lwjgl.opengl.swt.PlatformGLCanvas").getDeclaredMethod("makeCurrent", GLCanvas.class, Long.TYPE);
                makeCurrentMethod.setAccessible(true);
            }
            makeCurrentMethod.invoke(platformCanvas, canvas, 0);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

