/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.lwjgl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;

public final class LWJGLUtil {
    private ByteBuffer normalByteBuffer;
    private ShortBuffer normalShortBuffer;
    private ByteBuffer colorBuffer;
    private ShortBuffer vertexShortBuffer;
    private ShortBuffer[] texCoordsBuffer = new ShortBuffer[10];
    private IntBuffer elementsBuffer;
    private ByteBuffer imageBuffer;
    private FloatBuffer floatBuffer;

    public LWJGLUtil() {
        int initVerticesCount = 4096;
        this.normalByteBuffer = BufferUtils.createByteBuffer(12288);
        this.normalShortBuffer = BufferUtils.createShortBuffer(12288);
        this.colorBuffer = BufferUtils.createByteBuffer(16384);
        this.vertexShortBuffer = BufferUtils.createShortBuffer(12288);
        for (int slot = 0; slot < 10; ++slot) {
            this.texCoordsBuffer[slot] = BufferUtils.createShortBuffer(8192);
        }
        int initPolyCount = 1024;
        this.elementsBuffer = BufferUtils.createIntBuffer(3072);
        int initTextureSize = 512;
        this.imageBuffer = BufferUtils.createByteBuffer(0x100000);
        this.floatBuffer = BufferUtils.createFloatBuffer(16);
    }

    public ByteBuffer getNormalBuffer(byte[] var0) {
        if (this.normalByteBuffer == null || this.normalByteBuffer.capacity() < var0.length) {
            this.normalByteBuffer = BufferUtils.createByteBuffer(var0.length * 4 / 3);
        }
        this.normalByteBuffer.position(this.normalByteBuffer.capacity() - var0.length);
        this.normalByteBuffer.put(var0);
        this.normalByteBuffer.position(this.normalByteBuffer.capacity() - var0.length);
        return this.normalByteBuffer;
    }

    public ShortBuffer getNormalBuffer(short[] var0) {
        if (this.normalShortBuffer == null || this.normalShortBuffer.capacity() < var0.length) {
            this.normalShortBuffer = BufferUtils.createShortBuffer(var0.length * 4 / 3);
        }
        this.normalShortBuffer.position(this.normalShortBuffer.capacity() - var0.length);
        for (short i2 : var0) {
            this.normalShortBuffer.put(i2);
        }
        this.normalShortBuffer.position(this.normalShortBuffer.capacity() - var0.length);
        return this.normalShortBuffer;
    }

    public ByteBuffer getImageBuffer(byte[] var0) {
        if (this.imageBuffer == null || this.imageBuffer.capacity() < var0.length) {
            this.imageBuffer = BufferUtils.createByteBuffer(var0.length * 4 / 3);
        }
        this.imageBuffer.position(this.imageBuffer.capacity() - var0.length);
        this.imageBuffer.put(var0);
        this.imageBuffer.position(this.imageBuffer.capacity() - var0.length);
        return this.imageBuffer;
    }

    public ShortBuffer getVertexBuffer(byte[] var0) {
        if (this.vertexShortBuffer == null || this.vertexShortBuffer.capacity() < var0.length) {
            this.vertexShortBuffer = BufferUtils.createShortBuffer(var0.length * 4 / 3);
        }
        this.vertexShortBuffer.position(this.vertexShortBuffer.capacity() - var0.length);
        int var1 = 0;
        int var2 = var0.length;
        while (var1 < var2) {
            this.vertexShortBuffer.put(var0[var1++]);
        }
        this.vertexShortBuffer.position(this.vertexShortBuffer.capacity() - var0.length);
        return this.vertexShortBuffer;
    }

    public ShortBuffer getVertexBuffer(short[] var0) {
        if (this.vertexShortBuffer == null || this.vertexShortBuffer.capacity() < var0.length) {
            this.vertexShortBuffer = BufferUtils.createShortBuffer(var0.length * 4 / 3);
        }
        this.vertexShortBuffer.position(this.vertexShortBuffer.capacity() - var0.length);
        this.vertexShortBuffer.put(var0);
        this.vertexShortBuffer.position(this.vertexShortBuffer.capacity() - var0.length);
        return this.vertexShortBuffer;
    }

    public ByteBuffer getColorBuffer(byte[] var0, float var1, int var2) {
        int var3;
        int n = var3 = var1 == 1.0f ? var0.length : 4 * var2;
        if (this.colorBuffer == null || this.colorBuffer.capacity() < var3) {
            this.colorBuffer = BufferUtils.createByteBuffer(var3 * 4 / 3);
        }
        this.colorBuffer.position(this.colorBuffer.capacity() - var3);
        if (var1 == 1.0f) {
            this.colorBuffer.put(var0);
        } else if (var0.length == var3) {
            int var4 = 0;
            while (var4 < var3) {
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put((byte)((float)(var0[var4++] & 0xFF) * var1 + 0.5f));
            }
        } else {
            int var4 = 0;
            while (var4 < var0.length) {
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put(var0[var4++]);
                this.colorBuffer.put((byte)(255.0f * var1 + 0.5f));
            }
        }
        this.colorBuffer.position(this.colorBuffer.capacity() - var3);
        return this.colorBuffer;
    }

    public IntBuffer getElementsBuffer(int[] var0) {
        if (this.elementsBuffer == null || this.elementsBuffer.capacity() < var0.length) {
            this.elementsBuffer = BufferUtils.createIntBuffer(var0.length * 4 / 3);
        }
        this.elementsBuffer.position(this.elementsBuffer.capacity() - var0.length);
        this.elementsBuffer.put(var0);
        this.elementsBuffer.position(this.elementsBuffer.capacity() - var0.length);
        return this.elementsBuffer;
    }

    public ShortBuffer getTexCoordBuffer(short[] var0, int idx) {
        if (this.texCoordsBuffer[idx] == null || this.texCoordsBuffer[idx].capacity() < var0.length) {
            this.texCoordsBuffer[idx] = BufferUtils.createShortBuffer(var0.length * 4 / 3);
        }
        ShortBuffer buf = this.texCoordsBuffer[idx];
        buf.position(buf.capacity() - var0.length);
        int var1 = 0;
        int var2 = var0.length;
        while (var1 < var2) {
            buf.put(var0[var1++]);
        }
        buf.position(buf.capacity() - var0.length);
        return buf;
    }

    public ShortBuffer getTexCoordBuffer(byte[] var0, int idx) {
        if (this.texCoordsBuffer[idx] == null || this.texCoordsBuffer[idx].capacity() < var0.length) {
            this.texCoordsBuffer[idx] = BufferUtils.createShortBuffer(var0.length * 4 / 3);
        }
        ShortBuffer buf = this.texCoordsBuffer[idx];
        buf.position(buf.capacity() - var0.length);
        int var1 = 0;
        int var2 = var0.length;
        while (var1 < var2) {
            buf.put(var0[var1++]);
        }
        buf.position(buf.capacity() - var0.length);
        return buf;
    }

    public FloatBuffer getFloatBuffer(float[] var0) {
        if (this.floatBuffer == null || this.floatBuffer.capacity() < var0.length) {
            this.floatBuffer = BufferUtils.createFloatBuffer(var0.length * 4 / 3);
        }
        this.floatBuffer.position(this.floatBuffer.capacity() - var0.length);
        this.floatBuffer.put(var0);
        this.floatBuffer.position(this.floatBuffer.capacity() - var0.length);
        return this.floatBuffer;
    }
}

