/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.m3g.BoneTransform;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.MorphingMesh;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public final class MeshMorph {
    private static MeshMorph inst;
    private static MeshMorph viewInst;
    private Hashtable cacheTable = new Hashtable();
    public VertexBuffer morphed;
    private VertexArray[] tmpMorphTargets;
    private VertexArray positions;
    private VertexArray normals;
    private VertexArray colors;
    private VertexArray[] uvms;
    private float[] tmpPositions;
    private float[] tmpNormals;
    private float[] tmp = new float[4];
    private float[] tmpScaleBias = new float[4];
    private float[] maxPos = new float[3];
    private float[] minPos = new float[3];

    public static MeshMorph getInstance() {
        if (inst == null) {
            inst = new MeshMorph();
        }
        return inst;
    }

    public static MeshMorph getViewInstance() {
        if (viewInst == null) {
            viewInst = new MeshMorph();
        }
        return viewInst;
    }

    public final void clearCache() {
        this.cacheTable.clear();
    }

    public final VertexBuffer getMorphedVertexBuffer(Mesh mesh) {
        VertexBuffer cacheVB = (VertexBuffer)this.cacheTable.get(mesh);
        if (cacheVB != null) {
            this.morphed = cacheVB;
        } else {
            if (mesh instanceof MorphingMesh) {
                this.processMorph((MorphingMesh)mesh);
                this.cacheTable.put(mesh, this.morphed);
                return this.morphed;
            }
            if (mesh instanceof SkinnedMesh) {
                this.processSkinning((SkinnedMesh)mesh);
                this.cacheTable.put(mesh, this.morphed);
                return this.morphed;
            }
            this.morphed = mesh.getVertexBuffer();
        }
        return this.morphed;
    }

    private void processMorph(MorphingMesh mesh) {
        int i2;
        int i3;
        int nullTargets;
        VertexBuffer meshVB = mesh.getVertexBuffer();
        this.setMorphVB(meshVB);
        int morphTargets = mesh.getMorphTargetCount();
        this.tmpMorphTargets = new VertexArray[morphTargets];
        float baseWeight = mesh.getBaseWeight();
        float[] weights = new float[morphTargets];
        mesh.getWeights(weights);
        if (this.positions != null) {
            nullTargets = 0;
            for (i3 = 0; i3 < morphTargets; ++i3) {
                this.tmpMorphTargets[i3] = mesh.getMorphTarget(i3).getPositions(null);
                if (this.tmpMorphTargets[i3] != null) continue;
                ++nullTargets;
            }
            if (nullTargets != morphTargets && nullTargets != 0) {
                throw new IllegalStateException();
            }
            if (nullTargets == 0) {
                this.positions.morph(this.tmpMorphTargets, meshVB.getPositions(null), weights, baseWeight);
            }
        } else {
            for (i2 = 0; i2 < morphTargets; ++i2) {
                if (mesh.getMorphTarget(i2).getPositions(null) == null) continue;
                throw new IllegalStateException();
            }
        }
        if (this.normals != null) {
            nullTargets = 0;
            for (i3 = 0; i3 < morphTargets; ++i3) {
                this.tmpMorphTargets[i3] = mesh.getMorphTarget(i3).getNormals();
                if (this.tmpMorphTargets[i3] != null) continue;
                ++nullTargets;
            }
            if (nullTargets != morphTargets && nullTargets != 0) {
                throw new IllegalStateException();
            }
            if (nullTargets == 0) {
                this.normals.morph(this.tmpMorphTargets, meshVB.getNormals(), weights, baseWeight);
            }
        } else {
            for (i2 = 0; i2 < morphTargets; ++i2) {
                if (mesh.getMorphTarget(i2).getNormals() == null) continue;
                throw new IllegalStateException();
            }
        }
        if (this.colors != null) {
            nullTargets = 0;
            for (i3 = 0; i3 < morphTargets; ++i3) {
                this.tmpMorphTargets[i3] = mesh.getMorphTarget(i3).getColors();
                if (this.tmpMorphTargets[i3] != null) continue;
                ++nullTargets;
            }
            if (nullTargets != morphTargets && nullTargets != 0) {
                throw new IllegalStateException();
            }
            if (nullTargets == 0) {
                this.colors.morphColors(this.tmpMorphTargets, meshVB.getColors(), weights, baseWeight);
            }
        } else {
            for (i2 = 0; i2 < morphTargets; ++i2) {
                if (mesh.getMorphTarget(i2).getColors() == null) continue;
                throw new IllegalStateException();
            }
            int defaultCol = meshVB.getDefaultColor();
            float a2 = baseWeight * (float)(defaultCol >> 24 & 0xFF);
            float r = baseWeight * (float)(defaultCol >> 16 & 0xFF);
            float g = baseWeight * (float)(defaultCol >> 8 & 0xFF);
            float b2 = baseWeight * (float)(defaultCol & 0xFF);
            for (int i4 = 0; i4 < morphTargets; ++i4) {
                int col = mesh.getMorphTarget(i4).getDefaultColor();
                a2 += weights[i4] * (float)(col >> 24 & 0xFF);
                r += weights[i4] * (float)(col >> 16 & 0xFF);
                g += weights[i4] * (float)(col >> 8 & 0xFF);
                b2 += weights[i4] * (float)(col & 0xFF);
            }
            defaultCol = G3DUtils.limit(G3DUtils.round(a2), 0, 255) << 24 | G3DUtils.limit(G3DUtils.round(r), 0, 255) << 16 | G3DUtils.limit(G3DUtils.round(g), 0, 255) << 8 | G3DUtils.limit(G3DUtils.round(b2), 0, 255) << 0;
            this.morphed.setDefaultColor(defaultCol);
        }
        for (i2 = 0; i2 < this.uvms.length; ++i2) {
            if (this.uvms[i2] == null) {
                for (int t = 0; t < morphTargets; ++t) {
                    if (mesh.getMorphTarget(t).getTexCoords(i2, null) == null) continue;
                    throw new IllegalStateException();
                }
                continue;
            }
            int nullTargets2 = 0;
            for (int t = 0; t < morphTargets; ++t) {
                this.tmpMorphTargets[t] = mesh.getMorphTarget(t).getTexCoords(i2, null);
                if (this.tmpMorphTargets[t] != null) continue;
                ++nullTargets2;
            }
            if (nullTargets2 != morphTargets && nullTargets2 != 0) {
                throw new IllegalStateException();
            }
            if (nullTargets2 != 0) continue;
            this.uvms[i2].morph(this.tmpMorphTargets, meshVB.getTexCoords(i2, null), weights, baseWeight);
        }
    }

    private void setMorphVB(VertexBuffer vb) {
        this.morphed = (VertexBuffer)vb.duplicate();
        if (vb.getPositions(null) != null) {
            this.positions = (VertexArray)vb.getPositions(this.tmpScaleBias).duplicate();
            this.tmp[0] = this.tmpScaleBias[1];
            this.tmp[1] = this.tmpScaleBias[2];
            this.tmp[2] = this.tmpScaleBias[3];
            this.morphed.setPositions(this.positions, this.tmpScaleBias[0], this.tmp);
        } else {
            this.positions = null;
        }
        if (vb.getNormals() != null) {
            this.normals = (VertexArray)vb.getNormals().duplicate();
            this.morphed.setNormals(this.normals);
        } else {
            this.normals = null;
        }
        if (vb.getColors() != null) {
            this.colors = (VertexArray)vb.getColors().duplicate();
            this.morphed.setColors(this.colors);
        } else {
            this.colors = null;
        }
        this.uvms = new VertexArray[10];
        for (int i2 = 0; i2 < this.uvms.length; ++i2) {
            if (vb.getTexCoords(i2, null) != null) {
                this.uvms[i2] = (VertexArray)vb.getTexCoords(i2, this.tmpScaleBias).duplicate();
                this.tmp[0] = this.tmpScaleBias[1];
                this.tmp[1] = this.tmpScaleBias[2];
                this.tmp[2] = this.tmpScaleBias[3];
                this.morphed.setTexCoords(i2, this.uvms[i2], this.tmpScaleBias[0], this.tmp);
                continue;
            }
            this.uvms[i2] = null;
        }
    }

    private void setSkinVB(VertexBuffer vb) {
        this.morphed = (VertexBuffer)vb.duplicate();
        int vertexCount = vb.getPositions(null).getVertexCount();
        if (this.positions == null || this.positions.getVertexCount() != vertexCount) {
            this.positions = new VertexArray(vertexCount, 3, 2);
        }
        this.morphed.setPositions(this.positions, 1.0f, null);
        if (this.tmpPositions == null || this.tmpPositions.length < vertexCount * 3) {
            this.tmpPositions = new float[vertexCount * 3];
        }
        if (vb.getNormals() != null) {
            vertexCount = vb.getNormals().getVertexCount();
            if (this.normals == null || this.normals.getVertexCount() != vertexCount) {
                this.normals = new VertexArray(vertexCount, 3, 2);
            }
            this.morphed.setNormals(this.normals);
            if (this.tmpNormals == null || this.tmpNormals.length < vertexCount * 3) {
                this.tmpNormals = new float[vertexCount * 3];
            }
        }
    }

    private void processSkinning(SkinnedMesh mesh) {
        VertexBuffer meshVB = mesh.getVertexBuffer();
        this.setSkinVB(meshVB);
        VertexArray meshPoses = meshVB.getPositions(this.tmpScaleBias);
        if (meshPoses == null) {
            throw new IllegalStateException();
        }
        VertexArray meshNorms = meshVB.getNormals();
        int vertexCount = meshVB.getVertexCount();
        Vector boneTransList = mesh.getTransforms();
        for (int i2 = 0; i2 < boneTransList.size(); ++i2) {
            BoneTransform weight = (BoneTransform)boneTransList.elementAt(i2);
            if (!weight.bone.getTransformTo(mesh, weight.posTrans)) {
                throw new IllegalStateException();
            }
            weight.posTrans.postMultiply(weight.toBoneTrans);
            if (meshNorms == null) continue;
            weight.normTrans.set(weight.posTrans);
            ((Transform3D)weight.normTrans.getImpl()).invert();
            weight.normTrans.transpose();
        }
        int[] vtxBones = mesh.getVerticesBones();
        int[] vtxWeights = mesh.getVerticesWeights();
        short[] shortPoses = meshPoses.getShortValues();
        byte[] bytePoses = meshPoses.getByteValues();
        short[] shortNorms = meshNorms == null ? null : meshNorms.getShortValues();
        byte[] byteNorms = meshNorms == null ? null : meshNorms.getByteValues();
        short[] normsOut = meshNorms == null ? null : this.normals.getShortValues();
        this.maxPos[2] = -3.4028235E38f;
        this.maxPos[1] = -3.4028235E38f;
        this.maxPos[0] = -3.4028235E38f;
        this.minPos[2] = Float.MAX_VALUE;
        this.minPos[1] = Float.MAX_VALUE;
        this.minPos[0] = Float.MAX_VALUE;
        for (int i3 = 0; i3 < vertexCount; ++i3) {
            int boneTransId;
            this.tmpPositions[i3 * 3 + 2] = 0.0f;
            this.tmpPositions[i3 * 3 + 1] = 0.0f;
            this.tmpPositions[i3 * 3] = 0.0f;
            if (meshNorms != null) {
                this.tmpNormals[i3 * 3 + 2] = 0.0f;
                this.tmpNormals[i3 * 3 + 1] = 0.0f;
                this.tmpNormals[i3 * 3] = 0.0f;
            }
            float weightSumm = 0.0f;
            for (int slot = 0; slot < 4 && (boneTransId = vtxBones[i3 * 4 + slot]) != 0; ++slot) {
                int axis;
                BoneTransform boneTrans = (BoneTransform)boneTransList.elementAt(boneTransId - 1);
                int boneWeight = vtxWeights[i3 * 4 + slot];
                weightSumm += (float)boneWeight;
                for (axis = 0; axis < 3; ++axis) {
                    this.tmp[axis] = meshPoses.getComponentType() == 2 ? (float)shortPoses[i3 * 3 + axis] : (float)bytePoses[i3 * 3 + axis];
                }
                this.tmp[0] = this.tmp[0] * this.tmpScaleBias[0] + this.tmpScaleBias[1];
                this.tmp[1] = this.tmp[1] * this.tmpScaleBias[0] + this.tmpScaleBias[2];
                this.tmp[2] = this.tmp[2] * this.tmpScaleBias[0] + this.tmpScaleBias[3];
                this.tmp[3] = 1.0f;
                boneTrans.posTrans.transform(this.tmp);
                int n = i3 * 3 + 0;
                this.tmpPositions[n] = this.tmpPositions[n] + this.tmp[0] * (float)boneWeight;
                int n2 = i3 * 3 + 1;
                this.tmpPositions[n2] = this.tmpPositions[n2] + this.tmp[1] * (float)boneWeight;
                int n3 = i3 * 3 + 2;
                this.tmpPositions[n3] = this.tmpPositions[n3] + this.tmp[2] * (float)boneWeight;
                if (meshNorms == null) continue;
                for (axis = 0; axis < 3; ++axis) {
                    this.tmp[axis] = meshNorms.getComponentType() == 2 ? (float)(shortNorms[i3 * 3 + axis] + 32768) / 65535.0f - 0.5f : (float)(byteNorms[i3 * 3 + axis] + 128) / 255.0f - 0.5f;
                }
                this.tmp[3] = 0.0f;
                boneTrans.normTrans.transform(this.tmp);
                int n4 = i3 * 3 + 0;
                this.tmpNormals[n4] = this.tmpNormals[n4] + this.tmp[0] * (float)boneWeight;
                int n5 = i3 * 3 + 1;
                this.tmpNormals[n5] = this.tmpNormals[n5] + this.tmp[1] * (float)boneWeight;
                int n6 = i3 * 3 + 2;
                this.tmpNormals[n6] = this.tmpNormals[n6] + this.tmp[2] * (float)boneWeight;
            }
            for (int axis = 0; axis < 3; ++axis) {
                float posVal;
                if (weightSumm != 0.0f) {
                    posVal = this.tmpPositions[i3 * 3 + axis];
                    posVal /= weightSumm;
                } else {
                    posVal = meshPoses.getComponentType() == 2 ? (float)shortPoses[i3 * 3 + axis] : (float)bytePoses[i3 * 3 + axis];
                    posVal = posVal * this.tmpScaleBias[0] + this.tmpScaleBias[axis + 1];
                }
                this.tmpPositions[i3 * 3 + axis] = posVal;
                if (posVal > this.maxPos[axis]) {
                    this.maxPos[axis] = posVal;
                }
                if (posVal < this.minPos[axis]) {
                    this.minPos[axis] = posVal;
                }
                if (meshNorms == null) continue;
                float normVal = weightSumm != 0.0f ? this.tmpNormals[i3 * 3 + axis] / weightSumm : (meshNorms.getComponentType() == 2 ? (float)(shortNorms[i3 * 3 + axis] + 32768) / 65535.0f - 0.5f : (float)(byteNorms[i3 * 3 + axis] + 128) / 255.0f - 0.5f);
                normsOut[i3 * 3 + axis] = (short)G3DUtils.round((normVal + 0.5f) * 65535.0f - 32768.0f);
            }
        }
        float maxAxisSize = 0.0f;
        for (int axis = 0; axis < 3; ++axis) {
            this.tmp[axis] = (this.minPos[axis] + this.maxPos[axis]) / 2.0f;
            float tmpScale = (this.maxPos[axis] - this.minPos[axis]) / 2.0f;
            if (!(maxAxisSize < tmpScale)) continue;
            maxAxisSize = tmpScale;
        }
        float scale = maxAxisSize != 0.0f ? maxAxisSize / 32767.0f : 1.0f;
        short[] posesOut = this.positions.getShortValues();
        for (int i4 = 0; i4 < vertexCount; ++i4) {
            posesOut[i4 * 3 + 0] = (short)G3DUtils.round((this.tmpPositions[i4 * 3 + 0] - this.tmp[0]) / scale);
            posesOut[i4 * 3 + 1] = (short)G3DUtils.round((this.tmpPositions[i4 * 3 + 1] - this.tmp[1]) / scale);
            posesOut[i4 * 3 + 2] = (short)G3DUtils.round((this.tmpPositions[i4 * 3 + 2] - this.tmp[2]) / scale);
        }
        this.morphed.setPositions(this.positions, scale, this.tmp);
        if (meshNorms != null) {
            this.morphed.setNormals(this.normals);
        }
    }
}

