/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.m3g;

import emulator.graphics3D.m3g.RenderPipe;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;

public final class RenderObject {
    public Node node;
    public Transform trans;
    public int submeshIndex;
    public int sortKey;
    public float alphaFactor;

    public RenderObject(Node node, Transform trans, int submeshIndex, RenderPipe renderPipe) {
        this.node = node;
        this.trans = new Transform(trans);
        this.submeshIndex = submeshIndex;
        this.sortKey = node instanceof Sprite3D ? this.getSortKey(((Sprite3D)node).getAppearance()) : this.getSortKey(((Mesh)node).getAppearance(submeshIndex));
        this.alphaFactor = renderPipe.getEffectiveAlphaFactor(node);
    }

    private int getSortKey(Appearance ap) {
        int sortKey = ap.getLayer() * 2;
        if (ap.getCompositingMode() != null && ap.getCompositingMode().getBlending() != 68) {
            ++sortKey;
        }
        return sortKey;
    }
}

