/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.m3g;

import emulator.graphics3D.m3g.RenderObject;
import java.util.Comparator;
import java.util.Vector;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;

public final class RenderPipe {
    private Node parentNode;
    private Vector<RenderObject> roList = new Vector();
    private boolean renderInvisibleNodes;

    public final int getSize() {
        return this.roList.size();
    }

    public final void clear() {
        this.roList.clear();
        this.parentNode = null;
    }

    public final RenderObject getRenderObj(int index) {
        return this.roList.get(index);
    }

    public final boolean isVisible(Node node) {
        for (Node tmpNode = node; tmpNode != null; tmpNode = tmpNode.getParent()) {
            if (!tmpNode.isRenderingEnabled() && !this.renderInvisibleNodes) {
                return false;
            }
            if (this.parentNode == null || tmpNode == this.parentNode) break;
        }
        return true;
    }

    public final float getEffectiveAlphaFactor(Node node) {
        float alphaFactor = 1.0f;
        Node tmpNode = node;
        while (true) {
            alphaFactor *= tmpNode.getAlphaFactor();
            if (tmpNode.getParent() == null || node == this.parentNode) {
                return alphaFactor;
            }
            tmpNode = tmpNode.getParent();
        }
    }

    public final void pushRenderNode(Node node, Transform trans) {
        this.parentNode = node;
        this.pushRenderNodeImpl(node, trans);
    }

    private void pushRenderNodeImpl(Node node, Transform trans) {
        if (this.isVisible(node)) {
            if (trans == null) {
                trans = new Transform();
            }
            if (node instanceof Sprite3D) {
                Sprite3D spr = (Sprite3D)node;
                if (spr.getAppearance() != null && spr.getCropWidth() != 0 && spr.getCropHeight() != 0) {
                    this.roList.add(new RenderObject(node, trans, 0, this));
                }
            } else if (node instanceof Mesh) {
                int submeshes = ((Mesh)node).getSubmeshCount();
                for (int i2 = 0; i2 < submeshes; ++i2) {
                    if (((Mesh)node).getAppearance(i2) == null) continue;
                    this.roList.add(new RenderObject(node, trans, i2, this));
                }
                if (node instanceof SkinnedMesh) {
                    Group skeleton = ((SkinnedMesh)node).getSkeleton();
                    Transform skeletonMat = new Transform();
                    skeleton.getCompositeTransform(skeletonMat);
                    Transform tmpMat = new Transform(trans);
                    tmpMat.postMultiply(skeletonMat);
                    this.pushRenderNodeImpl(skeleton, tmpMat);
                }
            } else if (node instanceof Group) {
                Group group = (Group)node;
                Transform childTrans = new Transform();
                Transform groupTrans = new Transform(trans);
                for (int i3 = 0; i3 < group.getChildCount(); ++i3) {
                    Node child = group.getChild(i3);
                    child.getCompositeTransform(childTrans);
                    childTrans.preMultiply(groupTrans);
                    this.pushRenderNodeImpl(child, childTrans);
                }
            }
        }
    }

    public void sortNodes() {
        this.roList.sort(Comparator.comparingInt(renderObject -> renderObject.sortKey));
    }

    public void setRenderInvisibleNodes(boolean render) {
        this.renderInvisibleNodes = render;
    }

    public boolean isRenderInvisibleNodes() {
        return this.renderInvisibleNodes;
    }
}

