/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.view;

import emulator.Emulator;
import emulator.Settings;
import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.Vector4f;
import emulator.graphics3D.lwjgl.Emulator3D;
import emulator.graphics3D.lwjgl.GLCanvasUtil;
import emulator.graphics3D.lwjgl.LWJGLUtil;
import emulator.graphics3D.m3g.LightsCache;
import emulator.graphics3D.m3g.MeshMorph;
import emulator.graphics3D.m3g.RenderObject;
import emulator.graphics3D.m3g.RenderPipe;
import emulator.ui.swt.SWTFrontend;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.ARBColorBufferFloat;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLCapabilities;

public final class M3GView3D
implements PaintListener,
Runnable {
    private static M3GView3D instance;
    private LWJGLUtil memoryBuffers;
    private RenderPipe renderPipe;
    private boolean xray;
    private int viewportWidth;
    private int viewportHeight;
    private float depthRangeNear;
    private float depthRangeFar;
    private static Camera camera;
    private static Transform cameraTransform;
    private static Vector lights;
    private static Vector lightsTransforms;
    private static Canvas canvas;
    private static ByteBuffer buffer;
    private static ImageData bufferImage;
    private static GLCapabilities capabilities;
    private static long window;
    private boolean paintListenerSet;

    private M3GView3D() {
        instance = this;
        this.depthRangeNear = 0.0f;
        this.depthRangeFar = 1.0f;
        this.memoryBuffers = new LWJGLUtil();
        this.renderPipe = new RenderPipe();
    }

    public static M3GView3D getViewInstance() {
        if (instance == null) {
            instance = new M3GView3D();
        }
        return instance;
    }

    public boolean isRenderInvisibleNodes() {
        return this.renderPipe.isRenderInvisibleNodes();
    }

    public void setRenderInvisibleNodes(boolean render) {
        this.renderPipe.setRenderInvisibleNodes(render);
    }

    public final void setXray(boolean var1) {
        this.xray = var1;
    }

    public final void setViewport(int var1, int var2) {
        this.viewportWidth = var1;
        this.viewportHeight = var2;
    }

    private void setupViewport() {
        GL11.glViewport(0, 0, this.viewportWidth, this.viewportHeight);
        GL11.glScissor(0, 0, this.viewportWidth, this.viewportHeight);
    }

    private void setupDepth() {
        GL11.glDepthRange(this.depthRangeNear, this.depthRangeFar);
    }

    public final void clearBackground(Background var1) {
        this.setupViewport();
        this.setupDepth();
        GL11.glClearDepth(1.0);
        GL11.glDepthMask(true);
        GL11.glColorMask(true, true, true, true);
        int var10000 = var1 != null && !this.xray ? var1.getColor() : 0;
        GL11.glClearColor(G3DUtils.getFloatColor(var10000, 16), G3DUtils.getFloatColor(var10000, 8), G3DUtils.getFloatColor(var10000, 0), G3DUtils.getFloatColor(var10000, 24));
        GL11.glClear(16640);
        if (var1 != null && !this.xray) {
            GL11.glClear(var1.isColorClearEnabled() ? 16384 : 0);
            this.method385(var1);
        } else {
            GL11.glClear(16384);
        }
    }

    private void method385(Background var1) {
        if (var1 != null && var1.getImage() != null && var1.getCropWidth() > 0 && var1.getCropHeight() > 0) {
            GL11.glDisable(2896);
            GL11.glDisable(2912);
            int var2 = var1.getImage().getFormat() == 99 ? 6407 : 6408;
            int var3 = var1.getImage().getWidth();
            int var4 = var1.getImage().getHeight();
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            float var5 = this.viewportWidth;
            float var6 = this.viewportHeight;
            float var7 = var5 / (float)var1.getCropWidth();
            float var8 = var6 / (float)var1.getCropHeight();
            float var9 = var7 * (float)var3;
            float var10 = var8 * (float)var4;
            float var11 = -var5 * (float)var1.getCropX() / (float)var1.getCropWidth() - var5 / 2.0f;
            float var12 = var6 * (float)var1.getCropY() / (float)var1.getCropHeight() + var6 / 2.0f;
            int var13 = 1;
            int var14 = 1;
            if (var1.getImageModeX() == 33) {
                float f2;
                var11 %= var9;
                if (f2 > 0.0f) {
                    var11 -= var9;
                }
                var13 = (int)(2.5f + var5 / var9);
                var11 -= (float)(var13 / 2) * var9;
            }
            if (var1.getImageModeY() == 33) {
                var12 %= var10;
                var14 = (int)(2.5f + var6 / var10);
                var12 += (float)(var14 / 2) * var10;
            }
            GL11.glPixelStorei(3314, var3);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
            GL11.glDepthFunc(519);
            GL11.glDepthMask(false);
            GL11.glPixelZoom(var7, -var8);
            ByteBuffer var15 = this.memoryBuffers.getImageBuffer(var1.getImage().getImageData());
            for (int var16 = 0; var16 < var14; ++var16) {
                for (int var17 = 0; var17 < var13; ++var17) {
                    GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                    GL11.glBitmap(0, 0, 0.0f, 0.0f, var11 + (float)var17 * var9, var12 - (float)var16 * var10, var15);
                    GL11.glDrawPixels(var3, var4, var2, 5121, var15);
                }
            }
            GL11.glPixelStorei(3314, 0);
        }
    }

    public final void method368(Node var1, Transform var2) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        if (!(var1 instanceof Sprite3D || var1 instanceof Mesh || var1 instanceof Group)) {
            throw new IllegalArgumentException();
        }
        this.renderPipe.pushRenderNode(var1, var2 == null ? new Transform() : var2);
        this.renderPushedNodes();
    }

    private void renderPushedNodes() {
        this.renderPipe.sortNodes();
        for (int i2 = 0; i2 < this.renderPipe.getSize(); ++i2) {
            RenderObject ro = this.renderPipe.getRenderObj(i2);
            if (ro.node instanceof Mesh) {
                Mesh mesh = (Mesh)ro.node;
                IndexBuffer indices = mesh.getIndexBuffer(ro.submeshIndex);
                Appearance ap = mesh.getAppearance(ro.submeshIndex);
                if (indices == null || ap == null) continue;
                VertexBuffer vb = MeshMorph.getViewInstance().getMorphedVertexBuffer(mesh);
                this.renderVertex(vb, indices, ap, ro.trans, mesh.getScope(), ro.alphaFactor);
                continue;
            }
            this.renderSprite((Sprite3D)ro.node, ro.trans, ro.alphaFactor);
        }
        this.renderPipe.clear();
        MeshMorph.getViewInstance().clearCache();
    }

    private void renderVertex(VertexBuffer var1, IndexBuffer var2, Appearance var3, Transform var4, int scope, float alphaFactor) {
        if ((camera.getScope() & scope) != 0) {
            this.setupViewport();
            this.setupDepth();
            this.setupCamera();
            this.setupLights(lights, lightsTransforms, scope);
            if (var4 != null) {
                Transform var7 = new Transform();
                var7.set(var4);
                var7.transpose();
                GL11.glMultMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)var7.getImpl()).m_matrix));
            }
            this.setupAppearance(var3, false);
            this.draw(var1, var2, var3, alphaFactor);
        }
    }

    private void renderSprite(Sprite3D var1, Transform var2, float alphaFactor) {
        block19: {
            int var28;
            ByteBuffer var27;
            int[] var21;
            block26: {
                int var29;
                float var20;
                float var19;
                float var18;
                float var17;
                float var16;
                float var15;
                Transform var10;
                Transform var6;
                block25: {
                    float var10000;
                    block24: {
                        int[] var12;
                        block23: {
                            boolean var14;
                            block22: {
                                block21: {
                                    block20: {
                                        Vector4f var3 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                                        Vector4f var4 = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
                                        Vector4f var5 = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
                                        var6 = new Transform(cameraTransform);
                                        var6.postMultiply(var2);
                                        Transform3D impl = (Transform3D)var6.getImpl();
                                        impl.transform(var3);
                                        impl.transform(var4);
                                        impl.transform(var5);
                                        Vector4f var7 = new Vector4f(var3);
                                        var3.mul(1.0f / var3.w);
                                        var4.mul(1.0f / var4.w);
                                        var5.mul(1.0f / var5.w);
                                        var4.sub(var3);
                                        var5.sub(var3);
                                        Vector4f var8 = new Vector4f(var4.length(), 0.0f, 0.0f, 0.0f);
                                        Vector4f var9 = new Vector4f(0.0f, var5.length(), 0.0f, 0.0f);
                                        var8.add(var7);
                                        var9.add(var7);
                                        var10 = new Transform();
                                        camera.getProjection(var10);
                                        impl = (Transform3D)var10.getImpl();
                                        impl.transform(var7);
                                        impl.transform(var8);
                                        impl.transform(var9);
                                        if (!(var7.w > 0.0f) || !(-var7.w < var7.z) || !(var7.z <= var7.w)) break block19;
                                        var7.mul(1.0f / var7.w);
                                        var8.mul(1.0f / var8.w);
                                        var9.mul(1.0f / var9.w);
                                        var8.sub(var7);
                                        var9.sub(var7);
                                        boolean var11 = var1.isScaled();
                                        var12 = new int[]{var1.getCropX(), var1.getCropY(), var1.getCropWidth(), var1.getCropHeight()};
                                        boolean var13 = var12[2] < 0;
                                        var14 = var12[3] < 0;
                                        var12[2] = Math.abs(var12[2]);
                                        var12[3] = Math.abs(var12[3]);
                                        var15 = 1.0f;
                                        var16 = 1.0f;
                                        var17 = (var13 ? var12[2] : -var12[2]) / 2;
                                        var18 = (var14 ? -var12[3] : var12[3]) / 2;
                                        if (!var11) {
                                            if (var13) {
                                                var15 = -1.0f;
                                            }
                                            if (var14) {
                                                var16 = -1.0f;
                                            }
                                            var19 = var12[2];
                                            var20 = var12[3];
                                        } else {
                                            var15 = var8.length() * (float)this.viewportWidth * 0.5f;
                                            var16 = var9.length() * (float)this.viewportHeight * 0.5f;
                                            var19 = var15;
                                            var20 = var16;
                                            var17 = -var15 / 2.0f;
                                            var18 = var16 / 2.0f;
                                            if (var13) {
                                                var17 += var15;
                                            }
                                            if (var14) {
                                                var18 -= var16;
                                            }
                                            var15 /= var13 ? -((float)var12[2]) : (float)var12[2];
                                            var16 /= var14 ? -((float)var12[3]) : (float)var12[3];
                                        }
                                        var21 = new int[4];
                                        if (!G3DUtils.intersectRectangle(var12[0], var12[1], var12[2], var12[3], 0, 0, var1.getImage().getWidth(), var1.getImage().getHeight(), var21)) break block19;
                                        if (var13) break block20;
                                        var10000 = var17 - var15 * (float)(var12[0] - var21[0]);
                                        break block21;
                                    }
                                    if (var12[0] <= 0) break block22;
                                    var10000 = var17 + var15 * (float)(var12[0] - var21[0]);
                                }
                                var17 = var10000;
                            }
                            if (var14) break block23;
                            var10000 = var18 + var16 * (float)(var12[1] - var21[1]);
                            break block24;
                        }
                        if (var12[1] <= 0) break block25;
                        var10000 = var18 - var16 * (float)(var12[1] - var21[1]);
                    }
                    var18 = var10000;
                }
                Transform var22 = new Transform();
                var22.postScale((float)this.viewportWidth / ((float)this.viewportWidth + var19), (float)this.viewportHeight / ((float)this.viewportHeight + var20), 1.0f);
                var22.postMultiply(var10);
                var10.set(var22);
                int var23 = (int)(0.0f - var19 / 2.0f);
                int var24 = (int)(0.0f - var20 / 2.0f);
                int var25 = (int)((float)this.viewportWidth + var19);
                int var26 = (int)((float)this.viewportHeight + var20);
                var10.transpose();
                var6.transpose();
                GL11.glViewport(var23, this.viewportHeight - var24 - var26, var25, var26);
                GL11.glMatrixMode(5889);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)var10.getImpl()).m_matrix));
                GL11.glMatrixMode(5888);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)var6.getImpl()).m_matrix));
                GL11.glDisable(2896);
                var27 = this.memoryBuffers.getImageBuffer(var1.getImage().getImageData());
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glPixelStorei(3314, var1.getImage().getWidth());
                GL11.glPixelStorei(3315, var21[1]);
                GL11.glPixelStorei(3316, var21[0]);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, var17, var18, var27);
                GL11.glPixelZoom(var15, -var16);
                var28 = 6407;
                switch (var1.getImage().getFormat()) {
                    case 96: {
                        var29 = 6406;
                        break;
                    }
                    case 97: {
                        var29 = 6409;
                        break;
                    }
                    case 98: {
                        var29 = 6410;
                        break;
                    }
                    case 99: {
                        var29 = 6407;
                        break;
                    }
                    case 100: {
                        var29 = 6408;
                        break;
                    }
                    default: {
                        break block26;
                    }
                }
                var28 = var29;
            }
            this.setupAppearance(var1.getAppearance(), true);
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)(255.0f * alphaFactor));
            GL11.glDisableClientState(32886);
            GL11.glDrawPixels(var21[2], var21[3], var28, 5121, var27);
            GL11.glPixelStorei(3314, 0);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
        }
    }

    public final boolean init(Canvas canvas) {
        M3GView3D.canvas = canvas;
        try {
            GLCanvasUtil.makeCurrent(canvas);
            this.getCapabilities();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (window == 0L) {
                if (!GLFW.glfwInit()) {
                    return false;
                }
                GLFW.glfwDefaultWindowHints();
                GLFW.glfwWindowHint(131076, 0);
                GLFW.glfwWindowHint(131075, 1);
                window = GLFW.glfwCreateWindow(400, 300, "M3GView", 0L, 0L);
                if (window == 0L) {
                    return false;
                }
            }
            GLFW.glfwMakeContextCurrent(window);
            this.getCapabilities();
            SWTFrontend.getDisplay().syncExec((Runnable)this);
        }
        this.hints();
        return true;
    }

    private void getCapabilities() {
        if (capabilities == null) {
            capabilities = GL.createCapabilities();
            return;
        }
        try {
            capabilities = GL.getCapabilities();
        }
        catch (Exception e2) {
            capabilities = GL.createCapabilities();
        }
    }

    private void hints() {
        GL11.glEnable(3089);
        GL11.glEnable(2977);
        GL11.glPixelStorei(3317, 1);
        GL11.glDisable(2832);
        GL11.glDisable(2848);
        GL11.glDisable(2881);
        GL11.glEnable(3024);
    }

    public final void setCurrent(int w, int h2) throws Exception {
        if (this.viewportHeight != w || this.viewportHeight != h2) {
            this.viewportWidth = w;
            this.viewportHeight = h2;
            if (window != 0L) {
                bufferImage = new ImageData(w, h2, 32, Emulator3D.swtPalleteData);
                buffer = BufferUtils.createByteBuffer(w * h2 * 4);
                GLFW.glfwSetWindowSize(window, w, h2);
            }
        }
    }

    public void paintControl(PaintEvent p) {
        GC gc = p.gc;
        if (bufferImage != null) {
            Image img = new Image(null, bufferImage);
            gc.drawImage(img, 0, 0);
            img.dispose();
        }
    }

    public void swapBuffers() {
        GL11.glFinish();
        if (window != 0L) {
            buffer.rewind();
            GL11.glReadPixels(0, 0, this.viewportWidth, this.viewportHeight, 6408, 5121, buffer);
            int var8 = M3GView3D.bufferImage.width << 2;
            int var10 = M3GView3D.bufferImage.data.length - var8;
            for (int i2 = M3GView3D.bufferImage.height; i2 > 0; --i2) {
                buffer.get(M3GView3D.bufferImage.data, var10, var8);
                var10 -= var8;
            }
        }
        SWTFrontend.getDisplay().syncExec((Runnable)this);
    }

    @Override
    public void run() {
        if (window != 0L && !this.paintListenerSet) {
            this.paintListenerSet = true;
            canvas.addPaintListener((PaintListener)this);
            return;
        }
        try {
            if (canvas.isDisposed()) {
                return;
            }
            if (window == 0L) {
                GLCanvasUtil.swapBuffers(canvas);
            }
            canvas.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void releaseContext() {
        if (window != 0L) {
            GLFW.glfwMakeContextCurrent(0L);
            return;
        }
        try {
            GLCanvasUtil.releaseContext(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCamera(Camera var0, Transform var1) {
        if (var1 != null) {
            cameraTransform.set(var1);
            ((Transform3D)cameraTransform.getImpl()).invert();
        } else {
            cameraTransform.setIdentity();
        }
        camera = var0;
    }

    public static int method381(Light var0, Transform var1) {
        if (var0 == null) {
            throw new NullPointerException();
        }
        lights.add(var0);
        if (var1 == null) {
            lightsTransforms.add(new Transform());
        } else {
            lightsTransforms.add(new Transform(var1));
        }
        return lights.size();
    }

    public static void method388() {
        lights.clear();
        lightsTransforms.clear();
    }

    public final void method374(World var1) {
        M3GView3D.method388();
        this.method365(var1, var1);
    }

    private void method365(World var1, Group var2) {
        Transform var3 = new Transform();
        for (int var4 = 0; var4 < var2.getChildCount(); ++var4) {
            Node var5 = var2.getChild(var4);
            if (var5 instanceof Light && var5.getTransformTo(var1, var3)) {
                lights.add(var5);
                lightsTransforms.add(new Transform(var3));
                continue;
            }
            if (!(var5 instanceof Group)) continue;
            this.method365(var1, (Group)var5);
        }
    }

    private void setupAppearance(Appearance var1, boolean var3) {
        if (!var3) {
            this.setupPolygonMode(var1.getPolygonMode());
        }
        this.setupCompositingMode(var1.getCompositingMode());
        if (!var3) {
            this.setupMaterial(var1.getMaterial());
        }
        this.setupFog(var1.getFog());
    }

    private void setupPolygonMode(PolygonMode pm) {
        if (pm == null) {
            pm = new PolygonMode();
        }
        GL11.glPolygonMode(1032, this.xray ? 6913 : 6914);
        int var1 = pm.getCulling();
        if (var1 == 162) {
            GL11.glDisable(2884);
        } else {
            GL11.glEnable(2884);
            GL11.glCullFace(var1 == 161 ? 1028 : 1029);
        }
        GL11.glShadeModel(pm.getShading() == 164 ? 7424 : 7425);
        GL11.glFrontFace(pm.getWinding() == 169 ? 2304 : 2305);
        GL11.glLightModelf(2898, pm.isTwoSidedLightingEnabled() ? 1.0f : 0.0f);
        GL11.glLightModelf(2897, pm.isLocalCameraLightingEnabled() ? 1.0f : 0.0f);
        boolean persCorrect = pm.isPerspectiveCorrectionEnabled();
        if (Settings.m3gForcePerspectiveCorrection) {
            persCorrect = true;
        }
        GL11.glHint(3152, persCorrect ? 4354 : 4353);
    }

    private void setupCompositingMode(CompositingMode cm) {
        if (cm == null) {
            cm = new CompositingMode();
        }
        GL11.glEnable(2929);
        GL11.glDepthMask(cm.isDepthWriteEnabled());
        GL11.glDepthFunc(cm.isDepthTestEnabled() ? 515 : 519);
        GL11.glColorMask(cm.isColorWriteEnabled(), cm.isColorWriteEnabled(), cm.isColorWriteEnabled(), cm.isAlphaWriteEnabled());
        GL11.glAlphaFunc(518, cm.getAlphaThreshold());
        if (cm.getAlphaThreshold() == 0.0f) {
            GL11.glDisable(3008);
        } else {
            GL11.glEnable(3008);
        }
        if (cm.getBlending() == 68) {
            GL11.glDisable(3042);
        } else {
            GL11.glEnable(3042);
        }
        switch (cm.getBlending()) {
            case 64: {
                GL11.glBlendFunc(770, 771);
                break;
            }
            case 65: {
                GL11.glBlendFunc(770, 1);
                break;
            }
            case 66: {
                GL11.glBlendFunc(774, 0);
                break;
            }
            case 67: {
                GL11.glBlendFunc(774, 768);
                break;
            }
            case 68: {
                GL11.glBlendFunc(1, 0);
                break;
            }
        }
        GL11.glPolygonOffset(cm.getDepthOffsetFactor(), cm.getDepthOffsetUnits());
        if (cm.getDepthOffsetFactor() == 0.0f && cm.getDepthOffsetUnits() == 0.0f) {
            GL11.glDisable(this.xray ? 10754 : 32823);
        } else {
            GL11.glEnable(this.xray ? 10754 : 32823);
        }
    }

    private void setupMaterial(Material mat) {
        if (mat != null) {
            GL11.glEnable(2896);
            float[] tmpCol = new float[4];
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(1024));
            GL11.glMaterialfv(1032, 4608, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(2048));
            GL11.glMaterialfv(1032, 4609, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(4096));
            GL11.glMaterialfv(1032, 5632, this.memoryBuffers.getFloatBuffer(tmpCol));
            G3DUtils.fillFloatColor(tmpCol, mat.getColor(8192));
            GL11.glMaterialfv(1032, 4610, this.memoryBuffers.getFloatBuffer(tmpCol));
            GL11.glMaterialf(1032, 5633, mat.getShininess());
            if (mat.isVertexColorTrackingEnabled()) {
                GL11.glEnable(2903);
                GL11.glColorMaterial(1032, 5634);
            } else {
                GL11.glDisable(2903);
            }
        } else {
            GL11.glDisable(2896);
        }
    }

    private void setupFog(Fog fog) {
        if (fog != null && !this.xray) {
            GL11.glEnable(2912);
            GL11.glFogi(2917, fog.getMode() == 81 ? 9729 : 2048);
            float[] fogColor = new float[4];
            G3DUtils.fillFloatColor(fogColor, fog.getColor());
            fogColor[3] = 1.0f;
            GL11.glFogfv(2918, this.memoryBuffers.getFloatBuffer(fogColor));
            GL11.glFogf(2915, fog.getNearDistance());
            GL11.glFogf(2916, fog.getFarDistance());
            GL11.glFogf(2914, fog.getDensity());
        } else {
            GL11.glDisable(2912);
        }
    }

    private void draw(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, float alphaFactor) {
        VertexArray colors = vertexBuffer.getColors();
        if (colors == null) {
            int col = vertexBuffer.getDefaultColor();
            GL11.glColor4ub((byte)(col >> 16 & 0xFF), (byte)(col >> 8 & 0xFF), (byte)(col & 0xFF), (byte)((float)(col >> 24 & 0xFF) * alphaFactor));
            GL11.glDisableClientState(32886);
        } else {
            GL11.glEnableClientState(32886);
            if (colors.getComponentType() == 1) {
                byte[] colorsBArr = colors.getByteValues();
                GL11.glColorPointer(alphaFactor == 1.0f ? colors.getComponentCount() : 4, 5121, 0, this.memoryBuffers.getColorBuffer(colorsBArr, alphaFactor, colors.getVertexCount()));
            }
        }
        VertexArray normals = vertexBuffer.getNormals();
        if (normals != null && appearance.getMaterial() != null) {
            GL11.glEnableClientState(32885);
            GL11.glEnable(2977);
            if (normals.getComponentType() == 1) {
                GL11.glNormalPointer(5120, 0, this.memoryBuffers.getNormalBuffer(normals.getByteValues()));
            } else {
                GL11.glNormalPointer(5122, 0, this.memoryBuffers.getNormalBuffer(normals.getShortValues()));
            }
        } else {
            GL11.glDisableClientState(32885);
        }
        float[] scaleBias = new float[4];
        VertexArray positions = vertexBuffer.getPositions(scaleBias);
        GL11.glEnableClientState(32884);
        if (positions.getComponentType() == 1) {
            byte[] posesBArr = positions.getByteValues();
            GL11.glVertexPointer(positions.getComponentCount(), 5122, 0, this.memoryBuffers.getVertexBuffer(posesBArr));
        } else {
            short[] posesSArr = positions.getShortValues();
            GL11.glVertexPointer(positions.getComponentCount(), 5122, 0, this.memoryBuffers.getVertexBuffer(posesSArr));
        }
        GL11.glMatrixMode(5888);
        GL11.glTranslatef(scaleBias[1], scaleBias[2], scaleBias[3]);
        GL11.glScalef(scaleBias[0], scaleBias[0], scaleBias[0]);
        TriangleStripArray triangleStripArray = (TriangleStripArray)indexBuffer;
        int stripCount = triangleStripArray.getStripCount();
        if (appearance != null && !this.xray) {
            int i2;
            IntBuffer var10 = BufferUtils.createIntBuffer(10);
            GL11.glGenTextures(var10);
            for (i2 = 0; i2 < 10; ++i2) {
                Texture2D texture2D = appearance.getTexture(i2);
                VertexArray texCoords = vertexBuffer.getTexCoords(i2, scaleBias);
                if (texture2D == null || texCoords == null) continue;
                Image2D image2D = texture2D.getImage();
                scaleBias[3] = 0.0f;
                if (!M3GView3D.useGL11()) {
                    GL13.glActiveTexture(33984 + i2);
                    GL13.glClientActiveTexture(33984 + i2);
                }
                GL11.glEnable(3553);
                GL11.glBindTexture(3553, var10.get(i2));
                int blendMode = 0;
                switch (texture2D.getBlending()) {
                    case 224: {
                        blendMode = 260;
                        break;
                    }
                    case 225: {
                        blendMode = 3042;
                        break;
                    }
                    case 226: {
                        blendMode = 8449;
                        break;
                    }
                    case 227: {
                        blendMode = 8448;
                        break;
                    }
                    case 228: {
                        blendMode = 7681;
                        break;
                    }
                }
                GL11.glTexEnvi(8960, 8704, blendMode);
                float[] blendColor = new float[4];
                G3DUtils.fillFloatColor(blendColor, texture2D.getBlendColor());
                blendColor[3] = 1.0f;
                GL11.glTexEnvfv(8960, 8705, this.memoryBuffers.getFloatBuffer(blendColor));
                int texFormat = 6407;
                switch (image2D.getFormat()) {
                    case 96: {
                        texFormat = 6406;
                        break;
                    }
                    case 97: {
                        texFormat = 6409;
                        break;
                    }
                    case 98: {
                        texFormat = 6410;
                        break;
                    }
                    case 99: {
                        texFormat = 6407;
                        break;
                    }
                    case 100: {
                        texFormat = 6408;
                    }
                }
                GL11.glTexImage2D(3553, 0, texFormat, image2D.getWidth(), image2D.getHeight(), 0, texFormat, 5121, this.memoryBuffers.getImageBuffer(image2D.getImageData()));
                GL11.glTexParameterf(3553, 10242, texture2D.getWrappingS() == 240 && !M3GView3D.useGL11() ? 33071.0f : 10497.0f);
                GL11.glTexParameterf(3553, 10243, texture2D.getWrappingT() == 240 && !M3GView3D.useGL11() ? 33071.0f : 10497.0f);
                int levelFilter = texture2D.getLevelFilter();
                int imageFilter = texture2D.getImageFilter();
                if (M3GView3D.useGL11() || Settings.m3gMipmapping != 1) {
                    // empty if block
                }
                levelFilter = 208;
                if (!M3GView3D.useGL11()) {
                    GL11.glTexParameteri(3553, 34046, 1);
                }
                if (Settings.m3gTexFilter == 1) {
                    imageFilter = 210;
                } else if (Settings.m3gTexFilter == 2) {
                    imageFilter = 209;
                }
                int magFilter = 0;
                int minFilter = 0;
                if (imageFilter == 210) {
                    magFilter = 9728;
                    minFilter = 9728;
                    if (levelFilter == 210) {
                        minFilter = 9984;
                    } else if (levelFilter == 209) {
                        minFilter = 9986;
                    }
                } else if (imageFilter == 209) {
                    magFilter = 9729;
                    minFilter = 9729;
                    if (levelFilter == 210) {
                        minFilter = 9985;
                    } else if (levelFilter == 209) {
                        minFilter = 9987;
                    }
                }
                GL11.glTexParameteri(3553, 10241, minFilter);
                GL11.glTexParameteri(3553, 10240, magFilter);
                GL11.glEnableClientState(32888);
                ShortBuffer texCoordBuffer = texCoords.getComponentType() == 1 ? this.memoryBuffers.getTexCoordBuffer(texCoords.getByteValues(), i2) : this.memoryBuffers.getTexCoordBuffer(texCoords.getShortValues(), i2);
                GL11.glTexCoordPointer(texCoords.getComponentCount(), 5122, 0, texCoordBuffer);
                Transform tmpMat = new Transform();
                texture2D.getCompositeTransform(tmpMat);
                tmpMat.transpose();
                GL11.glMatrixMode(5890);
                GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
                GL11.glTranslatef(scaleBias[1], scaleBias[2], scaleBias[3]);
                GL11.glScalef(scaleBias[0], scaleBias[0], scaleBias[0]);
            }
            for (i2 = 0; i2 < stripCount; ++i2) {
                int[] indexStrip = triangleStripArray.getIndexStrip(i2);
                GL11.glDrawElements(5, this.memoryBuffers.getElementsBuffer(indexStrip));
            }
            if (!M3GView3D.useGL11()) {
                for (i2 = 0; i2 < 10; ++i2) {
                    if (!GL11.glIsTexture(var10.get(i2))) continue;
                    GL13.glActiveTexture(33984 + i2);
                    GL13.glClientActiveTexture(33984 + i2);
                    GL11.glDisableClientState(32888);
                    GL11.glDisable(3553);
                }
            }
            GL11.glDeleteTextures(var10);
        } else {
            for (int i3 = 0; i3 < stripCount; ++i3) {
                int[] indexStrip = triangleStripArray.getIndexStrip(i3);
                GL11.glDrawElements(5, this.memoryBuffers.getElementsBuffer(indexStrip));
            }
        }
        int err = GL11.glGetError();
        if (err != 0) {
            Emulator.getEmulator().getLogStream().println("M3GView GL Error: " + err);
        }
    }

    private static boolean useGL11() {
        return !M3GView3D.capabilities.OpenGL12;
    }

    private void setupCamera() {
        if (camera != null) {
            Transform tmpMat = new Transform();
            camera.getProjection(tmpMat);
            tmpMat.transpose();
            GL11.glMatrixMode(5889);
            GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
            tmpMat.set(cameraTransform);
            tmpMat.transpose();
            GL11.glMatrixMode(5888);
            GL11.glLoadMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
        }
    }

    private void setupLights(Vector lights, Vector lightMats, int scope) {
        for (int i2 = 0; i2 < 8; ++i2) {
            GL11.glDisable(16384 + i2);
        }
        if (!M3GView3D.useGL11() && M3GView3D.capabilities.GL_ARB_color_buffer_float) {
            ARBColorBufferFloat.glClampColorARB(35098, Settings.m3gDisableLightClamp ? 0 : 1);
        }
        int usedLights = 0;
        Transform tmpMat = new Transform();
        for (int i3 = 0; i3 < lights.size() && usedLights < 8; ++i3) {
            Light light = (Light)lights.get(i3);
            if (light == null || (light.getScope() & scope) == 0 || !this.renderPipe.isVisible(light)) continue;
            Transform lightMat = (Transform)lightMats.get(i3);
            if (lightMat != null) {
                tmpMat.set(lightMat);
            } else {
                tmpMat.setIdentity();
            }
            tmpMat.transpose();
            GL11.glPushMatrix();
            GL11.glMatrixMode(5888);
            GL11.glMultMatrixf(this.memoryBuffers.getFloatBuffer(((Transform3D)tmpMat.getImpl()).m_matrix));
            int lightId = 16384 + usedLights;
            ++usedLights;
            float[] lightColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            GL11.glLightfv(lightId, 4608, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightfv(lightId, 4609, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightfv(lightId, 4610, this.memoryBuffers.getFloatBuffer(lightColor));
            GL11.glLightf(lightId, 4615, 1.0f);
            GL11.glLightf(lightId, 4616, 0.0f);
            GL11.glLightf(lightId, 4617, 0.0f);
            GL11.glLightf(lightId, 4614, 180.0f);
            GL11.glLightf(lightId, 4613, 0.0f);
            float[] tmpLightPos = light.getMode() == 129 ? LightsCache.POSITIVE_Z_AXIS : LightsCache.LOCAL_ORIGIN;
            GL11.glLightfv(lightId, 4611, this.memoryBuffers.getFloatBuffer(tmpLightPos));
            G3DUtils.fillFloatColor(lightColor, light.getColor());
            float lightIntensity = light.getIntensity();
            lightColor[0] = lightColor[0] * lightIntensity;
            lightColor[1] = lightColor[1] * lightIntensity;
            lightColor[2] = lightColor[2] * lightIntensity;
            lightColor[3] = 1.0f;
            int lightMode = light.getMode();
            if (lightMode == 128) {
                GL11.glLightfv(lightId, 4608, this.memoryBuffers.getFloatBuffer(lightColor));
            } else {
                GL11.glLightfv(lightId, 4609, this.memoryBuffers.getFloatBuffer(lightColor));
                GL11.glLightfv(lightId, 4610, this.memoryBuffers.getFloatBuffer(lightColor));
            }
            if (lightMode == 131) {
                GL11.glLightfv(lightId, 4612, this.memoryBuffers.getFloatBuffer(LightsCache.NEGATIVE_Z_AXIS));
                GL11.glLightf(lightId, 4614, light.getSpotAngle());
                GL11.glLightf(lightId, 4613, light.getSpotExponent());
            }
            if (lightMode == 131 || lightMode == 130) {
                GL11.glLightf(lightId, 4615, light.getConstantAttenuation());
                GL11.glLightf(lightId, 4616, light.getLinearAttenuation());
                GL11.glLightf(lightId, 4617, light.getQuadraticAttenuation());
            }
            GL11.glEnable(lightId);
            GL11.glPopMatrix();
        }
    }

    public final void drawGrid(float var1) {
        this.setupViewport();
        this.setupDepth();
        this.setupCamera();
        GL11.glPolygonMode(1032, 6914);
        GL11.glDisable(2884);
        GL11.glShadeModel(7425);
        GL11.glFrontFace(2305);
        GL11.glEnable(2929);
        GL11.glDepthFunc(519);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDisable(32823);
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glColor4ub((byte)70, (byte)121, (byte)-80, (byte)-1);
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32885);
        float var2 = var1 * 5.0f;
        boolean var3 = true;
        GL11.glMatrixMode(5888);
        GL11.glBegin(7);
        float var10000 = -var2;
        block0: while (true) {
            float var4 = var10000;
            if (var10000 >= var2) {
                GL11.glEnd();
                return;
            }
            var10000 = -var2;
            while (true) {
                float var5 = var10000;
                if (var10000 >= var2) {
                    var3 = !var3;
                    var10000 = var4 + var1;
                    continue block0;
                }
                if (var3) {
                    GL11.glVertex3f(var4, 0.0f, var5);
                    GL11.glVertex3f(var4 + var1, 0.0f, var5);
                    GL11.glVertex3f(var4 + var1, 0.0f, var5 + var1);
                    GL11.glVertex3f(var4, 0.0f, var5 + var1);
                }
                var3 = !var3;
                var10000 = var5 + var1;
            }
            break;
        }
    }

    public final void drawAxis() {
        this.setupViewport();
        this.setupDepth();
        this.setupCamera();
        GL11.glPolygonMode(1032, 6914);
        GL11.glDisable(2884);
        GL11.glShadeModel(7425);
        GL11.glFrontFace(2305);
        GL11.glEnable(2929);
        GL11.glDepthFunc(519);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDisable(32823);
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32885);
        GL11.glMatrixMode(5888);
        GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(1.0f, 0.0f, 0.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(1.3f, 0.0f, 0.0f);
        GL11.glVertex3f(1.0f, 0.1f, 0.1f);
        GL11.glVertex3f(1.0f, -0.1f, 0.1f);
        GL11.glVertex3f(1.0f, -0.1f, -0.1f);
        GL11.glVertex3f(1.0f, 0.1f, -0.1f);
        GL11.glVertex3f(1.0f, 0.1f, 0.1f);
        GL11.glEnd();
        GL11.glColor4ub((byte)0, (byte)-1, (byte)0, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 1.0f, 0.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(0.0f, 1.3f, 0.0f);
        GL11.glVertex3f(0.1f, 1.0f, 0.1f);
        GL11.glVertex3f(-0.1f, 1.0f, 0.1f);
        GL11.glVertex3f(-0.1f, 1.0f, -0.1f);
        GL11.glVertex3f(0.1f, 1.0f, -0.1f);
        GL11.glVertex3f(0.1f, 1.0f, 0.1f);
        GL11.glEnd();
        GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 0.0f, 1.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(0.0f, 0.0f, 1.3f);
        GL11.glVertex3f(0.1f, 0.1f, 1.0f);
        GL11.glVertex3f(-0.1f, 0.1f, 1.0f);
        GL11.glVertex3f(-0.1f, -0.1f, 1.0f);
        GL11.glVertex3f(0.1f, -0.1f, 1.0f);
        GL11.glVertex3f(0.1f, 0.1f, 1.0f);
        GL11.glEnd();
    }

    static {
        cameraTransform = new Transform();
        lights = new Vector();
        lightsTransforms = new Vector();
    }
}

