/*
 * Decompiled with CFR 0.152.
 */
package emulator.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

final class ChoiceImpl {
    private Vector items = new Vector();
    private int fitPolicy;
    private boolean multiSel;

    ChoiceImpl(boolean multiSel) {
        this.multiSel = multiSel;
    }

    void check(String[] textElements, Image[] imgElements) {
        if (textElements == null) {
            throw new NullPointerException();
        }
        for (int i2 = 0; i2 < textElements.length; ++i2) {
            if (textElements[i2] != null) continue;
            throw new NullPointerException();
        }
        if (imgElements != null && imgElements.length != textElements.length) {
            throw new IllegalArgumentException();
        }
    }

    synchronized int append(String text, Image image) {
        this.validateString(text);
        ChoiceData data = new ChoiceData(text, image, Font.getDefaultFont(), !this.multiSel && this.size() == 0);
        this.items.addElement(data);
        return this.size() - 1;
    }

    synchronized void insert(int elementNum, String text, Image image) {
        this.validateString(text);
        this.validatePosition(elementNum, this.size() + 1);
        ChoiceData data = new ChoiceData(text, image, Font.getDefaultFont(), !this.multiSel && this.size() == 0);
        this.items.insertElementAt(data, elementNum);
    }

    synchronized void set(int elementNum, String text, Image image) {
        this.validateString(text);
        this.validatePosition(elementNum, this.size());
        ChoiceData data = (ChoiceData)this.items.elementAt(elementNum);
        data.text = text;
        data.img = image;
    }

    synchronized void setFont(int elementNum, Font font) {
        Font checkedFont;
        this.validatePosition(elementNum, this.size());
        ((ChoiceData)this.items.elementAt((int)elementNum)).font = checkedFont = font == null ? Font.getDefaultFont() : font;
    }

    synchronized void delete(int elementNum) {
        this.validatePosition(elementNum, this.size());
        if (!this.multiSel && this.isSelected(elementNum) && this.size() > 1) {
            if (elementNum == this.size() - 1) {
                this.setSelected(elementNum - 1, true);
            } else {
                this.setSelected(elementNum + 1, true);
            }
        }
        this.items.removeElementAt(elementNum);
    }

    synchronized void deleteAll() {
        this.items.removeAllElements();
    }

    int getFitPolicy() {
        return this.fitPolicy;
    }

    synchronized Font getFont(int elementNum) {
        this.validatePosition(elementNum, this.size());
        return ((ChoiceData)this.items.elementAt((int)elementNum)).font;
    }

    synchronized Image getImage(int elementNum) {
        this.validatePosition(elementNum, this.size());
        return ((ChoiceData)this.items.elementAt((int)elementNum)).img;
    }

    synchronized String getString(int elementNum) {
        this.validatePosition(elementNum, this.size());
        return ((ChoiceData)this.items.elementAt((int)elementNum)).text;
    }

    void setFitPolicy(int newFitPolicy) {
        switch (newFitPolicy) {
            case 0: 
            case 1: 
            case 2: {
                this.fitPolicy = newFitPolicy;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    synchronized int getSelectedIndex() {
        int size = this.size();
        if (!this.multiSel) {
            for (int i2 = 0; i2 < size; ++i2) {
                if (!this.isSelected(i2)) continue;
                return i2;
            }
        }
        return -1;
    }

    synchronized boolean isSelected(int elementNum) {
        this.validatePosition(elementNum, this.size());
        return ((ChoiceData)this.items.elementAt((int)elementNum)).sel;
    }

    synchronized void setSelected(int elementNum, boolean select) {
        this.validatePosition(elementNum, this.size());
        if (this.multiSel) {
            ((ChoiceData)this.items.elementAt((int)elementNum)).sel = select;
        } else if (select) {
            int size = this.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ((ChoiceData)this.items.elementAt((int)i2)).sel = false;
            }
            ((ChoiceData)this.items.elementAt((int)elementNum)).sel = true;
        }
    }

    synchronized int getSelectedFlags(boolean[] selectedArray) {
        this.validateSelectedArray(selectedArray);
        int size = this.size();
        int numSelected = 0;
        for (int i2 = 0; i2 < selectedArray.length; ++i2) {
            if (i2 < size && ((ChoiceData)this.items.elementAt((int)i2)).sel) {
                selectedArray[i2] = true;
                ++numSelected;
                continue;
            }
            selectedArray[i2] = false;
        }
        return numSelected;
    }

    synchronized void setSelectedFlags(boolean[] selectedArray) {
        this.validateSelectedArray(selectedArray);
        int size = this.size();
        if (size > 0) {
            if (this.multiSel) {
                for (int i2 = 0; i2 < size; ++i2) {
                    ((ChoiceData)this.items.elementAt((int)i2)).sel = selectedArray[i2];
                }
            } else {
                int firstSelected = 0;
                for (int i3 = 0; i3 < size; ++i3) {
                    if (!selectedArray[i3]) continue;
                    firstSelected = i3;
                    break;
                }
                this.setSelected(firstSelected, true);
            }
        }
    }

    synchronized int size() {
        return this.items.size();
    }

    private synchronized void validatePosition(int position, int upperBoundary) {
        if (position < 0 || position >= upperBoundary) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void validateString(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
    }

    private void validateSelectedArray(boolean[] selectedArray) {
        if (selectedArray == null) {
            throw new NullPointerException();
        }
        if (selectedArray.length < this.size()) {
            throw new IllegalArgumentException();
        }
    }

    private class ChoiceData {
        String text;
        Image img;
        Font font;
        boolean sel;

        ChoiceData(String text, Image img, Font font, boolean sel) {
            this.text = text;
            this.img = img;
            this.font = font;
            this.sel = sel;
        }
    }
}

