/*
 * Decompiled with CFR 0.152.
 */
package emulator.lcdui;

import emulator.Emulator;
import emulator.lcdui.ChoiceImpl;
import emulator.lcdui.IListImpl;
import emulator.lcdui.SWTScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ListSWT
extends SWTScreen
implements IListImpl {
    private final List list;
    private int type;
    private Table swtTable;
    private ChoiceImpl choiceImpl;
    private SwtTableSelectionListener swtTableListener = new SwtTableSelectionListener();

    public ListSWT(List list2, String title, int type, String[] text, Image[] img) {
        if (type != 2 && type != 1 && type != 3) {
            throw new IllegalArgumentException();
        }
        this.list = list2;
        this.type = type;
        this.constructSwt();
        switch (type) {
            case 1: 
            case 3: {
                this.choiceImpl = new ChoiceImpl(false);
                break;
            }
            case 2: {
                this.choiceImpl = new ChoiceImpl(true);
            }
        }
        this.choiceImpl.check(text, img);
        for (int i2 = 0; i2 < text.length; ++i2) {
            this.append(text[i2], img != null ? img[i2] : null);
        }
    }

    @Override
    public int append(String text, Image img) {
        final int index = this.choiceImpl.append(text, img);
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtInsertItem(index);
                ListSWT.this.swtUpdateSelection();
            }
        });
        return index;
    }

    @Override
    public void insert(int position, String text, Image img) {
        this.choiceImpl.insert(position, text, img);
        final int index = position;
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtInsertItem(index);
                ListSWT.this.swtUpdateSelection();
            }
        });
    }

    @Override
    public void set(int position, String text, Image img) {
        this.choiceImpl.set(position, text, img);
        final int index = position;
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtSetItem(index);
                ListSWT.this.swtUpdateSelection();
            }
        });
    }

    @Override
    public void delete(int position) {
        if (position < 0 || position >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        final int index = position;
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtDeleteItem(index);
                ListSWT.this.swtUpdateSelection();
            }
        });
    }

    @Override
    public void deleteAll() {
        if (this.type != 3) {
            this.choiceImpl.deleteAll();
        }
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtDeleteAllItems();
            }
        });
    }

    @Override
    public int getFitPolicy() {
        return this.choiceImpl.getFitPolicy();
    }

    @Override
    public Font getFont(int position) {
        return this.choiceImpl.getFont(position);
    }

    @Override
    public Image getImage(int position) {
        return this.choiceImpl.getImage(position);
    }

    @Override
    public String getString(int position) {
        return this.choiceImpl.getString(position);
    }

    @Override
    public int getSelectedFlags(boolean[] selectedArray) {
        return this.choiceImpl.getSelectedFlags(selectedArray);
    }

    @Override
    public int getSelectedIndex() {
        return this.choiceImpl.getSelectedIndex();
    }

    @Override
    public boolean isSelected(int position) {
        return this.choiceImpl.isSelected(position);
    }

    @Override
    public void setFitPolicy(int newFitPolicy) {
        this.choiceImpl.setFitPolicy(newFitPolicy);
    }

    @Override
    public void setFont(final int n, Font font) {
        this.choiceImpl.setFont(n, font);
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtSetItemFont(n);
            }
        });
    }

    @Override
    public void setSelectedFlags(boolean[] selectedArray) {
        this.choiceImpl.setSelectedFlags(selectedArray);
        this.updateSelection();
    }

    @Override
    public void setSelectedIndex(int position, boolean select) {
        this.choiceImpl.setSelected(position, select);
        this.updateSelection();
    }

    @Override
    public int size() {
        return this.choiceImpl.size();
    }

    @Override
    protected Composite _constructSwtContent(int style) {
        Composite c2 = super._constructSwtContent(style);
        this.swtTable = new Table(c2, this.getStyle(this.type));
        this._setSwtStyle((Control)this.swtTable);
        this.swtTable.addListener(41, event -> {
            TableItem item = (TableItem)event.item;
            String text = item.getText(event.index);
            event.gc.setFont(item.getFont());
            int i2 = 1;
            if (this.choiceImpl.getFitPolicy() == 1) {
                i2 |= 6;
            }
            Point size = event.gc.textExtent(text, i2);
            org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)item.getData();
            event.height = size.y;
            int imgWidth = 0;
            if (img != null) {
                try {
                    ImageData data = img.getImageData();
                    imgWidth = data.width;
                    int imgHeight = data.height;
                    if (imgWidth != 0 && imgHeight != 0) {
                        size.x += (int)((float)(event.height * imgWidth) / (float)imgHeight);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            event.width = size.x + 2;
        });
        this.swtTable.addListener(40, event -> event.detail &= 0xFFFFFFEF);
        this.swtTable.addListener(42, event -> {
            TableItem item = (TableItem)event.item;
            org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)item.getData();
            String text = item.getText(event.index);
            event.gc.setFont(item.getFont());
            int imgWidth = 0;
            if (img != null) {
                try {
                    ImageData data = img.getImageData();
                    imgWidth = data.width;
                    int imgHeight = data.height;
                    if (imgWidth != 0 && imgHeight != 0) {
                        int dstWidth = (int)((float)(event.height * imgWidth) / (float)imgHeight);
                        event.gc.drawImage(img, 0, 0, imgWidth, imgHeight, event.x, event.y, dstWidth, event.height);
                        imgWidth = dstWidth;
                    } else {
                        imgWidth = 0;
                    }
                }
                catch (Exception data) {
                    // empty catch block
                }
            }
            int yOffset = 0;
            if (event.index == 1) {
                Point size = event.gc.textExtent(text);
                yOffset = Math.max(0, (event.height - size.y) / 2);
            }
            int i2 = 1;
            if (this.choiceImpl.getFitPolicy() == 1) {
                i2 |= 6;
            }
            event.gc.drawText(text, event.x + imgWidth, event.y + yOffset, i2);
        });
        return c2;
    }

    private int getStyle(int listType) {
        int tableStyle = 512;
        switch (listType) {
            case 3: {
                tableStyle |= 4;
                break;
            }
            case 1: {
                tableStyle |= 0x14;
                break;
            }
            case 2: {
                tableStyle |= 0x22;
                break;
            }
        }
        return tableStyle;
    }

    private void updateSelection() {
        ListSWT.syncExec(new Runnable(){

            @Override
            public void run() {
                ListSWT.this.swtUpdateSelection();
            }
        });
    }

    private void swtUpdateSelection() {
        if (this.type == 3 || this.type == 1) {
            int sel = this.choiceImpl.getSelectedIndex();
            if (sel == -1 && this.choiceImpl.size() > 0) {
                sel = 0;
            }
            if (sel == 0 || this.swtTable.getSelectionIndex() != sel) {
                this.swtTable.setSelection(sel);
            }
            if (this.list.isShown()) {
                this.swtTable.setFocus();
            }
        } else {
            int size = this.choiceImpl.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.choiceImpl.isSelected(i2)) {
                    this.swtTable.select(i2);
                    this.swtTable.getItem(i2).setChecked(true);
                    continue;
                }
                this.swtTable.deselect(i2);
                this.swtTable.getItem(i2).setChecked(false);
            }
        }
    }

    private void swtInsertItem(int index) {
        TableItem item = new TableItem(this.swtTable, 0, index);
        Image img = this.choiceImpl.getImage(index);
        item.setData((Object)SWTScreen.getSWTImage(img));
        item.setText(0, this.choiceImpl.getString(index));
    }

    private void swtSetItem(int index) {
        TableItem item = this.swtTable.getItem(index);
        Image img = this.choiceImpl.getImage(index);
        item.setData((Object)SWTScreen.getSWTImage(img));
        item.setText(0, this.choiceImpl.getString(index));
        this.swtTable.redraw();
    }

    private void swtDeleteItem(int index) {
        this.swtTable.getItem(index).dispose();
        this.choiceImpl.delete(index);
    }

    private void swtSetItemFont(int index) {
        Font font = this.choiceImpl.getFont(index);
        this.swtTable.getItem(index).setFont(0, font == null ? null : SWTScreen.getSWTFont(font, false));
    }

    private void swtDeleteAllItems() {
        for (int i2 = this.swtTable.getItemCount() - 1; i2 >= 0; --i2) {
            if (this.type == 3) {
                this.choiceImpl.delete(i2);
            }
            this.swtTable.getItem(i2).dispose();
        }
    }

    @Override
    public boolean isSWT() {
        return true;
    }

    @Override
    public void drawScrollBar(Graphics graphics) {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    @Override
    public void layout() {
    }

    @Override
    public void swtShown() {
        super.swtShown();
        this.swtTable.addSelectionListener((SelectionListener)this.swtTableListener);
        this.swtTable.addKeyListener(swtKeyListener);
        this.updateSelection();
    }

    @Override
    public void swtHidden() {
        super.swtHidden();
        if (this.swtTable == null || this.swtTable.isDisposed()) {
            return;
        }
        this.swtTable.removeSelectionListener((SelectionListener)this.swtTableListener);
        this.swtTable.removeKeyListener(swtKeyListener);
    }

    @Override
    public void swtResized(int w, int h2) {
        super.swtResized(w, h2);
        this.swtTable.pack();
        this.swtTable.setBounds(this.swtContent.getClientArea());
    }

    class SwtTableSelectionListener
    implements SelectionListener {
        SwtTableSelectionListener() {
        }

        private void update(SelectionEvent se) {
            int index;
            if (se.widget != null && se.item != null && (index = ((Table)se.widget).indexOf((TableItem)se.item)) >= 0) {
                if (ListSWT.this.type == 2) {
                    ListSWT.this.choiceImpl.setSelected(index, ((TableItem)se.item).getChecked());
                } else {
                    ListSWT.this.choiceImpl.setSelected(index, true);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent se) {
            if (ListSWT.this.type == 3 && ListSWT.this.size() > 0) {
                Emulator.getEventQueue().commandAction(ListSWT.this.list._getSelectCommand(), ListSWT.this.list);
            }
        }

        public void widgetSelected(SelectionEvent se) {
            if (ListSWT.this.type == 3 || ListSWT.this.type == 1) {
                this.update(se);
            } else if (ListSWT.this.type == 2 && se.detail == 32) {
                this.update(se);
            }
        }
    }
}

