/*
 * Decompiled with CFR 0.152.
 */
package emulator.lcdui;

import emulator.Emulator;
import emulator.KeyMapping;
import emulator.Settings;
import emulator.graphics2D.CopyUtils;
import emulator.graphics2D.swt.FontSWT;
import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.ListSWT;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.SWTFrontend;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTScreen {
    Composite swtContent;
    private Rectangle swtContentArea;
    private boolean swtInitialized;
    static KeyListener swtKeyListener = new SwtKeyListener();

    static void syncExec(Runnable r) {
        SWTFrontend.syncExec(r);
    }

    static void safeSyncExec(Runnable r) {
        try {
            SWTFrontend.syncExec(r);
        }
        catch (SWTException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    static Composite getSwtParent() {
        return ((EmulatorScreen)Emulator.getEmulator().getScreen()).getCanvas();
    }

    Composite _constructSwtContent(int style) {
        Composite c2 = new Composite(SWTScreen.getSwtParent(), 0);
        this._setSwtStyle((Control)c2);
        return c2;
    }

    void constructSwt() {
        SWTScreen.syncExec(new Runnable(){

            @Override
            public void run() {
                SWTScreen.this.swtContent = SWTScreen.this._constructSwtContent(0);
                SWTScreen.this.swtContent.setVisible(false);
                SWTScreen.this.swtContentArea = SWTScreen.this._layoutSwtContent();
            }
        });
    }

    Rectangle _layoutSwtContent() {
        Rectangle area = SWTScreen.getSwtParent().getClientArea();
        this.swtContent.setBounds(0, 0, area.width, area.height);
        return this.swtContent.getClientArea();
    }

    public Composite getSwtContent() {
        return this.swtContent;
    }

    public void swtHidden() {
    }

    public void swtShown() {
        if (this.swtContent != null && !this.swtContent.isDisposed()) {
            this.swtUpdateSizes();
        }
    }

    public void swtUpdateSizes() {
        Rectangle newArea = this._layoutSwtContent();
        if (this.swtContentArea == null || !this.swtInitialized || newArea.width != this.swtContentArea.width || newArea.height != this.swtContentArea.height) {
            this.swtInitialized = true;
            this.swtContentArea = newArea;
            this.swtResized(newArea.width, newArea.height);
        }
    }

    public void swtResized(int w, int h2) {
        if (this instanceof ListSWT) {
            return;
        }
        this.swtContent.setFont(SWTScreen.getDefaultSWTFont(true));
    }

    void _setSwtStyle(Control c2) {
        int color = LCDUIUtils.backgroundColor;
        c2.setBackground(new Color(null, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF));
        color = LCDUIUtils.foregroundColor;
        c2.setForeground(new Color(null, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF));
        c2.setFont(SWTScreen.getDefaultSWTFont(!(this instanceof ListSWT)));
    }

    static org.eclipse.swt.graphics.Font getSWTFont(Font font, boolean autoScale) {
        if (font == null) {
            return null;
        }
        if (Settings.g2d == 0) {
            return ((FontSWT)font.getImpl()).getSWTFont();
        }
        float zoom = (autoScale ? ((EmulatorScreen)Emulator.getEmulator().getScreen()).getZoom() : 1.0f) * 0.68f;
        return new org.eclipse.swt.graphics.Font((Device)SWTFrontend.getDisplay(), Emulator.getEmulator().getProperty().getDefaultFontName(), Math.max(2, (int)((float)font.getHeight() * zoom) - 1), font.getStyle() & 0xFFFFFFFB);
    }

    static org.eclipse.swt.graphics.Font getDefaultSWTFont(boolean autoScale) {
        float zoom = (autoScale ? ((EmulatorScreen)Emulator.getEmulator().getScreen()).getZoom() : 1.0f) * 0.68f;
        return new org.eclipse.swt.graphics.Font((Device)SWTFrontend.getDisplay(), Emulator.getEmulator().getProperty().getDefaultFontName(), Math.max(2, (int)((float)Font.getDefaultFont().getHeight() * zoom) - 1), 0);
    }

    public int getWidth() {
        return this.swtContentArea.width;
    }

    public int getHeight() {
        return this.swtContentArea.height;
    }

    protected void finalize() {
        SWTScreen.syncExec(() -> {
            if (this.swtContent != null && !this.swtContent.isDisposed()) {
                this.swtContent.dispose();
            }
        });
    }

    static org.eclipse.swt.graphics.Image getSWTImage(Image img) {
        if (img == null) {
            return null;
        }
        if (Settings.g2d == 0) {
            return (org.eclipse.swt.graphics.Image)img.getImpl().getNative();
        }
        BufferedImage b2 = (BufferedImage)img.getImpl().getNative();
        return new org.eclipse.swt.graphics.Image((Device)SWTFrontend.getDisplay(), CopyUtils.toSwt(b2));
    }

    static class SwtKeyListener
    implements KeyListener {
        SwtKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            String r;
            if (keyEvent.keyCode == 0x1000014 || keyEvent.keyCode == 16777261 || keyEvent.keyCode == 16777259) {
                ((EmulatorScreen)Emulator.getEmulator().getScreen()).keyPressed(keyEvent);
                return;
            }
            int n = keyEvent.keyCode & 0xFEFFFFFF;
            Displayable d = Emulator.getCurrentDisplay().getCurrent();
            if (keyEvent.character >= '!' && keyEvent.character <= 'Z' || (r = KeyMapping.replaceKey(n)) == null) {
                return;
            }
            n = Integer.parseInt(r);
            if (KeyMapping.isLeftSoft(n) || KeyMapping.isRightSoft(n)) {
                d.handleSoftKeyAction(n, true);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

