/*
 * Decompiled with CFR 0.152.
 */
package emulator.lcdui;

import emulator.lcdui.ITextBoxImpl;
import emulator.lcdui.SWTScreen;
import emulator.lcdui.TextWrapper;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextBoxSWT
extends SWTScreen
implements ITextBoxImpl {
    private SwtModifyListener swtModifyListener = new SwtModifyListener();
    private TextWrapper textWrapper;
    private int numLines;

    public TextBoxSWT(TextBox textBox, String title, String text, int maxSize, int constraints) {
        this.textWrapper = new TextWrapper(text, maxSize, constraints);
        this.constructSwt();
    }

    @Override
    protected Composite _constructSwtContent(int style) {
        Composite c2 = super._constructSwtContent(style);
        this.textWrapper.swtConstruct(c2, 512);
        this.textWrapper.swtSetFont(TextBoxSWT.getDefaultSWTFont(true));
        return c2;
    }

    @Override
    public void swtShown() {
        super.swtShown();
        this.textWrapper.setModifyListener(this.swtModifyListener);
        this.textWrapper.addKeyListener(swtKeyListener);
        this.textWrapper.setFocused(true);
    }

    @Override
    public void swtHidden() {
        super.swtHidden();
        this.textWrapper.setModifyListener(null);
        this.textWrapper.removeKeyListener(swtKeyListener);
    }

    @Override
    public void swtResized(int w, int h2) {
        super.swtResized(w, h2);
        this.textWrapper.swtSetFont(TextBoxSWT.getDefaultSWTFont(false));
        this.textWrapper.setBounds(this.swtContent.getClientArea());
    }

    @Override
    public int getCaretPosition() {
        return this.textWrapper.getCaretPosition();
    }

    @Override
    public String getString() {
        return this.textWrapper.getContent();
    }

    @Override
    public void setString(String newText) {
        this.textWrapper.setContent(newText);
    }

    @Override
    public int getChars(char[] charData) {
        if (charData == null) {
            throw new NullPointerException();
        }
        if (charData.length < this.getString().length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String content = this.textWrapper.getContent();
        content.getChars(0, content.length(), charData, 0);
        return content.length();
    }

    @Override
    public void setChars(char[] charData, int offset, int length) {
        String extractedString = null;
        if (charData != null) {
            try {
                extractedString = new String(charData, offset, length);
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        this.textWrapper.setContent(extractedString);
    }

    @Override
    public void insert(String text, int position) {
        this.textWrapper.insert(text, position);
    }

    public void insert(char[] charData, int offset, int length, int position) {
        if (charData == null) {
            throw new NullPointerException();
        }
        String extractedString = null;
        try {
            extractedString = new String(charData, offset, length);
        }
        catch (IndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.textWrapper.insert(extractedString, position);
    }

    @Override
    public void delete(int offset, int length) {
        this.textWrapper.delete(offset, length);
    }

    @Override
    public int getMaxSize() {
        return this.textWrapper.getMaxSize();
    }

    @Override
    public int setMaxSize(int newMaxSize) {
        this.textWrapper.setMaxSize(newMaxSize);
        return this.textWrapper.getMaxSize();
    }

    @Override
    public int size() {
        return this.textWrapper.getSize();
    }

    @Override
    public void setConstraints(int newConstraints) {
        this.textWrapper.setConstraints(newConstraints);
        if (!TextWrapper.isValidText(this.getString(), TextWrapper.getTypeConstraint(newConstraints))) {
            this.setString("");
        }
    }

    @Override
    public int getConstraints() {
        return this.textWrapper.getConstraints();
    }

    @Override
    public void setInitialInputMode(String inputMode) {
        this.textWrapper.setInputMode(inputMode);
    }

    @Override
    public void layout() {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    @Override
    public void defocus() {
    }

    @Override
    public void focusCaret() {
    }

    @Override
    public boolean isSWT() {
        return true;
    }

    class SwtModifyListener
    implements ModifyListener {
        SwtModifyListener() {
        }

        public void modifyText(ModifyEvent me) {
            int lines = TextWrapper.swtGetLineCount((Control)me.widget);
            if (TextBoxSWT.this.numLines != lines) {
                TextBoxSWT.this.numLines = lines;
            }
        }
    }
}

