/*
 * Decompiled with CFR 0.152.
 */
package emulator.lcdui;

import emulator.lcdui.SWTScreen;
import emulator.lcdui.TextBoxLayouter;
import emulator.ui.swt.SWTFrontend;
import javax.microedition.lcdui.Font;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

class TextWrapper {
    private String text;
    private String inputMode;
    private int constraints;
    private int caret;
    private int size;
    private int maxSize;
    private Control control;
    private int style;
    private int width = -1;
    private int height = -1;
    private int x = -1;
    private int y = -1;
    private Color fgCol;
    private Color bgCol;
    private boolean visible = true;
    private boolean focused = true;
    private Font font;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;
    private String retSelectedStr;
    private int retLineHeight;
    private int retLineCount;
    private int retTopPixel;

    TextWrapper(String aText, int aMaxSize, int aConstraints) {
        this.setMaxSize(aMaxSize);
        this.setConstraints(aConstraints);
        this.setContent(aText);
    }

    void construct(final Composite parent, final int addStyle) {
        SWTScreen.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                TextWrapper.this.swtConstruct(parent, addStyle);
            }
        });
    }

    void swtConstruct(Composite parent, int addStyle) {
        this.style = addStyle | 2 | 0x40 | 0x800;
        if (parent != null) {
            this.swtStoreStateAndDispose();
            this.swtRestoreStateAndCreate(parent);
        }
    }

    void swtSetFont(org.eclipse.swt.graphics.Font font) {
        if (this.control == null) {
            return;
        }
        this.control.setFont(font);
    }

    void delete(int offset, int length) {
        if (offset + length > this.getSize()) {
            throw new StringIndexOutOfBoundsException();
        }
        StringBuffer sb = new StringBuffer(this.getContent());
        sb.delete(offset, offset + length);
        this.setContent(sb.toString());
    }

    void dispose() {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.swtStoreStateAndDispose();
                }
            });
        }
    }

    int getCaretPosition() {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.caret = TextWrapper.swtGetCaretPosition(TextWrapper.this.control);
                }
            });
        }
        return this.caret;
    }

    int getConstraints() {
        return this.constraints;
    }

    String getContent() {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.text = TextWrapper.swtGetContent(TextWrapper.this.control);
                }
            });
        }
        return this.text;
    }

    int getHeight() {
        return this.height;
    }

    String getInputMode() {
        return this.inputMode;
    }

    int getLineCount() {
        this.retLineCount = 1;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.retLineCount = TextWrapper.swtGetLineCount(TextWrapper.this.control);
                }
            });
        }
        return this.retLineCount;
    }

    int getLineHeight() {
        this.retLineHeight = 1;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.retLineHeight = TextWrapper.swtGetLineHeight(TextWrapper.this.control);
                }
            });
        }
        return this.retLineHeight;
    }

    int getMaxSize() {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.maxSize = TextWrapper.swtGetMaxSize(TextWrapper.this.control);
                }
            });
        }
        return this.maxSize;
    }

    int getPreferredHeight(int maxVisibleLines) {
        return Math.min(Math.max(1, this.getLineCount()), maxVisibleLines) * this.getLineHeight();
    }

    String getSelectedContent() {
        this.retSelectedStr = "";
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.retSelectedStr = TextWrapper.swtGetSelectedContent(TextWrapper.this.control);
                }
            });
        }
        return this.retSelectedStr;
    }

    int getSize() {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.size = TextWrapper.swtGetSize(TextWrapper.this.control);
                }
            });
        }
        return this.size;
    }

    int getTopPixelPosition() {
        this.retTopPixel = 0;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TextWrapper.this.control instanceof Text) {
                        TextWrapper.this.retTopPixel = ((Text)TextWrapper.this.control).getTopPixel();
                    }
                }
            });
        }
        return this.retTopPixel;
    }

    int getWidth() {
        return this.width;
    }

    void insert(String aText, int aPosition) {
        if (aText == null) {
            throw new NullPointerException();
        }
        StringBuffer sb = new StringBuffer(this.getContent());
        if (aPosition < 0) {
            sb.insert(0, aText);
        } else if (aPosition > sb.length()) {
            sb.append(aText);
        } else {
            sb.insert(aPosition, aText);
        }
        this.setContent(sb.toString());
    }

    void setBackgroundColor(int alpha, final int red, final int green, final int blue) {
        SWTScreen.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                if (TextWrapper.this.bgCol != null) {
                    TextWrapper.this.bgCol.dispose();
                    TextWrapper.this.bgCol = null;
                }
                TextWrapper.this.bgCol = new Color((Device)SWTFrontend.getDisplay(), red, green, blue);
            }
        });
    }

    void setBounds(Rectangle aBounds) {
        if (aBounds.width < 0 || aBounds.height < 0) {
            throw new IllegalArgumentException();
        }
        this.x = aBounds.x;
        this.y = aBounds.y;
        this.width = aBounds.width;
        this.height = aBounds.height;
        if (this.control != null && this.width >= 0 && this.height >= 0) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.control.setBounds(TextWrapper.this.x, TextWrapper.this.y, TextWrapper.this.width, TextWrapper.this.height);
                }
            });
        }
    }

    void setCaretposition(int aPosition) {
        this.caret = aPosition;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetSelection(TextWrapper.this.control, TextWrapper.this.caret, TextWrapper.this.caret);
                }
            });
        }
    }

    void setConstraints(int aConstraints) {
        if (!TextWrapper.isValidConstraints(aConstraints)) {
            throw new IllegalArgumentException();
        }
        this.constraints = aConstraints;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.swtRestoreStateAndCreate(TextWrapper.this.swtStoreStateAndDispose());
                }
            });
        }
    }

    void setContent(String aText) {
        if (aText == null) {
            this.text = "";
        } else {
            if (aText.length() > this.maxSize) {
                throw new IllegalArgumentException();
            }
            if (!TextWrapper.isValidText(aText, this.constraints)) {
                throw new IllegalArgumentException();
            }
            this.text = aText;
        }
        this.size = this.text.length();
        this.caret = this.text.length();
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetContent(TextWrapper.this.control, TextWrapper.this.text);
                    TextWrapper.swtSetSelection(TextWrapper.this.control, TextWrapper.this.caret, TextWrapper.this.caret);
                }
            });
        }
    }

    void setFont(Font aFont) {
        this.font = aFont;
    }

    void setFocused(boolean aFocused) {
        this.focused = aFocused;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetFocused(TextWrapper.this.control, TextWrapper.this.focused);
                }
            });
        }
    }

    void setForegroundColor(int alpha, final int red, final int green, final int blue) {
        SWTScreen.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                if (TextWrapper.this.fgCol != null) {
                    TextWrapper.this.fgCol.dispose();
                    TextWrapper.this.fgCol = null;
                }
                TextWrapper.this.fgCol = new Color((Device)SWTFrontend.getDisplay(), red, green, blue);
            }
        });
    }

    void setInputMode(String aInputMode) {
        this.inputMode = aInputMode;
        if (this.control != null && this.control instanceof Text) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetInputMode(TextWrapper.this.control, TextWrapper.this.inputMode, TextWrapper.this.constraints);
                }
            });
        }
    }

    void setMaxSize(int aMaxSize) {
        if (aMaxSize < 1) {
            throw new IllegalArgumentException();
        }
        String content = this.getContent();
        if (content != null && aMaxSize < content.length()) {
            this.setContent(content.substring(0, aMaxSize));
        }
        this.maxSize = aMaxSize;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetMaxSize(TextWrapper.this.control, TextWrapper.this.maxSize);
                }
            });
        }
    }

    void setModifyListener(final ModifyListener aListener) {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtRemoveModListener(TextWrapper.this.control, TextWrapper.this.modifyListener);
                    TextWrapper.swtAddModListener(TextWrapper.this.control, aListener);
                }
            });
        }
        this.modifyListener = aListener;
    }

    void setSelectionListener(final SelectionListener aListener) {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtRemoveSelListener(TextWrapper.this.control, TextWrapper.this.selectionListener);
                    TextWrapper.swtAddSelListener(TextWrapper.this.control, aListener);
                }
            });
        }
        this.selectionListener = aListener;
    }

    void setPosition(int aX, int aY) {
        this.x = aX;
        this.y = aY;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.control.setLocation(TextWrapper.this.x, TextWrapper.this.y);
                }
            });
        }
    }

    void setSelection(final int sta, final int end) {
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.swtSetSelection(TextWrapper.this.control, sta, end);
                }
            });
        }
    }

    void setSize(int aWidth, int aHeight) {
        if (aWidth < 0 || aHeight < 0) {
            throw new IllegalArgumentException();
        }
        this.width = aWidth;
        this.height = aHeight;
        if (this.control != null && this.width >= 0 && this.height >= 0) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.control.setSize(TextWrapper.this.width, TextWrapper.this.height);
                }
            });
        }
    }

    void setVisible(boolean aVisible) {
        this.visible = aVisible;
        if (this.control != null) {
            SWTScreen.safeSyncExec(new Runnable(){

                @Override
                public void run() {
                    TextWrapper.this.control.setVisible(TextWrapper.this.visible);
                }
            });
        }
    }

    private void swtRestoreStateAndCreate(Composite parent) {
        if (this.control == null) {
            this.control = TextWrapper.swtConstructText(parent, this.style, this.constraints);
            TextWrapper.swtSetInputMode(this.control, this.inputMode, this.constraints);
            TextWrapper.swtSetMaxSize(this.control, this.maxSize);
            TextWrapper.swtSetContent(this.control, this.text);
            TextWrapper.swtSetSelection(this.control, this.caret, this.caret);
            if (this.width >= 0 && this.height >= 0) {
                this.control.setBounds(this.x, this.y, this.width, this.height);
            }
            if (this.fgCol != null) {
                this.control.setForeground(this.fgCol);
            }
            if (this.bgCol != null) {
                this.control.setBackground(this.bgCol);
            }
            if (this.font != null) {
                // empty if block
            }
            this.control.setVisible(this.visible);
            TextWrapper.swtSetFocused(this.control, this.focused);
            TextWrapper.swtAddModListener(this.control, this.modifyListener);
            TextWrapper.swtAddSelListener(this.control, this.selectionListener);
        }
    }

    private Composite swtStoreStateAndDispose() {
        Composite parent = null;
        if (this.control != null) {
            parent = this.control.getParent();
            this.text = TextWrapper.swtGetContent(this.control);
            this.caret = TextWrapper.swtGetCaretPosition(this.control);
            TextWrapper.swtRemoveModListener(this.control, this.modifyListener);
            TextWrapper.swtRemoveSelListener(this.control, this.selectionListener);
            this.control.dispose();
            this.control = null;
        }
        return parent;
    }

    void addKeyListener(KeyListener l) {
        if (this.control == null) {
            return;
        }
        this.control.addKeyListener(l);
    }

    void removeKeyListener(KeyListener l) {
        if (this.control == null) {
            return;
        }
        this.control.removeKeyListener(l);
    }

    static void swtAddModListener(Control control, ModifyListener ltnr) {
        if (control != null && ltnr != null && control instanceof Text) {
            ((Text)control).addModifyListener(ltnr);
        }
    }

    static void swtAddSelListener(Control control, SelectionListener ltnr) {
        if (control != null && ltnr != null && control instanceof Text) {
            ((Text)control).addSelectionListener(ltnr);
        }
    }

    static Control swtConstructText(Composite parent, int aStyle, int aConstraints) {
        int style = aStyle;
        int extractedFlag = aConstraints & 0xFFFF0000;
        int extractedConstraint = aConstraints & 0xFFFF;
        if ((extractedFlag & 0x10000) == 65536) {
            style &= 0xFFFFFFFD;
            style |= 0x400004;
        }
        if ((extractedFlag & 0x20000) == 131072) {
            style |= 8;
        }
        return new Text(parent, style);
    }

    static int swtGetCaretPosition(Control control) {
        int ret = 0;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getCaretPosition();
        }
        return ret;
    }

    static int swtGetCaretLine(Control control) {
        int ret = 0;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getCaretLineNumber();
        }
        return ret;
    }

    static String swtGetContent(Control control) {
        String ret = "";
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getText();
        }
        return ret;
    }

    static int swtGetLineCount(Control control) {
        int ret = 1;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getLineCount();
        }
        return ret;
    }

    static int swtGetLineHeight(Control control) {
        int ret = 0;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getLineHeight();
        }
        return ret;
    }

    static int swtGetMaxSize(Control control) {
        int ret = 0;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getTextLimit();
        }
        return ret;
    }

    static String swtGetSelectedContent(Control control) {
        String ret = "";
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getSelectionText();
        }
        return ret;
    }

    static int swtGetSize(Control control) {
        int ret = 0;
        if (control != null && control instanceof Text) {
            ret = ((Text)control).getCharCount();
        }
        return ret;
    }

    static void swtRemoveModListener(Control control, ModifyListener ltnr) {
        if (control != null && ltnr != null && control instanceof Text) {
            ((Text)control).removeModifyListener(ltnr);
        }
    }

    static void swtRemoveSelListener(Control control, SelectionListener ltnr) {
        if (control != null && ltnr != null && control instanceof Text) {
            ((Text)control).removeSelectionListener(ltnr);
        }
    }

    static void swtSetContent(Control control, String text) {
        if (control != null && control instanceof Text) {
            ((Text)control).setText(text);
        }
    }

    static void swtSetFocused(Control control, boolean focus) {
        if (control != null) {
            if (focus) {
                control.setFocus();
            } else {
                control.getParent().forceFocus();
            }
        }
    }

    static void swtSetInputMode(Control control, String inputMode, int aConstraints) {
    }

    static void swtSetMaxSize(Control control, int maxSize) {
        if (control != null && control instanceof Text) {
            ((Text)control).setTextLimit(maxSize);
        }
    }

    static void swtSetSelection(Control control, int sta, int end) {
        if (control != null && control instanceof Text) {
            ((Text)control).setSelection(sta, end);
        }
    }

    static void swtUpdateVScrollbar(Control control) {
        Text te;
        ScrollBar sb;
        if (control != null && (control.getStyle() & 0x200) == 512 && control instanceof Text && (sb = (te = (Text)control).getVerticalBar()) != null) {
            int height = te.getLineCount() * te.getLineHeight();
            sb.setVisible(te.getSize().y < height);
        }
    }

    static int getCapitalize(int aConstraints) {
        int ret = 0;
        return ret;
    }

    static boolean isUrlEmailSet(int aConstraints) {
        int extractedConstraint = aConstraints & 0xFFFF;
        return extractedConstraint == 1 || extractedConstraint == 4;
    }

    static boolean isValidConstraints(int aConstraints) {
        int extractedFlag;
        int smallestFlag = 65535;
        int highestFlag = 4128769;
        int typeConstraint = TextWrapper.getTypeConstraint(aConstraints);
        return (typeConstraint == 0 || typeConstraint == 1 || typeConstraint == 2 || typeConstraint == 3 || typeConstraint == 5 || typeConstraint == 4) && ((extractedFlag = aConstraints & 0xFFFF0000) == 0 || extractedFlag > smallestFlag && extractedFlag < highestFlag);
    }

    static int getTypeConstraint(int aConstraints) {
        return aConstraints & 0xFFFF;
    }

    static boolean isValidText(String aText, int aConstraints) {
        return TextBoxLayouter.checkText(aConstraints, aText);
    }
}

