/*
 * Decompiled with CFR 0.152.
 */
package emulator.media;

import emulator.Settings;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerImpl;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

public class EmulatorMIDI {
    public static Player currentPlayer;
    private static MidiDevice.Info[] deviceInfo;
    private static Sequencer sequencer;
    private static Synthesizer synthesizer;
    private static MidiDevice device;
    private static Receiver receiver;

    public static boolean useExternalReceiver() {
        return Settings.searchVms && receiver != null && synthesizer == null;
    }

    public static void initDevices() {
        if (deviceInfo != null) {
            return;
        }
        deviceInfo = MidiSystem.getMidiDeviceInfo();
    }

    public static void initDevice() throws MidiUnavailableException {
        EmulatorMIDI.initDevice(false);
    }

    public static void initDevice(boolean noVms) throws MidiUnavailableException {
        if (receiver == null && Settings.searchVms && !noVms) {
            for (MidiDevice.Info info : deviceInfo) {
                if (!info.getName().toLowerCase().contains("virtualmidisynth")) continue;
                device = MidiSystem.getMidiDevice(info);
                device.open();
                receiver = device.getReceiver();
                break;
            }
        }
        if (receiver == null) {
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            receiver = synthesizer.getReceiver();
        }
        if (sequencer == null) {
            sequencer = MidiSystem.getSequencer(false);
            EmulatorMIDI.setReceiver(sequencer, receiver);
            sequencer.open();
            sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage meta) {
                    if (meta.getType() == 47 && currentPlayer instanceof PlayerImpl) {
                        ((PlayerImpl)currentPlayer).notifyCompleted();
                    }
                }
            });
        }
    }

    public static void setSequence(Sequence sequence) throws InvalidMidiDataException, MidiUnavailableException {
        EmulatorMIDI.initDevice();
        sequencer.setSequence(sequence);
    }

    public static void start(PlayerImpl player, Sequence sequence, long position) throws InvalidMidiDataException, MidiUnavailableException {
        EmulatorMIDI.initDevice();
        sequencer.setSequence(sequence);
        sequencer.setMicrosecondPosition(position);
        sequencer.start();
    }

    public static void startTone(Sequence sequence, long position) throws InvalidMidiDataException, MidiUnavailableException {
        EmulatorMIDI.initDevice(true);
        sequencer.setSequence(sequence);
        sequencer.setMicrosecondPosition(position);
        sequencer.start();
    }

    public static void stop() {
        sequencer.stop();
    }

    public static void close(boolean force) {
        if (Settings.reopenMidiDevice || force) {
            if (sequencer != null) {
                sequencer.close();
                sequencer = null;
            }
            if (receiver != null) {
                receiver.close();
                receiver = null;
            }
            if (device != null) {
                device.close();
                device = null;
            }
            if (synthesizer != null) {
                synthesizer.close();
                synthesizer = null;
            }
        }
    }

    public static void setMicrosecondPosition(long ms) throws MidiUnavailableException {
        EmulatorMIDI.initDevice();
        sequencer.setMicrosecondPosition(ms);
    }

    public static long getMicrosecondPosition() throws MidiUnavailableException {
        EmulatorMIDI.initDevice();
        return sequencer.getMicrosecondPosition();
    }

    public static void setMIDIChannelVolume(int n, int n2) {
        try {
            Receiver r = EmulatorMIDI.getMidiReceiver();
            ShortMessage shortMessage = new ShortMessage(176, n, 7, n2);
            r.send(shortMessage, -1L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void shortMidiEvent(int type, int data1, int data2) {
        try {
            Receiver r = EmulatorMIDI.getMidiReceiver();
            ShortMessage shortMessage = new ShortMessage(type, data1, data2);
            r.send(shortMessage, -1L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int longMidiEvent(byte[] data, int offset, int length) {
        byte[] b2 = new byte[length];
        System.arraycopy(data, offset, b2, 0, length);
        try {
            Receiver r = EmulatorMIDI.getMidiReceiver();
            MidiMessage msg = new MidiMessage(b2){

                @Override
                public Object clone() {
                    return null;
                }
            };
            r.send(msg, -1L);
            return length;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    private static Receiver getMidiReceiver() throws MidiUnavailableException {
        EmulatorMIDI.initDevice();
        return receiver;
    }

    public static void setupSequencer(Sequencer sequencer) throws MidiUnavailableException {
        if (!Settings.searchVms) {
            return;
        }
        EmulatorMIDI.initDevice();
        EmulatorMIDI.setReceiver(sequencer, receiver);
    }

    private static void setReceiver(Sequencer sequencer, Receiver receiver) throws MidiUnavailableException {
        if (sequencer.isOpen()) {
            for (Transmitter t : sequencer.getTransmitters()) {
                t.setReceiver(receiver);
            }
            return;
        }
        sequencer.getTransmitter().setReceiver(receiver);
    }
}

