/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.amr;

import emulator.media.amr.AMRDecoderJni;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AMRDecoder {
    private static final int[] FRAME_SIZES = new int[]{12, 13, 15, 17, 19, 20, 26, 31, 5, 0, 0, 0, 0, 0, 0, 0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(byte[] amrData) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(amrData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] header = new byte[6];
        if (in.read(header) != 6 || header[0] != 35 || header[1] != 33 || header[2] != 65 || header[3] != 77 || header[4] != 82 || header[5] != 10) {
            in = new ByteArrayInputStream(amrData);
        }
        long decoderState = AMRDecoderJni.initDecoder();
        if (decoderState == 0L) {
            throw new IOException("Failed to initialize AMR decoder");
        }
        try {
            byte[] frame = new byte[32];
            short[] pcmFrame = new short[160];
            while (in.available() > 0) {
                int toc = in.read();
                if (toc == -1) {
                    break;
                }
                int frameType = toc >> 3 & 0xF;
                int frameSize = FRAME_SIZES[frameType];
                if (frameSize <= 0) continue;
                int read = in.read(frame, 0, frameSize);
                if (read != frameSize) {
                    break;
                }
                byte[] fullFrame = new byte[frameSize + 1];
                fullFrame[0] = (byte)toc;
                System.arraycopy(frame, 0, fullFrame, 1, frameSize);
                AMRDecoderJni.decodeFrame(decoderState, fullFrame, pcmFrame);
                for (short sample : pcmFrame) {
                    out.write(sample & 0xFF);
                    out.write(sample >> 8 & 0xFF);
                }
            }
        }
        finally {
            AMRDecoderJni.closeDecoder(decoderState);
        }
        return out.toByteArray();
    }
}

