/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.capture;

import com.github.sarxos.webcam.Webcam;
import emulator.Emulator;
import emulator.Permission;
import emulator.graphics2D.awt.AWTImageUtils;
import emulator.graphics2D.awt.ImageAWT;
import emulator.media.capture.CameraControlImpl;
import emulator.media.capture.CameraVideoControlImpl;
import emulator.media.capture.CaptureItem;
import emulator.media.capture.FlashControlImpl;
import emulator.media.capture.FocusControlImpl;
import emulator.media.vlc.VLCPlayerImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.microedition.amms.control.camera.CameraControl;
import javax.microedition.amms.control.camera.FlashControl;
import javax.microedition.amms.control.camera.FocusControl;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.VideoControl;

public class CapturePlayerImpl
implements Player {
    public static CapturePlayerImpl inst;
    private VideoControl videoControl;
    private Webcam webcam = Webcam.getDefault();
    public boolean visible;
    public Object canvas;
    public boolean started;
    private int locy;
    private int locx;
    private int scalew;
    private int scaleh;
    private boolean isItem;
    private CaptureItem item;
    private FocusControl focusControl;
    private FlashControl flashControl;
    private CameraControl cameraControl;
    private int state = 100;

    public CapturePlayerImpl() throws MediaException {
        if (this.webcam == null) {
            throw new MediaException("No capture devices found!");
        }
        this.videoControl = new CameraVideoControlImpl(this);
        this.focusControl = new FocusControlImpl();
        this.flashControl = new FlashControlImpl();
        this.cameraControl = new CameraControlImpl();
        this.scaleh = Math.max(this.webcam.getViewSize().height, Emulator.getEmulator().getScreen().getHeight());
    }

    @Override
    public Control getControl(String s) {
        if (s.contains("VideoControl") || s.contains("GUIControl")) {
            return this.videoControl;
        }
        if (s.contains("FocusControl")) {
            return this.focusControl;
        }
        if (s.contains("FlashControl")) {
            return this.flashControl;
        }
        if (s.contains("CameraControl")) {
            return this.cameraControl;
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return new Control[]{this.videoControl, this.focusControl, this.flashControl, this.cameraControl};
    }

    @Override
    public void addPlayerListener(PlayerListener p0) throws IllegalStateException {
    }

    @Override
    public void close() {
        if (this.state == 0) {
            return;
        }
        this.state = 0;
        this.started = false;
        this.webcam.close();
        inst = null;
    }

    @Override
    public void deallocate() throws IllegalStateException {
        inst = null;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public long getMediaTime() {
        return -1L;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void prefetch() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        this.state = 300;
    }

    @Override
    public void realize() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        this.state = 200;
        inst = this;
    }

    @Override
    public void removePlayerListener(PlayerListener p0) throws IllegalStateException {
    }

    @Override
    public void setLoopCount(int p0) {
    }

    @Override
    public long setMediaTime(long p0) {
        return 0L;
    }

    @Override
    public void start() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (inst != this) {
            this.realize();
        }
        Permission.checkPermission("media.camera");
        this.webcam.open();
        this.started = true;
        this.state = 400;
    }

    @Override
    public void stop() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        this.started = false;
        this.state = 300;
    }

    @Override
    public void setTimeBase(TimeBase p0) throws MediaException {
    }

    @Override
    public TimeBase getTimeBase() {
        return null;
    }

    public void setVisible(boolean p0) {
        this.visible = p0;
    }

    public void setDisplaySize(int p0, int p1) {
        this.scalew = p0;
        this.scaleh = p1;
        if (this.item != null) {
            this.item.w = p0;
            this.item.h = p1;
        }
    }

    public void setDisplayLocation(int p0, int p1) {
        this.locx = p0;
        this.locy = p1;
    }

    public Object initDisplayMode(int p0, Object p1) {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (p0 == 0) {
            this.isItem = true;
            return this.getItem();
        }
        this.canvas = p1;
        return null;
    }

    private Item getItem() {
        if (this.item != null) {
            return this.item;
        }
        this.item = new CaptureItem(this);
        return this.item;
    }

    public byte[] getSnapshot(String p0) throws MediaException {
        if (!this.started) {
            throw new MediaException("Not visible");
        }
        int w = 0;
        int h2 = 0;
        try {
            if (p0 != null) {
                String[] ar;
                for (String s : ar = p0.split("&")) {
                    if (s.startsWith("width=")) {
                        w = Integer.parseInt(s.replace("width=", ""));
                        continue;
                    }
                    if (!s.startsWith("height=")) continue;
                    h2 = Integer.parseInt(s.replace("height=", ""));
                }
            }
        }
        catch (Exception ar) {
            // empty catch block
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedImage img = this.webcam.getImage();
            if (w > 0 && h2 > 0) {
                img = AWTImageUtils.resize(img, w, h2);
            }
            ImageIO.write((RenderedImage)img, "JPEG", os);
            byte[] bytes = os.toByteArray();
            os.close();
            return bytes;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new MediaException(e2);
        }
    }

    public void setDisplayFullScreen(boolean p0) {
    }

    public int getSourceHeight() {
        return this.webcam.getViewSize().height;
    }

    public int getSourceWidth() {
        return this.webcam.getViewSize().width;
    }

    public void paint(Graphics g) {
        if (this.visible && this.started) {
            try {
                g.drawImage(new Image(new ImageAWT(AWTImageUtils.resize(this.webcam.getImage(), -1, this.scaleh))), this.locx, this.locy, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g, int w, int h2) {
        if (this.started) {
            try {
                g.drawImage(new Image(new ImageAWT(AWTImageUtils.resize(this.webcam.getImage(), -1, h2))), 0, 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void draw(Graphics g, Object obj) {
        if (inst != null) {
            if (!(CapturePlayerImpl.inst.canvas != null && obj != CapturePlayerImpl.inst.canvas || CapturePlayerImpl.inst.isItem)) {
                inst.paint(g);
            }
        } else {
            VLCPlayerImpl.draw(g, obj);
        }
    }
}

