/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.ott;

public final class MidiBuilder {
    public int note;
    public int durationType;
    public int noteType;
    public int octave;
    public int tempo;
    public int volume;
    public int trackLengthOffset;
    public int trackCountOffset;
    private static int currentOffset;
    private byte[] midiData = new byte[100];

    public MidiBuilder() {
        currentOffset = 0;
    }

    public byte[] getMIDIData() {
        return this.midiData;
    }

    public void initTrack() {
        this.writeInt(1297377380, 4);
        this.writeInt(6, 4);
        this.writeInt(1, 2);
        this.trackCountOffset = currentOffset;
        this.writeInt(1, 2);
        this.writeInt(240, 2);
        this.writeInt(1297379947, 4);
        this.trackLengthOffset = currentOffset;
        this.writeInt(0, 4);
        this.writeVariableLengthQuantity(0);
        this.writeInt(192, 1);
        this.writeInt(80, 1);
        this.setTempo();
    }

    public void addNote() {
        int baseDuration = (int)(240.0f * (4.0f / (float)(1 << this.durationType)));
        int totalDuration = this.calculateNoteDuration(baseDuration);
        int midiNote = this.note == 0 ? 0 : 60 + (this.note - 1) + this.octave * 12;
        int midiVolume = this.note == 0 ? 0 : Math.min(255, (int)(255.0f * ((float)this.volume / 14.0f)));
        this.writeVariableLengthQuantity(0);
        this.writeInt(144, 1);
        this.writeInt(midiNote, 1);
        this.writeInt(255, 1);
        this.writeVariableLengthQuantity(totalDuration);
        this.writeInt(128, 1);
        this.writeInt(midiNote, 1);
        this.writeInt(midiVolume, 1);
    }

    public void setTempo() {
        this.writeVariableLengthQuantity(0);
        this.writeInt(255, 1);
        this.writeInt(81, 1);
        this.writeInt(3, 1);
        int microsecondsPerQuarter = this.tempo == 0 ? 240000 : 60000000 / this.tempo;
        this.writeInt(microsecondsPerQuarter >> 16 & 0xFF, 1);
        this.writeInt(microsecondsPerQuarter >> 8 & 0xFF, 1);
        this.writeInt(microsecondsPerQuarter & 0xFF, 1);
    }

    public void finishTrack() {
        this.writeVariableLengthQuantity(0);
        this.writeInt(255, 1);
        this.writeInt(47, 1);
        this.writeInt(0, 1);
        int finalOffset = currentOffset;
        currentOffset = this.trackLengthOffset;
        this.writeInt(finalOffset - this.trackLengthOffset - 4, 4);
        this.resizeBuffer(finalOffset);
        this.copyTrackData(this.trackLengthOffset - 4, finalOffset, 10);
    }

    private int calculateNoteDuration(int baseDuration) {
        switch (this.noteType) {
            case 1: {
                return baseDuration + baseDuration / 2;
            }
            case 2: {
                return baseDuration + baseDuration / 2 + baseDuration / 4;
            }
        }
        return baseDuration;
    }

    private void writeInt(int value, int bytes) {
        this.ensureCapacity(bytes);
        for (int i2 = bytes - 1; i2 >= 0; --i2) {
            this.midiData[MidiBuilder.currentOffset++] = (byte)(value >> i2 * 8 & 0xFF);
        }
    }

    private void writeVariableLengthQuantity(int value) {
        int buffer = value & 0x7F;
        while ((value >>= 7) > 0) {
            buffer <<= 8;
            buffer |= value & 0x7F | 0x80;
        }
        while (true) {
            this.writeInt(buffer & 0xFF, 1);
            if ((buffer & 0x80) == 0) break;
            buffer >>= 8;
        }
    }

    private void ensureCapacity(int additionalBytes) {
        if (currentOffset + additionalBytes >= this.midiData.length) {
            int newSize = this.midiData.length + Math.max(additionalBytes, 100);
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(this.midiData, 0, newBuffer, 0, this.midiData.length);
            this.midiData = newBuffer;
        }
    }

    private void resizeBuffer(int newSize) {
        if (newSize != this.midiData.length) {
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(this.midiData, 0, newBuffer, 0, Math.min(newSize, this.midiData.length));
            this.midiData = newBuffer;
        }
        currentOffset = newSize;
    }

    private void copyTrackData(int start, int end, int repetitions) {
        int length = end - start;
        int bufferEnd = this.midiData.length;
        for (int i2 = 0; i2 < repetitions; ++i2) {
            this.resizeBuffer(bufferEnd + length);
            System.arraycopy(this.midiData, start, this.midiData, bufferEnd, length);
            bufferEnd = this.midiData.length;
        }
        int savedOffset = currentOffset;
        currentOffset = this.trackCountOffset;
        this.writeInt(repetitions + 1, 2);
        currentOffset = savedOffset;
    }
}

