/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.ott;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class NokiaOTTDecoder {
    public static final int NATURAL_STYLE = 0;
    public static final int CONTINUOUS_STYLE = 1;
    public static final int STACCATO_STYLE = 2;
    private static final double SEMITONE_CONST = 17.31234049066755;
    private static int parsePos = 0;
    private static boolean[] toneBitArray;
    private static float noteScale;
    private static int noteStyle;
    private static int curTick;
    private static final String[] noteStrings;

    public static int convertFreqToNote(int freq) {
        return (int)Math.round(Math.log((double)freq / 8.176) * 17.31234049066755);
    }

    public static synchronized byte[] convertToMidi(byte[] data) throws MidiUnavailableException, IOException {
        try {
            parsePos = 0;
            noteScale = 1.0f;
            noteStyle = 0;
            curTick = 0;
            toneBitArray = new boolean[data.length * 8];
            for (int i2 = 0; i2 < data.length; ++i2) {
                for (int j = 0; j < 8; ++j) {
                    NokiaOTTDecoder.toneBitArray[i2 * 8 + j] = (data[i2] & 1 << 7 - j) != 0;
                }
            }
            Sequence sequence = new Sequence(0.0f, 24);
            Track track = sequence.createTrack();
            ShortMessage bankMSB = new ShortMessage();
            ShortMessage bankLSB = new ShortMessage();
            ShortMessage programChange = new ShortMessage();
            bankMSB.setMessage(176, 0, 0, 1);
            bankLSB.setMessage(176, 0, 32, 0);
            programChange.setMessage(192, 0, 80, 0);
            track.add(new MidiEvent(bankMSB, 0L));
            track.add(new MidiEvent(bankLSB, 1L));
            track.add(new MidiEvent(programChange, 0L));
            int commandLength = NokiaOTTDecoder.readBits(8);
            block13: for (int i3 = 0; i3 < commandLength && toneBitArray.length - parsePos - 8 > 0; ++i3) {
                int commandType = NokiaOTTDecoder.readBits(8);
                switch (commandType) {
                    case 74: {
                        NokiaOTTDecoder.parseRingingTone(track);
                        continue block13;
                    }
                    case 68: {
                        NokiaOTTDecoder.parseUnicode();
                        continue block13;
                    }
                    case 58: {
                        NokiaOTTDecoder.parseSound(track);
                        continue block13;
                    }
                    case 10: {
                        continue block13;
                    }
                    case 0: {
                        continue block13;
                    }
                }
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                MidiSystem.write(sequence, 0, output);
                return output.toByteArray();
            }
            catch (IOException e2) {
                return null;
            }
        }
        catch (InvalidMidiDataException e3) {
            return null;
        }
    }

    private static void parseRingingTone(Track track) {
        int nextCheck = NokiaOTTDecoder.readBits(7);
        if (nextCheck == 29) {
            NokiaOTTDecoder.parseSound(track);
        } else if (nextCheck == 34) {
            NokiaOTTDecoder.parseUnicode();
        }
    }

    private static void parseUnicode() {
    }

    private static void parseSound(Track track) {
        int songType = NokiaOTTDecoder.readBits(3);
        switch (songType) {
            case 1: {
                NokiaOTTDecoder.parseBasicSong(track);
                break;
            }
            case 2: {
                NokiaOTTDecoder.parseTemporarySong(track);
                break;
            }
            case 3: {
                NokiaOTTDecoder.parseMidiSong(track);
                break;
            }
            case 4: {
                NokiaOTTDecoder.parseDigitizedSong(track);
                break;
            }
            case 5: {
                NokiaOTTDecoder.parsePolyphonicSong(track);
                break;
            }
        }
    }

    private static void parseBasicSong(Track track) {
        int titleLength = NokiaOTTDecoder.readBits(4);
        StringBuilder title = new StringBuilder();
        for (int i2 = 0; i2 < titleLength; ++i2) {
            char character = (char)NokiaOTTDecoder.readBits(8);
            title.append(character);
        }
        int songSequenceLength = NokiaOTTDecoder.readBits(8);
        for (int i3 = 0; i3 < songSequenceLength; ++i3) {
            NokiaOTTDecoder.parseSongPattern(track);
        }
    }

    private static void parseTemporarySong(Track track) {
        int songSequenceLength = NokiaOTTDecoder.readBits(8);
        for (int i2 = 0; i2 < songSequenceLength; ++i2) {
            NokiaOTTDecoder.parseSongPattern(track);
        }
    }

    private static void parseMidiSong(Track track) {
    }

    private static void parseDigitizedSong(Track track) {
    }

    private static void parsePolyphonicSong(Track track) {
    }

    private static void parseSongPattern(Track track) {
        int patternHeader = NokiaOTTDecoder.readBits(3);
        int patternId = NokiaOTTDecoder.readBits(2);
        int loopValue = NokiaOTTDecoder.readBits(4);
        if (loopValue == 15) {
            loopValue = 0;
        }
        int loopParsePosMark = parsePos;
        while (loopValue >= 0) {
            parsePos = loopParsePosMark;
            int patternSpecifier = NokiaOTTDecoder.readBits(8);
            if (patternSpecifier != 0) {
                int numberOfInstructions = patternSpecifier;
                noteStyle = 0;
                noteScale = 1.0f;
                for (int j = 0; j < numberOfInstructions; ++j) {
                    NokiaOTTDecoder.parsePatternInstruction(track);
                }
            }
            --loopValue;
        }
    }

    private static void parsePatternInstruction(Track track) {
        int instructionType = NokiaOTTDecoder.readBits(3);
        switch (instructionType) {
            case 0: {
                parsePos -= 3;
                return;
            }
            case 1: {
                NokiaOTTDecoder.parseNoteInstruction(track);
                break;
            }
            case 2: {
                NokiaOTTDecoder.parseScaleInstruction();
                break;
            }
            case 3: {
                NokiaOTTDecoder.parseStyleInstruction();
                break;
            }
            case 4: {
                NokiaOTTDecoder.parseTempoInstruction(track);
                break;
            }
            case 5: {
                NokiaOTTDecoder.parseVolumeInstruction(track);
                break;
            }
        }
    }

    private static void parseNoteInstruction(Track track) {
        int noteValue = NokiaOTTDecoder.readBits(4);
        int noteDuration = NokiaOTTDecoder.readBits(3);
        int durationSpecifier = NokiaOTTDecoder.readBits(2);
        int midiNote = NokiaOTTDecoder.convertNoteValueToMidi(noteValue);
        int ticks = NokiaOTTDecoder.convertDurationToTicks(noteDuration, durationSpecifier);
        try {
            if (midiNote != -1) {
                if (noteStyle == 2) {
                    ShortMessage noteOn = new ShortMessage();
                    noteOn.setMessage(144, 0, midiNote, 93);
                    track.add(new MidiEvent(noteOn, curTick));
                    ShortMessage noteOff = new ShortMessage();
                    noteOff.setMessage(128, 0, midiNote, 0);
                    track.add(new MidiEvent(noteOff, curTick + (int)((float)ticks * 0.7f)));
                } else if (noteStyle == 1) {
                    ShortMessage noteOn = new ShortMessage();
                    noteOn.setMessage(144, 0, midiNote, 93);
                    track.add(new MidiEvent(noteOn, curTick));
                    ShortMessage noteOff = new ShortMessage();
                    noteOff.setMessage(128, 0, midiNote, 0);
                    track.add(new MidiEvent(noteOff, curTick + (int)((float)ticks * 1.1f)));
                } else {
                    ShortMessage noteOn = new ShortMessage();
                    noteOn.setMessage(144, 0, midiNote, 93);
                    track.add(new MidiEvent(noteOn, curTick));
                    ShortMessage noteOff = new ShortMessage();
                    noteOff.setMessage(128, 0, midiNote, 0);
                    track.add(new MidiEvent(noteOff, curTick + ticks));
                }
            }
            curTick += ticks;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private static void parseScaleInstruction() {
        int scaleValue = NokiaOTTDecoder.readBits(2);
        switch (scaleValue) {
            case 0: {
                noteScale = 0.5f;
                break;
            }
            case 1: {
                noteScale = 1.0f;
                break;
            }
            case 2: {
                noteScale = 2.0f;
                break;
            }
            case 3: {
                noteScale = 4.0f;
                break;
            }
        }
    }

    private static void parseStyleInstruction() {
        int styleValue = NokiaOTTDecoder.readBits(2);
        switch (styleValue) {
            case 0: {
                noteStyle = 0;
                break;
            }
            case 1: {
                noteStyle = 1;
                break;
            }
            case 2: {
                noteStyle = 2;
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private static void parseTempoInstruction(Track track) {
        int bpmValue = NokiaOTTDecoder.readBits(5);
        int bpm = 0;
        switch (bpmValue) {
            case 0: {
                bpm = 25;
                break;
            }
            case 1: {
                bpm = 28;
                break;
            }
            case 2: {
                bpm = 31;
                break;
            }
            case 3: {
                bpm = 35;
                break;
            }
            case 4: {
                bpm = 40;
                break;
            }
            case 5: {
                bpm = 45;
                break;
            }
            case 6: {
                bpm = 50;
                break;
            }
            case 7: {
                bpm = 56;
                break;
            }
            case 8: {
                bpm = 63;
                break;
            }
            case 9: {
                bpm = 70;
                break;
            }
            case 10: {
                bpm = 80;
                break;
            }
            case 11: {
                bpm = 90;
                break;
            }
            case 12: {
                bpm = 100;
                break;
            }
            case 13: {
                bpm = 112;
                break;
            }
            case 14: {
                bpm = 125;
                break;
            }
            case 15: {
                bpm = 140;
                break;
            }
            case 16: {
                bpm = 160;
                break;
            }
            case 17: {
                bpm = 180;
                break;
            }
            case 18: {
                bpm = 200;
                break;
            }
            case 19: {
                bpm = 225;
                break;
            }
            case 20: {
                bpm = 250;
                break;
            }
            case 21: {
                bpm = 285;
                break;
            }
            case 22: {
                bpm = 320;
                break;
            }
            case 23: {
                bpm = 355;
                break;
            }
            case 24: {
                bpm = 400;
                break;
            }
            case 25: {
                bpm = 450;
                break;
            }
            case 26: {
                bpm = 500;
                break;
            }
            case 27: {
                bpm = 565;
                break;
            }
            case 28: {
                bpm = 635;
                break;
            }
            case 29: {
                bpm = 715;
                break;
            }
            case 30: {
                bpm = 800;
                break;
            }
            case 31: {
                bpm = 900;
                break;
            }
        }
        int microsecondsPerBeat = 60000000 / bpm;
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(81, new byte[]{(byte)(microsecondsPerBeat >> 16), (byte)(microsecondsPerBeat >> 8), (byte)microsecondsPerBeat}, 3);
            track.add(new MidiEvent(metaMessage, curTick));
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private static void parseVolumeInstruction(Track track) {
        int volumeValue = NokiaOTTDecoder.readBits(4);
        int midiVolume = 0;
        switch (volumeValue) {
            case 0: {
                midiVolume = 0;
                break;
            }
            case 1: {
                midiVolume = 48;
                break;
            }
            case 2: {
                midiVolume = 56;
                break;
            }
            case 3: {
                midiVolume = 64;
                break;
            }
            case 4: {
                midiVolume = 72;
                break;
            }
            case 5: {
                midiVolume = 80;
                break;
            }
            case 6: {
                midiVolume = 88;
                break;
            }
            case 7: {
                midiVolume = 92;
                break;
            }
            case 8: {
                midiVolume = 100;
                break;
            }
            case 9: {
                midiVolume = 104;
                break;
            }
            case 10: {
                midiVolume = 108;
                break;
            }
            case 11: {
                midiVolume = 112;
                break;
            }
            case 12: {
                midiVolume = 116;
                break;
            }
            case 13: {
                midiVolume = 120;
                break;
            }
            case 14: {
                midiVolume = 124;
                break;
            }
            default: {
                midiVolume = 127;
            }
        }
        try {
            ShortMessage volumeEvent = new ShortMessage();
            volumeEvent.setMessage(176, 0, 7, midiVolume);
            track.add(new MidiEvent(volumeEvent, curTick));
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private static int convertNoteValueToMidi(int noteValue) {
        int baseFrequency = 0;
        switch (noteValue) {
            case 0: {
                return -1;
            }
            case 1: {
                baseFrequency = 523;
                break;
            }
            case 2: {
                baseFrequency = 554;
                break;
            }
            case 3: {
                baseFrequency = 587;
                break;
            }
            case 4: {
                baseFrequency = 622;
                break;
            }
            case 5: {
                baseFrequency = 659;
                break;
            }
            case 6: {
                baseFrequency = 698;
                break;
            }
            case 7: {
                baseFrequency = 740;
                break;
            }
            case 8: {
                baseFrequency = 784;
                break;
            }
            case 9: {
                baseFrequency = 831;
                break;
            }
            case 10: {
                baseFrequency = 880;
                break;
            }
            case 11: {
                baseFrequency = 932;
                break;
            }
            case 12: {
                baseFrequency = 988;
                break;
            }
            default: {
                return -1;
            }
        }
        int noteFromFreq = NokiaOTTDecoder.convertFreqToNote((int)((float)baseFrequency * noteScale));
        return noteFromFreq;
    }

    private static int convertDurationToTicks(int noteDuration, int durationSpecifier) {
        int baseTicks = 24;
        switch (noteDuration) {
            case 0: {
                baseTicks *= 4;
                break;
            }
            case 1: {
                baseTicks *= 2;
                break;
            }
            case 3: {
                baseTicks /= 2;
                break;
            }
            case 4: {
                baseTicks /= 4;
                break;
            }
            case 5: {
                baseTicks /= 8;
                break;
            }
        }
        switch (durationSpecifier) {
            case 1: {
                baseTicks = (int)((double)baseTicks * 1.5);
                break;
            }
            case 2: {
                baseTicks = (int)((double)baseTicks * 1.75);
                break;
            }
            case 3: {
                baseTicks = (int)((double)baseTicks * 0.6666666666666666);
                break;
            }
        }
        return baseTicks;
    }

    private static int readBits(int numBits) {
        int value = 0;
        for (int i2 = 0; i2 < numBits; ++i2) {
            value <<= 1;
            value |= toneBitArray[parsePos++] ? 1 : 0;
        }
        return value;
    }

    static {
        noteScale = 1.0f;
        noteStyle = 0;
        curTick = 0;
        noteStrings = new String[]{"Pause", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H", "Reserved", "Reserved", "Reserved"};
    }
}

