/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.ott;

import emulator.Emulator;
import emulator.media.ott.MidiBuilder;

public final class RingtoneParser {
    private MidiBuilder midiBuilder = new MidiBuilder();
    private int dataLength;
    private byte[] dataBuffer;
    private static int bitIndex;
    private static int bitOffset;
    private static final int[] noteDurations;

    public RingtoneParser(byte[] inputData) {
        this.dataLength = inputData.length;
        this.dataBuffer = new byte[this.dataLength + 10];
        System.arraycopy(inputData, 0, this.dataBuffer, 0, this.dataLength);
        this.parse(this.dataBuffer);
    }

    public byte[] getMIDIData() {
        return this.midiBuilder.getMIDIData();
    }

    private static int readBits(byte[] array, int n) {
        int value = ((array[bitIndex] & 0xFF) << 8 | array[bitIndex + 1] & 0xFF) >> 16 - (n + bitOffset) & (1 << n) - 1;
        if ((bitOffset += n) > 7) {
            bitOffset -= 8;
            ++bitIndex;
        }
        return value;
    }

    private static int getTempoValue(int index) {
        return noteDurations[index];
    }

    private void parse(byte[] array) {
        bitIndex = 0;
        bitOffset = 0;
        boolean trackInitialized = false;
        RingtoneParser.readBits(array, 8);
        RingtoneParser.readBits(array, 8);
        RingtoneParser.readBits(array, 7);
        int ringtoneType = RingtoneParser.readBits(array, 3);
        if (ringtoneType != 1 && ringtoneType != 2) {
            Emulator.getEmulator().getLogStream().println("Unsupported ringtone type");
            return;
        }
        int initialCount = RingtoneParser.readBits(array, 4);
        for (int i2 = 0; i2 < initialCount; ++i2) {
            RingtoneParser.readBits(array, 8);
        }
        for (int loopCounter = RingtoneParser.readBits(array, 8); bitIndex < this.dataLength && loopCounter > 0; --loopCounter) {
            RingtoneParser.readBits(array, 3);
            RingtoneParser.readBits(array, 2);
            RingtoneParser.readBits(array, 4);
            int notesCount = RingtoneParser.readBits(array, 8);
            block10: for (int i3 = 0; i3 < notesCount && bitIndex < this.dataLength; ++i3) {
                int command = RingtoneParser.readBits(array, 3);
                switch (command) {
                    case 0: {
                        RingtoneParser.readBits(array, 2);
                        continue block10;
                    }
                    case 1: {
                        if (!trackInitialized) {
                            this.midiBuilder.initTrack();
                            trackInitialized = true;
                        }
                        this.midiBuilder.note = RingtoneParser.readBits(array, 4);
                        this.midiBuilder.durationType = RingtoneParser.readBits(array, 3);
                        this.midiBuilder.noteType = RingtoneParser.readBits(array, 2);
                        this.midiBuilder.addNote();
                        continue block10;
                    }
                    case 2: {
                        this.midiBuilder.octave = RingtoneParser.readBits(array, 2);
                        if (this.midiBuilder.octave <= 0) continue block10;
                        --this.midiBuilder.octave;
                        continue block10;
                    }
                    case 3: {
                        RingtoneParser.readBits(array, 2);
                        continue block10;
                    }
                    case 4: {
                        this.midiBuilder.tempo = RingtoneParser.getTempoValue(RingtoneParser.readBits(array, 5));
                        this.midiBuilder.tempo *= 4;
                        if (!trackInitialized) continue block10;
                        this.midiBuilder.setTempo();
                        continue block10;
                    }
                    case 5: {
                        this.midiBuilder.volume = RingtoneParser.readBits(array, 4);
                    }
                }
            }
        }
        this.midiBuilder.finishTrack();
    }

    static {
        noteDurations = new int[]{25, 28, 31, 35, 40, 45, 50, 56, 63, 70, 80, 90, 100, 112, 125, 140, 160, 180, 200, 225, 250, 285, 320, 355, 400, 450, 500, 565, 635, 715, 800, 900};
    }
}

