/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;

public class BlockEndEvent
extends Event {
    BlockEndEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) throws MidiSequenceException, IllegalArgumentException {
        int retVal = this.doValidate(position);
        if (retVal == 0) {
            return 0;
        }
        if (returnPositionStack.empty()) {
            throw new IllegalArgumentException("Illegal BLOCK_END");
        }
        int lastPos = (Integer)returnPositionStack.pop();
        retVal = lastPos - position;
        return retVal;
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        int retVal = 0;
        if (type == -6) {
            this.leaveBlock(data);
            retVal = 2;
        }
        return retVal;
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Validation failed, invalid position found in sequence");
        }
        if (type >= -1 || type == -5 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found; sequence is corrupted");
    }
}

