/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;

public class BlockStartEvent
extends Event {
    BlockStartEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) throws MidiSequenceException, IllegalArgumentException {
        return this.doValidate(position);
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        int retVal = 0;
        if (type == -5) {
            if (data > 127 || data < 0) {
                throw new IllegalArgumentException("Illegal sequence, block number not in range, valid range is 0 <= tempo <= 127");
            }
            this.enterBlock(data);
            retVal = 2;
        }
        return retVal;
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Validation failed, invalid position found in sequence");
        }
        if (type >= -1 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found; sequence is corrupted");
    }
}

