/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;
import java.util.Stack;

public abstract class Event {
    public static final byte EVENT_SIZE = 2;
    private static final String TAG = Event.class.getName();
    protected byte[] sequence;
    protected MidiSequence midiSequence;
    protected static Stack<Integer> returnPositionStack = new Stack();
    private static Stack<Integer> currentBlockNumStack = new Stack();

    protected Event(byte[] sequence, MidiSequence midiSequence) {
        this.sequence = sequence;
        this.midiSequence = midiSequence;
    }

    public void reset() {
        if (!returnPositionStack.empty()) {
            returnPositionStack = new Stack();
        }
        if (!currentBlockNumStack.isEmpty()) {
            currentBlockNumStack = new Stack();
        }
    }

    public abstract int advance(int var1) throws MidiSequenceException, IllegalArgumentException;

    protected abstract int doValidate(int var1) throws IllegalArgumentException;

    public int validate(int position) throws IllegalArgumentException {
        int nextPos = 0;
        try {
            nextPos = this.doValidate(position);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.err.println(TAG + ": MMA: Event: validate: AIOOBE");
            return nextPos;
        }
        if (nextPos < 0) {
            throw new Error();
        }
        if (nextPos != 0) {
            this.checkEventAtNextPosition(position + nextPos);
        }
        return nextPos;
    }

    protected abstract void checkEventAtNextPosition(int var1) throws IllegalArgumentException;

    protected void enterBlock(int blockNum) {
        currentBlockNumStack.push(blockNum);
    }

    protected void leaveBlock(int blockNum) throws IllegalArgumentException {
        if (currentBlockNumStack.isEmpty()) {
            System.err.println(TAG + ": MMA: Event: leaveBlock: Not inside block, IAE");
            throw new IllegalArgumentException("Illegal Sequence, invalid block number found");
        }
        if (blockNum != currentBlockNumStack.pop()) {
            System.err.println(TAG + ": MMA: Event: leaveBlock: Incorrect block number, IAE");
            throw new IllegalArgumentException("Illegal Sequence, invalid block number found");
        }
    }
}

