/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.BlockEndEvent;
import emulator.media.tone.BlockStartEvent;
import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;
import emulator.media.tone.PlayBlockEvent;
import emulator.media.tone.RepeatEvent;
import emulator.media.tone.ToneEvent;
import emulator.media.tone.VolumeEvent;
import java.util.Enumeration;
import java.util.Vector;

public class EventList
extends Event {
    private static final int EVENT_PROCESSOR_COUNT = 6;
    private final Vector<Event> events = new Vector(6);

    EventList(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
        this.events.addElement(new ToneEvent(sequence, midiSequence));
        this.events.addElement(new BlockStartEvent(sequence, midiSequence));
        this.events.addElement(new BlockEndEvent(sequence, midiSequence));
        this.events.addElement(new PlayBlockEvent(sequence, midiSequence));
        this.events.addElement(new RepeatEvent(sequence, midiSequence));
        this.events.addElement(new VolumeEvent(sequence, midiSequence));
    }

    @Override
    public int advance(int position) throws MidiSequenceException {
        if (this.sequence.length - position < 2) {
            return 0;
        }
        Event event = null;
        int retVal = 0;
        Enumeration<Event> e2 = this.events.elements();
        while (e2.hasMoreElements()) {
            event = e2.nextElement();
            retVal = event.advance(position);
            if (retVal == 0) continue;
            return retVal;
        }
        throw new IllegalArgumentException("Illegal event found, sequence is corrupted");
    }

    @Override
    public int validate(int position) throws IllegalArgumentException {
        Event event = null;
        int retVal = 0;
        Enumeration<Event> e2 = this.events.elements();
        while (e2.hasMoreElements()) {
            event = e2.nextElement();
            retVal = event.validate(position);
            if (retVal == 0) continue;
            return retVal;
        }
        throw new IllegalArgumentException("Illegal event found, sequence is corrupted");
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        throw new Error("Illegal validation call");
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        throw new Error("Illegal validation call");
    }
}

