/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.EmulatorMIDI;
import emulator.media.tone.ToneControlImpl;
import emulator.media.tone.ToneSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControlImpl;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;

public class MIDITonePlayer
implements Player,
ToneControl,
Runnable {
    Control toneControl = new ToneControlImpl(this);
    Control volumeControl = new VolumeControlImpl(this);
    Control[] controls = new Control[]{this.toneControl, this.volumeControl};
    private int state = 100;
    private byte[] midiSequence;
    private long duration;
    private Sequence sequence;
    private static int count;

    public MIDITonePlayer() {
    }

    public MIDITonePlayer(InputStream stream) {
        this();
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            this.midiSequence = buffer.toByteArray();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public long doGetDuration() {
        return this.duration;
    }

    @Override
    public void setSequence(byte[] sequence) {
        try {
            ToneSequence tone = new ToneSequence(sequence);
            tone.process();
            this.midiSequence = tone.getByteArray();
            this.duration = tone.getDuration();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            this.sequence = MidiSystem.getSequence(new ByteArrayInputStream(this.midiSequence));
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void addPlayerListener(PlayerListener playerListener) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void close() {
        if (this.state == 0) {
            return;
        }
        if (this.state == 400) {
            EmulatorMIDI.stop();
        }
        this.state = 0;
    }

    @Override
    public void deallocate() throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 400) {
            EmulatorMIDI.stop();
        }
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getMediaTime() {
        return 0L;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void prefetch() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state < 300) {
            this.state = 300;
        }
    }

    @Override
    public void realize() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state < 200) {
            this.state = 200;
        }
    }

    @Override
    public void removePlayerListener(PlayerListener playerListener) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setLoopCount(int n) {
    }

    @Override
    public long setMediaTime(long n) throws MediaException {
        return 0L;
    }

    @Override
    public void start() throws IllegalStateException, MediaException {
        if (this.state == 0 || this.sequence == null) {
            throw new IllegalStateException();
        }
        this.state = 400;
        new Thread((Runnable)this, "TonePlayer-" + ++count).start();
    }

    @Override
    public void stop() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 400) {
            EmulatorMIDI.stop();
        }
        this.state = 300;
    }

    @Override
    public Control getControl(String s) {
        if (s.equals("VolumeControl")) {
            return this.volumeControl;
        }
        if (s.equals("ToneControl")) {
            return this.toneControl;
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return this.controls;
    }

    @Override
    public TimeBase getTimeBase() {
        return null;
    }

    @Override
    public void setTimeBase(TimeBase timeBase) throws MediaException {
    }

    @Override
    public void run() {
        try {
            EmulatorMIDI.startTone(this.sequence, 0L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

