/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.MidiSequenceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MidiSequence {
    private static final int MINUTE_AS_MICROSECONDS = 60000000;
    private static final int MIDI_EVENTS_TRACK_GRANULARITY = 100;
    public static final byte MIDI_SILENCE_NOTE = 0;
    private static final int MIDI_EVENTS_MAX_BYTE_COUNT = 32768;
    private static final byte FILE_HEADER_LENGTH = 14;
    private static final byte MTRK_HEADER_LENGTH = 8;
    private static final int TRACK_HEADER_LENGTH = 10;
    private static final int TRACK_TRAILER_LENGTH = 4;
    private static final byte[] MIDI_HEADER_MTHD = new byte[]{77, 84, 104, 100};
    private static final byte[] MIDI_HEADER_MTHD_LENGTH = new byte[]{0, 0, 0, 6};
    private static final byte[] MIDI_HEADER_MIDI_FORMAT = new byte[]{0, 0};
    private static final byte[] MIDI_HEADER_MTRK_CHUNK_AMOUNT = new byte[]{0, 1};
    private static final byte MIDI_HEADER_PPQN_FIRST_BYTE = 0;
    private static final byte[] MIDI_HEADER_MTRK = new byte[]{77, 84, 114, 107};
    private static final byte[] TRACK_HEADER_TEMPO_CHANGE = new byte[]{0, -1, 81, 3};
    private static final byte[] TRACK_TRAILER = new byte[]{0, -1, 47, 0};
    private static final int MIDI_EVENT_COMMAND_LENGTH = 3;
    private static final byte MIDI_EVENT_CHANNEL_MASK = -16;
    private static final int MIDI_VARIABLE_LENGTH_MAX_VALUE = 0xFFFFFFF;
    private static final byte TONE_DEFAULT_RESOLUTION = 64;
    private static final byte TONE_DEFAULT_TEMPO = 30;
    private static final byte TONE_MULTIPLIER = 1;
    private byte iChannel;
    private int iTempo;
    private int iResolution;
    private byte iInstrument;
    private int iMidiEventsByteCount;
    private ByteArrayOutputStream iMidiTrackEvents;
    private int iDuration;

    MidiSequence(byte aChannel, byte aInstrument) {
        this.iChannel = aChannel;
        this.iInstrument = aInstrument;
        this.iTempo = 30;
        this.iResolution = 64;
        this.iMidiTrackEvents = new ByteArrayOutputStream(100);
    }

    public ByteArrayInputStream getStream() throws IOException {
        this.iMidiTrackEvents.flush();
        byte[] midiTrackEvents = this.iMidiTrackEvents.toByteArray();
        ByteArrayOutputStream concateStream = new ByteArrayOutputStream(32 + midiTrackEvents.length + 4);
        this.writeHeader(concateStream, midiTrackEvents.length);
        concateStream.write(midiTrackEvents);
        this.writeTrailer(concateStream);
        ByteArrayInputStream midi = new ByteArrayInputStream(concateStream.toByteArray());
        concateStream.close();
        return midi;
    }

    public byte[] getByteArray() throws IOException {
        this.iMidiTrackEvents.flush();
        byte[] midiTrackEvents = this.iMidiTrackEvents.toByteArray();
        ByteArrayOutputStream concateStream = new ByteArrayOutputStream(32 + midiTrackEvents.length + 4);
        this.writeHeader(concateStream, midiTrackEvents.length);
        concateStream.write(midiTrackEvents);
        this.writeTrailer(concateStream);
        byte[] midi = concateStream.toByteArray();
        concateStream.close();
        return midi;
    }

    public void setTempo(int aTempo) {
        if (aTempo < 5 || aTempo > 127) {
            throw new IllegalArgumentException("Tempo is out of range, valid range is 5 <= tempo <= 127");
        }
        this.iTempo = aTempo * 1;
    }

    public void setResolution(int aResolution) {
        if (aResolution < 1 || aResolution > 127) {
            throw new IllegalArgumentException("Resolution is out of range, valid range is 1 <= resolution <= 127");
        }
        this.iResolution = aResolution / 1;
    }

    public void writeMidiEvent(int aLength, byte aCommand, byte aEvent, byte aData) throws MidiSequenceException {
        if (this.iMidiEventsByteCount > 32768) {
            throw new MidiSequenceException();
        }
        this.iMidiEventsByteCount += this.writeVarLen(this.iMidiTrackEvents, aLength);
        if (aCommand == -128) {
            this.iDuration += aLength;
        }
        aCommand = (byte)(aCommand & 0xFFFFFFF0);
        aCommand = (byte)(aCommand | this.iChannel);
        this.iMidiTrackEvents.write(aCommand);
        this.iMidiTrackEvents.write(aEvent);
        this.iMidiTrackEvents.write(aData);
        this.iMidiEventsByteCount += 3;
    }

    private int writeVarLen(ByteArrayOutputStream aOut, int aValue) {
        if (aValue > 0xFFFFFFF || aValue < 0) {
            throw new IllegalArgumentException("Input(time) value is not within range");
        }
        int byteCount = 0;
        int buffer = aValue & 0x7F;
        aValue >>= 7;
        while (aValue != 0) {
            buffer <<= 8;
            buffer |= aValue & 0x7F | 0x80;
            aValue >>= 7;
        }
        while (true) {
            aOut.write(buffer);
            ++byteCount;
            int tempBuf = buffer & 0x80;
            if (tempBuf == 0) break;
            buffer >>= 8;
        }
        return byteCount;
    }

    private void writeHeader(ByteArrayOutputStream aOut, int aMidiEventsLength) throws IOException {
        aOut.write(MIDI_HEADER_MTHD);
        aOut.write(MIDI_HEADER_MTHD_LENGTH);
        aOut.write(MIDI_HEADER_MIDI_FORMAT);
        aOut.write(MIDI_HEADER_MTRK_CHUNK_AMOUNT);
        aOut.write(0);
        aOut.write(this.iResolution);
        aOut.write(MIDI_HEADER_MTRK);
        int trackLength = 10 + aMidiEventsLength + 4;
        aOut.write(trackLength >> 24 & 0xFF);
        aOut.write(trackLength >> 16 & 0xFF);
        aOut.write(trackLength >> 8 & 0xFF);
        aOut.write(trackLength & 0xFF);
        aOut.write(TRACK_HEADER_TEMPO_CHANGE);
        int mpqn = 60000000 / this.iTempo;
        aOut.write(mpqn >> 16 & 0xFF);
        aOut.write(mpqn >> 8 & 0xFF);
        aOut.write(mpqn & 0xFF);
        this.writeVarLen(aOut, 0);
        aOut.write((byte)(0xFFFFFFC0 | this.iChannel));
        aOut.write(this.iInstrument);
    }

    private void writeTrailer(ByteArrayOutputStream aOut) throws IOException {
        aOut.write(TRACK_TRAILER);
    }

    public long getCumulativeDuration() {
        long duration = (long)this.iDuration * 60L * 1000000L / (long)(this.iResolution * this.iTempo);
        return duration;
    }
}

