/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;

public class PlayBlockEvent
extends Event {
    public static final int PLAY_BLOCK_MAX_VALUE = 127;
    public static final int PLAY_BLOCK_MIN_VALUE = 0;

    PlayBlockEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) {
        int retVal = this.doValidate(position);
        if (retVal != 0) {
            returnPositionStack.push(position + 2);
            byte data = this.sequence[position + 1];
            retVal = this.findBlock(data) - position;
        }
        return retVal;
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        int retVal = 0;
        if (type == -7) {
            if (data < 0 || data > 127) {
                throw new IllegalArgumentException("Block number out of range");
            }
            this.findBlock(data);
            retVal = 2;
        }
        return retVal;
    }

    private int findBlock(int blockNumber) {
        for (int i2 = 0; i2 < this.sequence.length; i2 += 2) {
            if (this.sequence[i2] != -5 || this.sequence[i2 + 1] != blockNumber) continue;
            return i2;
        }
        throw new IllegalArgumentException("No block found, sequence is corrupted");
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return;
        }
        if (type >= -1 || type == -6 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found, sequence is corrupted");
    }
}

