/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;
import emulator.media.tone.ToneEvent;

public class RepeatEvent
extends Event {
    public static final int REPEAT_MIN_MULTIPLIER = 2;
    public static final int REPEAT_MAX_MULTIPLIER = 127;

    RepeatEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) throws MidiSequenceException {
        byte type = this.sequence[position];
        int data = this.sequence[position + 1];
        int retVal = this.doValidate(position);
        if (retVal == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < data; ++i2) {
            retVal = ToneEvent.staticAdvance(position + 2, this.sequence, this.midiSequence);
            if (retVal == 0) {
                throw new IllegalArgumentException("Illegal sequence, processing events for playing failed");
            }
            retVal = 4;
        }
        return retVal;
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        int retVal = 0;
        if (type == -9) {
            if (data < 2 || data > 127) {
                throw new IllegalArgumentException("Repeat multiplier out of range, valid range is 2 <= multiplier <= 127");
            }
            if (this.sequence.length - (position + 2) < 2) {
                throw new IllegalArgumentException("Illegal ToneControl.REPEAT event, there should be two more bytes available after REPEAT event");
            }
            retVal = 4;
        }
        return retVal;
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return;
        }
        if (type >= -1 || type == -6 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found; sequence is corrupted");
    }
}

