/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;

public class ToneEvent
extends Event {
    ToneEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) throws MidiSequenceException {
        return ToneEvent.staticAdvance(position, this.sequence, this.midiSequence);
    }

    public static int staticAdvance(int position, byte[] toneSequence, MidiSequence midiSequence) throws MidiSequenceException {
        int retVal = ToneEvent.doStaticValidate(position, toneSequence);
        if (retVal == 0) {
            return 0;
        }
        byte type = toneSequence[position];
        byte data = toneSequence[position + 1];
        if (type == -1) {
            retVal = ToneEvent.processToneEvent(type, data, true, midiSequence);
        } else if (type >= 0 && type <= 127) {
            retVal = ToneEvent.processToneEvent(type, data, false, midiSequence);
        }
        return retVal;
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        return ToneEvent.doStaticValidate(position, this.sequence);
    }

    private static int doStaticValidate(int position, byte[] toneSequence) {
        byte type = toneSequence[position];
        byte data = toneSequence[position + 1];
        int retVal = 0;
        if (type >= -1 && type <= 127) {
            if (data < 1 || data > 127) {
                throw new IllegalArgumentException("Note duration out of range, valid range is 1 <= duration <=127");
            }
            retVal = 2;
        }
        return retVal;
    }

    private static int processToneEvent(byte type, byte data, boolean silent, MidiSequence midiSequence) throws MidiSequenceException {
        byte firstMidiEventType = -112;
        if (silent) {
            firstMidiEventType = -128;
        }
        midiSequence.writeMidiEvent(0, firstMidiEventType, type, (byte)127);
        midiSequence.writeMidiEvent(data, (byte)-128, type, (byte)127);
        return 2;
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return;
        }
        if (type >= -1 || type == -6 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found; sequence is corrupted");
    }
}

