/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import java.io.IOException;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class ToneManager {
    private static final String TONE_SEQUENCE_CONTENT_TYPE = "audio/x-tone-seq";
    private static final int TONE_SEQUENCE_VERSION = 1;
    private static final int TONE_SEQUENCE_RESOLUTION = 64;
    private static final int TONE_SEQUENCE_TEMPO = 30;
    private static final int DURATION_DIVIDE = 240000;
    private static final String CANNOT_PLAY_TONE = "Cannot play tone";

    public static void play(int note, int duration, int volume) throws MediaException {
        Player p = ToneManager.createPlayer(note, duration, volume);
        try {
            p.start();
        }
        catch (MediaException me) {
            p.close();
            throw me;
        }
    }

    public static Player createPlayer(int note, int duration, int volume) throws MediaException {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        if (note > 127 || note < 0) {
            throw new IllegalArgumentException("Note is out of range, valid range is 0 <= Note <= 127");
        }
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        int curDuration = duration * 64 * 30 / 240000;
        if (curDuration < 1) {
            curDuration = 1;
        } else if (curDuration > 127) {
            curDuration = 127;
        }
        byte[] sequence = new byte[]{-2, 1, -3, 30, -4, 64, -8, (byte)volume, (byte)note, (byte)curDuration};
        Player p = null;
        try {
            p = Manager.createPlayer("device://tone");
            p.realize();
        }
        catch (IOException ioe) {
            throw new MediaException(ioe);
        }
        ToneControl toneControl = (ToneControl)p.getControl("ToneControl");
        toneControl.setSequence(sequence);
        return p;
    }
}

