/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.EventList;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ToneSequence {
    private static final String TAG = ToneSequence.class.getName();
    private byte[] toneSequence;
    private MidiSequence midiSequence;
    private EventList eventList;

    public ToneSequence(byte[] sequence) {
        this.toneSequence = sequence;
        this.midiSequence = new MidiSequence(0, 39);
        this.eventList = new EventList(this.toneSequence, this.midiSequence);
    }

    public void process() {
        this.eventList.reset();
        if (this.toneSequence.length % 2 != 0) {
            throw new IllegalArgumentException("Illegal sequence, tone sequence must be multiple of single tone event size (2)");
        }
        int checkPos = 0;
        if (this.toneSequence[checkPos] != -2 || this.toneSequence[checkPos + 1] != 1) {
            throw new IllegalArgumentException("Illegal sequence, first two bytes must belong to version");
        }
        if (this.toneSequence[checkPos += 2] == -3) {
            this.midiSequence.setTempo(this.toneSequence[checkPos + 1]);
            checkPos += 2;
        }
        if (this.toneSequence[checkPos] == -4) {
            this.midiSequence.setResolution(this.toneSequence[checkPos + 1]);
            checkPos += 2;
        }
        int count = 0;
        while (checkPos < this.toneSequence.length) {
            count = this.eventList.validate(checkPos);
            checkPos += count;
            if (count != 0) continue;
            if (checkPos == this.toneSequence.length) break;
            throw new IllegalArgumentException("Validation failed, sequence corrupted");
        }
        int position = 0;
        for (int i2 = this.toneSequence.length - 2; i2 >= 0; i2 -= 2) {
            if (this.toneSequence[i2] < -9) {
                throw new IllegalArgumentException("Illegal sequence, lower value command than ToneControl.REPEAT found");
            }
            if (this.toneSequence[i2] >= -1 || this.toneSequence[i2] == -7 || this.toneSequence[i2] == -8 || this.toneSequence[i2] == -9) continue;
            position = i2 + 2;
            break;
        }
        if (position < 2) {
            throw new IllegalArgumentException("Illegal sequence, no start position found");
        }
        count = 0;
        try {
            while (position > 0 && position < this.toneSequence.length) {
                count = this.eventList.advance(position);
                position += count;
                if (count != 0) continue;
                if (position == this.toneSequence.length) break;
                throw new IllegalArgumentException("Validation failed, sequence corrupted");
            }
        }
        catch (MidiSequenceException mse) {
            System.err.println(TAG + ": MMA: ToneSequence: MIDI maximum lenght reached.");
        }
    }

    public ByteArrayInputStream getStream() throws IOException {
        return this.midiSequence.getStream();
    }

    public byte[] getByteArray() throws IOException {
        return this.midiSequence.getByteArray();
    }

    public long getDuration() {
        return this.midiSequence.getCumulativeDuration();
    }
}

