/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.tone;

import emulator.media.tone.Event;
import emulator.media.tone.MidiSequence;
import emulator.media.tone.MidiSequenceException;

public class VolumeEvent
extends Event {
    VolumeEvent(byte[] sequence, MidiSequence midiSequence) {
        super(sequence, midiSequence);
    }

    @Override
    public int advance(int position) throws MidiSequenceException {
        int retVal = this.doValidate(position);
        if (retVal == 0) {
            return 0;
        }
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        float vol = 1.27f * (float)data;
        byte volume = (byte)vol;
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 127) {
            volume = 127;
        }
        this.midiSequence.writeMidiEvent(0, (byte)-80, (byte)7, volume);
        return 2;
    }

    @Override
    protected int doValidate(int position) throws IllegalArgumentException {
        byte type = this.sequence[position];
        byte data = this.sequence[position + 1];
        int retVal = 0;
        if (type == -8) {
            if (data < 0 || data > 100) {
                throw new IllegalArgumentException("Volume is out of range, valid range is  0 <= volume <= 100");
            }
            retVal = 2;
        }
        return retVal;
    }

    @Override
    protected void checkEventAtNextPosition(int position) throws IllegalArgumentException {
        byte type = 0;
        try {
            type = this.sequence[position];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return;
        }
        if (type >= -1 || type == -6 || type == -7 || type == -8 || type == -9) {
            return;
        }
        throw new IllegalArgumentException("Illegal event found; sequence is corrupted");
    }
}

