/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.vlc;

import emulator.media.vlc.VLCPlayerImpl;
import javax.microedition.media.control.RateControl;

class RateControlImpl
implements RateControl {
    private final VLCPlayerImpl player;
    private static final int MAX_RATE = 200000;
    private static final int MIN_RATE = 50000;

    RateControlImpl(VLCPlayerImpl player) {
        this.player = player;
    }

    @Override
    public int getMaxRate() {
        return 200000;
    }

    @Override
    public int getMinRate() {
        return 50000;
    }

    @Override
    public int getRate() {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        return (int)(this.player.mediaPlayer.status().rate() * 100000.0f);
    }

    @Override
    public int setRate(int millirate) {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (millirate > 200000) {
            millirate = 200000;
        }
        if (millirate < 50000) {
            millirate = 50000;
        }
        this.player.mediaPlayer.controls().setRate((float)millirate / 100000.0f);
        return this.getRate();
    }
}

