/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.vlc;

import emulator.Emulator;
import emulator.Settings;
import emulator.graphics2D.awt.AWTImageUtils;
import emulator.graphics2D.awt.ImageAWT;
import emulator.media.vlc.MetaDataControlImpl;
import emulator.media.vlc.RateControlImpl;
import emulator.media.vlc.StopTimeControlImpl;
import emulator.media.vlc.VLCCallbackSourceStream;
import emulator.media.vlc.VLCCallbackStream;
import emulator.media.vlc.VideoControlImpl;
import emulator.media.vlc.VolumeControlImpl;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerImpl;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.media.protocol.DataSource;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.CallbackVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapters;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.format.RV32BufferFormat;

public class VLCPlayerImpl
implements Player,
MediaPlayerEventListener {
    private static VLCPlayerImpl inst;
    private Control[] controls;
    private String contentType;
    private int state;
    public int dataLen;
    private Vector listeners;
    private TimeBase timeBase;
    private String url;
    private String mediaUrl;
    private InputStream inputStream;
    private boolean playing;
    Object canvas;
    public boolean isItem;
    public int displayX;
    public int displayY;
    public int width;
    public int height;
    public boolean visible = true;
    public int sourceWidth;
    public int sourceHeight;
    public boolean fullscreen;
    private boolean prepared;
    public int bufferWidth;
    public int bufferHeight;
    private static MediaPlayerFactory factory;
    EmbeddedMediaPlayer mediaPlayer;
    public BufferedImage img;
    public ByteBuffer bb;
    boolean released;
    private DataSource dataSource;
    private boolean lengthNotified;
    int volume = -1;
    private CallbackMedia mediaCallback;
    private File tempFile;
    private boolean started;
    private VideoControl videoControl;
    private VolumeControl volumeControl;
    private RateControl rateControl;
    private StopTimeControl stopTimeControl;
    private MetaDataControl metaDataControl;
    long stopTime = Long.MAX_VALUE;
    private boolean stoppedAtTime;
    private final Object vlcLock = new Object();

    private VLCPlayerImpl() {
        this.listeners = new Vector();
        this.videoControl = new VideoControlImpl(this);
        this.volumeControl = new VolumeControlImpl(this);
        this.rateControl = new RateControlImpl(this);
        this.stopTimeControl = new StopTimeControlImpl(this);
        this.metaDataControl = new MetaDataControlImpl(this);
        this.controls = new Control[]{this.videoControl, this.volumeControl, this.rateControl, this.stopTimeControl};
        this.timeBase = Manager.getSystemTimeBase();
        if (Settings.enableMediaDump) {
            PlayerImpl.players.add(this);
        }
    }

    public VLCPlayerImpl(String url) throws IOException {
        this();
        if (url.startsWith("file:///root/")) {
            url = "file:///" + (Emulator.getUserPath() + "/file/root/" + url.substring("file:///root/".length())).replace(" ", "%20");
        }
        this.url = url;
        this.mediaUrl = url;
        this.state = 100;
    }

    public VLCPlayerImpl(InputStream inputStream, String type) throws IOException {
        this();
        this.contentType = type;
        this.inputStream = inputStream;
        this.state = 100;
    }

    public VLCPlayerImpl(String contentType, DataSource src) throws IOException {
        this();
        this.contentType = contentType;
        this.dataSource = src;
        this.state = 100;
    }

    public VLCPlayerImpl(String locator, String contentType, DataSource src) throws IOException {
        this();
        if (locator.startsWith("file:///root/")) {
            locator = "file:///" + (Emulator.getUserPath() + "/file/root/" + this.url.substring("file:///root/".length())).replace(" ", "%20");
        }
        this.url = locator;
        this.mediaUrl = locator;
        this.state = 100;
        this.dataSource = src;
    }

    public VLCPlayerImpl(String url, String contentType) throws IOException {
        this();
        if (url.startsWith("file:///root/")) {
            url = "file:///" + (Emulator.getUserPath() + "/file/root/" + url.substring("file:///root/".length())).replace(" ", "%20");
        }
        this.url = url;
        this.mediaUrl = url;
        this.contentType = contentType;
        this.state = 100;
    }

    public static void draw(Graphics g, Object obj) {
        if (inst == null || obj != VLCPlayerImpl.inst.canvas) {
            return;
        }
        inst.paint(g);
    }

    private void paint(Graphics g) {
        if (this.visible && this.img != null && this.playing) {
            if (this.width == 0 || this.height == 0) {
                this.width = Emulator.getEmulator().getScreen().getWidth();
                this.height = Emulator.getEmulator().getScreen().getHeight();
                this.fullscreen = true;
            }
            try {
                if (this.fullscreen) {
                    if (this.width != Emulator.getEmulator().getScreen().getWidth() || this.height != Emulator.getEmulator().getScreen().getHeight()) {
                        this.width = Emulator.getEmulator().getScreen().getWidth();
                        this.height = Emulator.getEmulator().getScreen().getHeight();
                    }
                    BufferedImage bi = AWTImageUtils.resizeProportional(this.img, this.width, this.height);
                    Image draw = VLCPlayerImpl.awtImgToLcdui(bi);
                    int x = 0;
                    int y = 0;
                    if (draw.getWidth() < this.width) {
                        x = (this.width - draw.getWidth()) / 2;
                    }
                    if (draw.getHeight() < this.height) {
                        y = (this.height - draw.getHeight()) / 2;
                    }
                    g.drawImage(draw, x, y, 0);
                } else {
                    g.setColor(0);
                    g.fillRect(this.displayX, this.displayY, this.width, this.height);
                    BufferedImage bi = AWTImageUtils.resize(this.img, this.width, this.height);
                    Image draw = VLCPlayerImpl.awtImgToLcdui(bi);
                    int x = this.displayX;
                    int y = this.displayY;
                    g.drawImage(draw, x, y, 0);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private static Image awtImgToLcdui(BufferedImage img) {
        return new Image(new ImageAWT(img));
    }

    static byte[] imgToBytes(BufferedImage img) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.5f);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(img, null, null), iwp);
            writer.dispose();
            byte[] bytes = os.toByteArray();
            os.close();
            return bytes;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public Control getControl(String s) {
        if (s.contains("GUIControl") || s.contains("VideoControl")) {
            return this.videoControl;
        }
        if (s.contains("VolumeControl")) {
            return this.volumeControl;
        }
        if (s.contains("RateControl")) {
            return this.rateControl;
        }
        if (s.contains("StopTimeControl")) {
            return this.stopTimeControl;
        }
        if (s.contains("MetaDataControl")) {
            return this.metaDataControl;
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return this.controls;
    }

    @Override
    public void addPlayerListener(PlayerListener p0) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (p0 != null) {
            this.listeners.add(p0);
        }
    }

    private void load() throws MediaException {
        if (this.mediaUrl == null) {
            if (this.dataSource != null) {
                try {
                    this.dataSource.connect();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new MediaException(e2);
                }
            }
            if (this.inputStream != null) {
                if (this.inputStream instanceof FileInputStream) {
                    try {
                        Field field = this.inputStream.getClass().getDeclaredField("path");
                        field.setAccessible(true);
                        String path = (String)field.get(this.inputStream);
                        File f2 = new File(path);
                        this.mediaUrl = path;
                        this.dataLen = (int)f2.length();
                        this.prepared = true;
                        return;
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                try {
                    if (this.inputStream instanceof ByteArrayInputStream) {
                        this.dataLen = this.inputStream.available();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mediaCallback = new VLCCallbackStream(this.inputStream, (long)this.dataLen);
            } else if (this.dataSource != null) {
                this.mediaCallback = new VLCCallbackSourceStream(this.dataSource);
            }
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prefetch() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException("closed");
        }
        if (this.state == 100) {
            this.realize();
        } else if (this.state != 200) {
            return;
        }
        if (!this.prepared) {
            Object object = this.vlcLock;
            synchronized (object) {
                this.load();
                try {
                    if (this.mediaCallback != null) {
                        if (!this.mediaPlayer.media().prepare(this.mediaCallback, new String[0])) {
                            Manager.log("Failed to prepare");
                            throw new MediaException("failed to prepare");
                        }
                    } else if (!this.mediaPlayer.media().prepare(this.mediaUrl, new String[0])) {
                        Manager.log("Failed to prepare");
                        throw new MediaException("failed to prepare");
                    }
                }
                catch (MediaException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new MediaException(e3);
                }
            }
            this.prepared = true;
        }
        this.state = 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realize() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException("closed");
        }
        if (this.state >= 200) {
            return;
        }
        inst = this;
        try {
            if (factory == null) {
                factory = new MediaPlayerFactory();
            }
            Object object = this.vlcLock;
            synchronized (object) {
                this.mediaPlayer = factory.mediaPlayers().newEmbeddedMediaPlayer();
                this.mediaPlayer.events().addMediaPlayerEventListener(this);
                this.mediaPlayer.videoSurface().set(new MyVideoSurface());
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            throw new MediaException(e2);
        }
        if (this.state == 100) {
            this.state = 200;
        }
    }

    @Override
    public void close() {
        if (this.state == 0) {
            return;
        }
        PlayerImpl.players.remove(this);
        this.state = 0;
        if (inst == this) {
            inst = null;
        }
        if (this.playing) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.released = true;
        if (this.dataSource != null) {
            this.dataSource.disconnect();
        }
        this.state = 0;
        this.notifyListeners("closed", null);
    }

    @Override
    public void deallocate() throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("closed");
        }
        PlayerImpl.players.remove(this);
        if (this.playing) {
            try {
                this.stop();
                return;
            }
            catch (MediaException ex) {
                return;
            }
        }
        this.released = true;
        if (this.state == 300) {
            this.state = 200;
        } else {
            if (this.state != 200) {
                return;
            }
            this.state = 100;
        }
        this.dataSource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException("closed");
        }
        if (this.state == 100) {
            this.realize();
        }
        if (this.released) {
            throw new IllegalStateException("mediaPlayer released");
        }
        if (this.state != 400) {
            if (!this.prepared) {
                this.prefetch();
            }
            PlayerImpl.players.add(this);
            Object object = this.vlcLock;
            synchronized (object) {
                this.mediaPlayer.controls().start();
            }
            if (this.volume == -1) {
                this.volume = 50;
                this.notifyListeners("volumeChanged", 50);
                object = this.vlcLock;
                synchronized (object) {
                    this.mediaPlayer.audio().setVolume(this.volume);
                }
            }
            this.playing = true;
            this.state = 400;
        }
    }

    private void update() {
        Emulator.getEventQueue().queueRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException("closed");
        }
        if (this.playing) {
            Object object = this.vlcLock;
            synchronized (object) {
                this.mediaPlayer.controls().pause();
            }
            if (this.state == 400) {
                this.state = 300;
            }
            this.playing = false;
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getDuration() {
        if (this.released || this.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (this.mediaPlayer.status() == null) {
            return -1L;
        }
        return this.mediaPlayer.status().length() * 1000L;
    }

    @Override
    public long getMediaTime() {
        if (this.released || this.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (this.mediaPlayer.status() == null) {
            return -1L;
        }
        return this.mediaPlayer.status().time() * 1000L;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void removePlayerListener(PlayerListener p0) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (p0 != null) {
            this.listeners.remove(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setMediaTime(long p0) throws MediaException {
        Object object = this.vlcLock;
        synchronized (object) {
            this.mediaPlayer.controls().setTime(p0 / 1000L);
        }
        return this.mediaPlayer.status().time() * 1000L;
    }

    public Object getItem() {
        return null;
    }

    protected void notifyListeners(String s, Object o) {
        if ("started".equals(s)) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        if ("stopped".equals(s) || "endOfMedia".equals(s)) {
            if (!Settings.enableMediaDump) {
                PlayerImpl.players.remove(this);
            }
            if (this.state == 400) {
                this.state = 300;
            }
            this.started = false;
        }
        if (this.released || this.listeners == null) {
            return;
        }
        try {
            Enumeration elements = this.listeners.elements();
            while (elements.hasMoreElements()) {
                ((PlayerListener)elements.nextElement()).playerUpdate(this, s.intern(), o);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoopCount(int p0) {
        if (p0 == -1) {
            Object object = this.vlcLock;
            synchronized (object) {
                this.mediaPlayer.controls().setRepeat(true);
            }
        }
    }

    @Override
    public void setTimeBase(TimeBase tb) throws MediaException {
        if (this.state == 100 || this.state == 400 || this.state == 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public TimeBase getTimeBase() {
        if (this.state == 100 || this.state == 0) {
            throw new IllegalStateException();
        }
        return this.timeBase;
    }

    @Override
    public void audioDeviceChanged(MediaPlayer arg0, String arg1) {
        this.notifyListeners("vlc.audioDeviceChanged", arg1);
    }

    @Override
    public void backward(MediaPlayer arg0) {
    }

    @Override
    public void buffering(MediaPlayer arg0, float arg1) {
        this.notifyListeners("vlc.buffering", new Double(arg1));
    }

    @Override
    public void chapterChanged(MediaPlayer arg0, int arg1) {
        this.notifyListeners("vlc.chapterChanged", arg1);
    }

    @Override
    public void corked(MediaPlayer arg0, boolean arg1) {
    }

    @Override
    public void elementaryStreamAdded(MediaPlayer arg0, TrackType arg1, int arg2) {
    }

    @Override
    public void elementaryStreamDeleted(MediaPlayer arg0, TrackType arg1, int arg2) {
    }

    @Override
    public void elementaryStreamSelected(MediaPlayer arg0, TrackType arg1, int arg2) {
    }

    @Override
    public void forward(MediaPlayer arg0) {
    }

    @Override
    public void lengthChanged(MediaPlayer arg0, long arg1) {
        if (!this.lengthNotified) {
            this.lengthNotified = true;
            return;
        }
        this.notifyListeners("durationUpdated", arg1);
    }

    @Override
    public void mediaChanged(MediaPlayer arg0, MediaRef arg1) {
        this.notifyListeners("vlc.mediaChanged", arg1.toString());
    }

    @Override
    public void mediaPlayerReady(MediaPlayer arg0) {
        this.notifyListeners("vlc.mediaPlayerReady", null);
    }

    @Override
    public void muted(MediaPlayer arg0, boolean arg1) {
    }

    @Override
    public void opening(MediaPlayer arg0) {
    }

    @Override
    public void pausableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void paused(MediaPlayer arg0) {
        if (this.released) {
            return;
        }
        this.state = 300;
        if (this.stoppedAtTime) {
            this.notifyListeners("stoppedAtTime", this.getMediaTime());
            this.stoppedAtTime = false;
            return;
        }
        this.notifyListeners("stopped", this.getMediaTime());
    }

    @Override
    public void positionChanged(MediaPlayer arg0, float arg1) {
    }

    @Override
    public void scrambledChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void seekableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void snapshotTaken(MediaPlayer arg0, String arg1) {
        this.notifyListeners("vlc.snapshotTaken", arg1);
    }

    @Override
    public void stopped(MediaPlayer arg0) {
        if (this.released) {
            return;
        }
        this.state = 300;
        if (this.stoppedAtTime) {
            this.notifyListeners("stoppedAtTime", this.getMediaTime());
            this.stoppedAtTime = false;
            return;
        }
        this.notifyListeners("stopped", this.getMediaTime());
    }

    @Override
    public void timeChanged(MediaPlayer arg0, long time) {
        if (this.stopTime != Long.MAX_VALUE && time >= this.stopTime / 1000L && time <= this.stopTime / 1000L + 1000L) {
            this.stoppedAtTime = true;
            try {
                this.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    @Override
    public void titleChanged(MediaPlayer arg0, int arg1) {
        this.notifyListeners("vlc.titleChanged", arg1);
    }

    @Override
    public void videoOutput(MediaPlayer arg0, int arg1) {
        int w = this.sourceWidth;
        int h2 = this.sourceHeight;
        this.sourceHeight = this.mediaPlayer.video().videoDimension().height;
        this.sourceWidth = this.mediaPlayer.video().videoDimension().width;
        if (w != this.sourceWidth || h2 != this.sourceHeight) {
            this.notifyListeners("sizeChanged", this.videoControl);
        }
    }

    @Override
    public void volumeChanged(MediaPlayer arg0, float arg1) {
        this.notifyListeners("com.nokia.external.volume.event", (int)(arg1 * 100.0f));
    }

    @Override
    public void finished(MediaPlayer mediaPlayer) {
        this.state = 300;
        this.notifyListeners("endOfMedia", this.getMediaTime());
    }

    @Override
    public void error(MediaPlayer mediaPlayer) {
        Manager.log("vlcplayer error");
        this.notifyListeners("error", null);
    }

    @Override
    public void playing(MediaPlayer mediaPlayer) {
        Manager.log("vlcplayer started");
        this.notifyListeners("started", this.getMediaTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        if (this.mediaPlayer == null) {
            return;
        }
        try {
            Object object = this.vlcLock;
            synchronized (object) {
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.released = true;
    }

    private class MyRenderCallback
    implements RenderCallback {
        private MyRenderCallback() {
        }

        @Override
        public void display(MediaPlayer mediaPlayer, ByteBuffer[] buffers, BufferFormat bufferFormat) {
            VLCPlayerImpl.this.bb.rewind();
            byte[] raw = new byte[VLCPlayerImpl.this.bb.capacity()];
            VLCPlayerImpl.this.bb.get(raw);
            DataBufferByte buffer = new DataBufferByte(raw, raw.length);
            ComponentSampleModel sampleModel = new ComponentSampleModel(0, VLCPlayerImpl.this.bufferWidth, VLCPlayerImpl.this.bufferHeight, 4, VLCPlayerImpl.this.bufferWidth * 4, new int[]{2, 1, 0});
            Raster r = Raster.createRaster(sampleModel, buffer, null);
            if (VLCPlayerImpl.this.img == null || VLCPlayerImpl.this.img.getWidth() != VLCPlayerImpl.this.bufferWidth || VLCPlayerImpl.this.img.getHeight() != VLCPlayerImpl.this.bufferHeight) {
                VLCPlayerImpl.this.img = new BufferedImage(VLCPlayerImpl.this.bufferWidth, VLCPlayerImpl.this.bufferHeight, 5);
            }
            VLCPlayerImpl.this.img.setData(r);
            VLCPlayerImpl.this.update();
        }
    }

    private class MyBufferFormatCallback
    implements BufferFormatCallback {
        private MyBufferFormatCallback() {
        }

        @Override
        public BufferFormat getBufferFormat(int w, int h2) {
            VLCPlayerImpl.this.bufferWidth = w;
            VLCPlayerImpl.this.bufferHeight = h2;
            return new RV32BufferFormat(w, h2);
        }

        @Override
        public void allocatedBuffers(ByteBuffer[] buffers) {
            VLCPlayerImpl.this.bb = buffers[0];
            VLCPlayerImpl.this.img = new BufferedImage(VLCPlayerImpl.this.bufferWidth, VLCPlayerImpl.this.bufferHeight, 5);
        }
    }

    private class MyVideoSurface
    extends CallbackVideoSurface {
        MyVideoSurface() {
            super(new MyBufferFormatCallback(), new MyRenderCallback(), true, VideoSurfaceAdapters.getVideoSurfaceAdapter());
        }
    }
}

